/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PipedInputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import redlight.client.Machine;
import redlight.client.TransferInterface;

public abstract class AbstractViewInterface
implements Runnable {
    Machine rlm;
    JFrame f = new JFrame();
    JPanel contentPane = new JPanel();
    PipedInputStream inputPipe;
    String filename;
    long total;
    TransferInterface transferInterface;

    public AbstractViewInterface(Machine machine, TransferInterface transferInterface, String type, String filename, long total, PipedInputStream inputPipe) {
        this.setContent(machine, transferInterface, type, filename, total, inputPipe);
        this.f.getContentPane().setLayout(new BorderLayout());
        this.f.getContentPane().add((Component)this.contentPane, "Center");
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Cancel")) {
                    AbstractViewInterface.this.closeWindow();
                }
            }
        }, "Cancel", KeyStroke.getKeyStroke(27, 0), 2);
        this.f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AbstractViewInterface.this.closeWindow();
            }
        });
    }

    public void show() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.f.show();
    }

    public abstract void run();

    public void setContent(Machine rlm, TransferInterface transferInterface, String type, String filename, long total, PipedInputStream inputPipe) {
        this.rlm = rlm;
        this.transferInterface = transferInterface;
        this.inputPipe = inputPipe;
        this.total = total;
        this.filename = filename;
        this.f.setTitle("Viewing " + filename + " as " + type + " (" + rlm.getServerName() + ")");
    }

    void closeWindow() {
        this.transferInterface.close();
        this.f.dispose();
        this.f = null;
        this.contentPane = null;
        this.transferInterface = null;
        System.gc();
    }
}

