/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.io.File;
import java.io.IOException;
import redlight.client.AskNewFilename;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.ResumeActionListener;
import redlight.client.ResumeInterface;
import redlight.client.TransferInterface;
import redlight.hotline.HLProtocol;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;

public class DownloadInterface
extends TransferInterface {
    String remoteFile;
    HLProtocol.FileListComponent file;
    ResumeInterface resumeUI;
    File tempFile;

    public DownloadInterface(Machine machine, String path, HLProtocol.FileListComponent file) {
        this(machine, path, file, false);
    }

    public DownloadInterface(Machine machine, String path, HLProtocol.FileListComponent file, boolean autoResume) {
        super(machine, file.fileName);
        this.path = path;
        this.file = file;
        this.remoteFile = path;
        this.autoResume = autoResume;
        if (Main.iconFile != null) {
            this.info.setIcon(Main.iconFile.getIconForFile(file));
        }
        this.doRequest();
    }

    public void granted() {
        File destination = (File)Main.rlo.getProperty("Path.Downloads");
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (!destination.exists()) {
            this.rlm.getInterface().error("Cannot download because the directory " + destination + " could not be created.");
            this.close();
            return;
        }
        if (this.tempFile == null) {
            String qualifiedFilename = FilenameUtils.qualify(this.filename);
            File finalFile = new File(destination, qualifiedFilename);
            if (finalFile.exists()) {
                qualifiedFilename = AskNewFilename.ask(finalFile);
            }
            if (qualifiedFilename == null) {
                this.close();
                return;
            }
            if (this.interrupted) {
                return;
            }
            this.tempFile = new File(destination, qualifiedFilename + ".hpf");
        }
        try {
            this.localFile = MacFile.createMacFile((String)Main.rlo.getProperty("MacFileMethod"), this.tempFile, MacFile.READ_PERM | MacFile.WRITE_PERM);
        }
        catch (Exception ex) {
            this.rlm.getInterface().error("Could not download " + this.file.fileName + ": " + ex.getMessage());
            DebuggerOutput.stackTrace(ex);
            this.close();
        }
        this.resumeUI = new ResumeInterface(this.file.fileName, this.autoResume, new ResumeActionListener(){

            public boolean canResume() {
                return DownloadInterface.this.localFile.exists();
            }

            public void resumeCancelled() {
                if (!DownloadInterface.this.interrupted) {
                    DownloadInterface.this.close();
                }
            }

            public void resumeAnswered(boolean resume) {
                if (!resume) {
                    DownloadInterface.this.localFile.delete();
                }
                try {
                    DebuggerOutput.debug("DownloadInterface.confirm: requesting file download " + DownloadInterface.this.remoteFile);
                    DownloadInterface.this.setTransferTask(DownloadInterface.this.rlm.getHLC().requestFileDownload(DownloadInterface.this.remoteFile, DownloadInterface.this.localFile, DownloadInterface.this.meter));
                    DownloadInterface.this.info.setText(DownloadInterface.this.filename + "   [waiting for server to respond]        ");
                    DownloadInterface.this.repaintStatus();
                    DownloadInterface.this.closeLocalFile = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void stopMeter(int ref) {
        super.stopMeter(ref);
        File file = this.localFile.getFile();
        String parent = file.getParent();
        String name = file.getName();
        File newFile = new File(parent, name.substring(0, name.lastIndexOf(".hpf")));
        DebuggerOutput.debug("DownloadInterface.stopMeter: renaming " + file + " to " + newFile);
        this.localFile.renameTo(newFile);
    }

    protected void interrupt() {
        if (this.resumeUI != null) {
            this.resumeUI.interrupt();
        }
        super.interrupt();
    }
}

