/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import redlight.client.Child;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.graphics.Spinner;
import redlight.hotline.HLException;
import redlight.hotline.HLProtocol;
import redlight.utils.BytesFormat;
import redlight.utils.DebuggerOutput;
import redlight.utils.TextUtils;

public class FileInfoInterface
implements Child,
Runnable {
    Machine rlm;
    Container contentPane;
    JTextField filename;
    JTextArea comment;
    JTextArea infoHelpText;
    JTextArea commentsHelpText;
    JFrame f;
    JPopupMenu popupMenu;
    JButton save;
    JButton delete;
    JButton cancel;
    JLabel type;
    JLabel creator;
    JLabel size;
    JLabel created;
    JLabel modified;
    JScrollPane scrollPane;
    Spinner spinner;
    String path;
    HLProtocol.FileInfo fileinfo;
    Thread getter;
    SimpleDateFormat date_formatter;

    public FileInfoInterface(Machine machine, String p) {
        this.rlm = machine;
        this.path = p;
        this.date_formatter = new SimpleDateFormat("EEE, MMM dd, yyyy, kk:mm:ss");
        String lastitem = this.path.toString().substring(this.path.toString().lastIndexOf(58) + 1);
        ActionListener actionListener = new ActionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    if (e.getActionCommand().equals("Save")) {
                        FileInfoInterface.this.rlm.getHLC().requestFileInfoChange(FileInfoInterface.this.path, FileInfoInterface.this.filename.getText(), TextUtils.findAndReplace(FileInfoInterface.this.comment.getText(), "\n", "\r"));
                    } else if (!e.getActionCommand().equals("Delete")) {
                        // empty if block
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FileInfoInterface.this.close();
            }
        };
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame(lastitem + " (" + this.rlm.getServerName() + ")");
        this.contentPane = this.f.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel infoPanel = new JPanel();
        JPanel commentsPanel = new JPanel();
        this.infoHelpText = new JTextArea("Retrieving file info, please wait ...\n", 2, 20);
        this.commentsHelpText = new JTextArea("Retrieving comment ...\n", 2, 20);
        JLabel l1 = new JLabel("Name: ");
        JLabel l2 = new JLabel("Type: ");
        JLabel l3 = new JLabel("Creator: ");
        JLabel l4 = new JLabel("Size: ");
        JLabel l5 = new JLabel("Created: ");
        JLabel l6 = new JLabel("Modified: ");
        this.type = new JLabel("");
        this.creator = new JLabel("");
        this.size = new JLabel("");
        this.created = new JLabel("");
        this.modified = new JLabel("");
        JPanel buttonPanel = new JPanel();
        JPanel deleteButtonPanel = new JPanel();
        JPanel otherButtonPanel = new JPanel();
        this.spinner = new Spinner(Main.rlo.getImageSet("Spinner"), 100, 16, 16);
        this.filename = new JTextField(lastitem, 20);
        this.comment = new JTextArea(2, 20);
        this.scrollPane = new JScrollPane(this.comment);
        this.cancel = new JButton("Cancel");
        this.save = new JButton("Save");
        this.delete = new JButton("Delete");
        EmptyBorder emptyBorder = new EmptyBorder((Insets)Main.rlo.getProperty("BorderInsets"));
        TitledBorder lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "File info");
        CompoundBorder infoBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Comments");
        CompoundBorder commentsBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        infoPanel.setBorder(infoBorder);
        commentsPanel.setBorder(commentsBorder);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.registerKeyboardAction(actionListener, "Cancel", KeyStroke.getKeyStroke(27, 0), 2);
        this.contentPane.setLayout(gbl);
        otherButtonPanel.setLayout(new FlowLayout(2));
        infoPanel.setLayout(new GridBagLayout());
        commentsPanel.setLayout(new GridBagLayout());
        deleteButtonPanel.setLayout(new FlowLayout(0));
        this.type.setFont(guiFont);
        this.creator.setFont(guiFont);
        this.size.setFont(guiFont);
        this.created.setFont(guiFont);
        this.modified.setFont(guiFont);
        this.type.setForeground(this.infoHelpText.getForeground());
        this.creator.setForeground(this.infoHelpText.getForeground());
        this.size.setForeground(this.infoHelpText.getForeground());
        this.created.setForeground(this.infoHelpText.getForeground());
        this.modified.setForeground(this.infoHelpText.getForeground());
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        this.comment.setBackground(this.rlm.getSchemeColor("background"));
        this.comment.setForeground(this.rlm.getSchemeColor("foreground"));
        this.filename.setBackground(this.rlm.getSchemeColor("background"));
        this.filename.setForeground(this.rlm.getSchemeColor("foreground"));
        this.cancel.addActionListener(actionListener);
        this.save.addActionListener(actionListener);
        this.delete.addActionListener(actionListener);
        this.cancel.setMnemonic('C');
        this.save.setMnemonic('S');
        this.infoHelpText.setLineWrap(true);
        this.infoHelpText.setWrapStyleWord(true);
        this.infoHelpText.setOpaque(false);
        this.infoHelpText.setEditable(false);
        this.commentsHelpText.setLineWrap(true);
        this.commentsHelpText.setWrapStyleWord(true);
        this.commentsHelpText.setOpaque(false);
        this.commentsHelpText.setEditable(false);
        this.filename.setEnabled(false);
        this.type.setEnabled(false);
        this.creator.setEnabled(false);
        this.size.setEnabled(false);
        this.created.setEnabled(false);
        this.modified.setEnabled(false);
        this.comment.setEnabled(false);
        this.save.setEnabled(false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 12;
        gbc.weightx = 0.0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbc.gridwidth = 2;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 8, 0);
        infoPanel.add((Component)this.infoHelpText, gbc);
        gbc.insets = oldInsets;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        infoPanel.add((Component)l1, gbc);
        ++gbc.gridy;
        infoPanel.add((Component)l2, gbc);
        ++gbc.gridy;
        infoPanel.add((Component)l3, gbc);
        ++gbc.gridy;
        infoPanel.add((Component)l4, gbc);
        ++gbc.gridy;
        infoPanel.add((Component)l5, gbc);
        ++gbc.gridy;
        infoPanel.add((Component)l6, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.gridy = 1;
        infoPanel.add((Component)this.filename, gbc);
        gbc.gridy = -1;
        infoPanel.add((Component)this.type, gbc);
        infoPanel.add((Component)this.creator, gbc);
        infoPanel.add((Component)this.size, gbc);
        infoPanel.add((Component)this.created, gbc);
        infoPanel.add((Component)this.modified, gbc);
        gbc.anchor = 12;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 8, 0);
        commentsPanel.add((Component)this.commentsHelpText, gbc);
        gbc.insets = oldInsets;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        commentsPanel.add((Component)this.scrollPane, gbc);
        otherButtonPanel.add(this.cancel);
        otherButtonPanel.add(this.save);
        buttonPanel.add((Component)deleteButtonPanel, "West");
        buttonPanel.add((Component)otherButtonPanel, "East");
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        this.contentPane.add((Component)infoPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.contentPane.add((Component)commentsPanel, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 8);
        this.contentPane.add((Component)buttonPanel, gbc);
        SwingUtilities.getRootPane(this.f).setDefaultButton(this.save);
        this.f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FileInfoInterface.this.close();
            }
        });
        this.rlm.getInterface().registerChild(this);
        this.getter = new Thread(this);
        this.getter.start();
        this.f.setVisible(true);
    }

    public void run() {
        this.spinner.start();
        try {
            this.fileinfo = this.rlm.getHLC().getFileInfo(this.path);
            if (this.fileinfo != null) {
                this.infoHelpText.setText("To rename this file, type the new name and hit Save.");
                this.commentsHelpText.setText("To change this comment, type the new comment and hit Save.");
                this.filename.setText(this.fileinfo.name);
                this.type.setText(this.fileinfo.type);
                this.creator.setText(this.fileinfo.creator);
                this.size.setText(BytesFormat.format(this.fileinfo.size) + " (" + NumberFormat.getInstance().format(this.fileinfo.size) + " bytes)");
                this.created.setText(this.date_formatter.format(this.fileinfo.created.getTime()));
                this.modified.setText(this.date_formatter.format(this.fileinfo.modified.getTime()));
                this.comment.setText(TextUtils.findAndReplace(this.fileinfo.comment, "\r", "\n"));
                this.filename.setEnabled(true);
                this.type.setEnabled(true);
                this.creator.setEnabled(true);
                this.size.setEnabled(true);
                this.created.setEnabled(true);
                this.modified.setEnabled(true);
                this.comment.setEnabled(true);
                this.save.setEnabled(true);
            } else {
                this.close();
            }
        }
        catch (InterruptedException e) {
        }
        catch (HLException e) {
            this.close();
        }
        catch (IOException e) {
            this.close();
        }
        this.spinner.stop();
    }

    public void close() {
        DebuggerOutput.debug(this.getClass().getName() + ": close()");
        this.rlm.getInterface().unregisterChild(this);
        this.getter.interrupt();
        this.f.dispose();
    }

    public void displayPropertyChanged(String what, Object property) {
        if (!what.equals("listfont")) {
            this.comment.setBackground(this.rlm.getSchemeColor("background"));
            this.comment.setForeground(this.rlm.getSchemeColor("foreground"));
            this.filename.setBackground(this.rlm.getSchemeColor("background"));
            this.filename.setForeground(this.rlm.getSchemeColor("foreground"));
        }
        this.f.repaint();
    }
}

