/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import redlight.client.AboutInterface;
import redlight.client.BookmarkInterface;
import redlight.client.Connection;
import redlight.client.ConnectionInterface;
import redlight.client.Machine;
import redlight.client.ManualInterface;
import redlight.client.Options;
import redlight.client.OptionsInterface;
import redlight.client.SharingInterface;
import redlight.client.Shell;
import redlight.client.TrackerInterface;
import redlight.hotline.HLBookmarkFile;
import redlight.hotline.HLIconFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.SystemEventHandler;
import redlight.utils.SystemEvents;
import redlight.utils.TextUtils;

public class Main {
    static Vector shells;
    static Vector machines;
    static String[] hosts;
    static File CONFIGURATION_DIRECTORY;
    static File CONFIGURATION_FILE;
    static File ICON_FILE;
    static String lSep;
    static String VERSION;
    static String LEGALESE;
    static Shell activeShell;
    public static int activeTransfers;
    static SystemEvents systemEvents;
    static Options rlo;
    static TrackerInterface tubeTracker;
    static BookmarkInterface tubeBookmarks;
    static OptionsInterface rloInterface;
    static ManualInterface tubeManualInterface;
    static AboutInterface tubeAboutInterface;
    static SharingInterface sharingInterface;
    static Dimension activeShellDimension;
    static Point activeShellLocation;
    static boolean quitting;
    static Vector startupConnections;
    static HLIconFile iconFile;

    public static void main(String[] args) {
        systemEvents.registerSystemEventHandler(new SystemEventHandler(){

            public void handleQuit() {
                boolean doQuit = false;
                if (activeTransfers > 0) {
                    int r = JOptionPane.showConfirmDialog(null, TextUtils.wordWrap("There are file transfers in progress, which will be interrupted when you quit now (although they may be resumed later). Are you sure you wish to quit?", 40), "Quit?", 0, 3);
                    if (r == 0) {
                        doQuit = true;
                    }
                } else {
                    doQuit = true;
                }
                if (!doQuit) {
                    return;
                }
                if (tubeTracker != null) {
                    tubeTracker.close();
                }
                if (tubeBookmarks != null) {
                    tubeBookmarks.close();
                }
                rlo.setProperty("WindowLocation.Main", activeShellLocation);
                rlo.setProperty("WindowDimension.Main", activeShellDimension);
                try {
                    rlo.store(CONFIGURATION_FILE);
                }
                catch (IOException ex) {
                    DebuggerOutput.debug("Exception writing Options: " + ex);
                }
                System.exit(0);
            }

            public void handleOpenDocument(File f) {
            }

            public void handlePrintDocument(File f) {
            }

            public void handleAbout() {
            }
        });
        shells = new Vector();
        machines = new Vector();
        startupConnections = new Vector();
        Main.parseArgs(args);
        if (!CONFIGURATION_DIRECTORY.exists() && !CONFIGURATION_DIRECTORY.mkdir()) {
            DebuggerOutput.debug("Could not create " + CONFIGURATION_DIRECTORY.toString() + ", exiting ...");
            System.exit(1);
        }
        rlo = new Options();
        if (CONFIGURATION_FILE.exists()) {
            rlo.load(CONFIGURATION_FILE);
        }
        if (rlo.getBooleanProperty("Toggle.ShowIcons") && ICON_FILE.exists()) {
            try {
                iconFile = new HLIconFile(ICON_FILE);
            }
            catch (IOException e) {
                iconFile = null;
            }
        }
        rlo.registerAudioClips(new String[]{"snd/login.au", "snd/userjoin.au", "snd/userleave.au", "snd/receivemsg.au", "snd/receivechat.au", "snd/error.au", "snd/filedone.au", "snd/receivenewspost.au"});
        rlo.registerImageSet("Spinner", new String[]{"img/801.gif", "img/802.gif", "img/803.gif", "img/804.gif", "img/805.gif", "img/806.gif", "img/807.gif", "img/808.gif"});
        rlo.registerImageSet("FunctionIcons", new String[]{"img/chat.gif", "img/news.gif", "img/file.gif", "img/message.gif", "img/stop.gif", "img/forbid.gif", "img/user.gif", "img/ul.gif", "img/dl.gif", "img/refresh.gif", "img/trash.gif", "img/folder.gif", "img/find.gif", "img/info.gif", "img/spacer.gif", "img/newuser.gif", "img/openuser.gif"});
        new Shell();
        if (rlo.getProperty("Home") != null) {
            startupConnections.addElement(rlo.getProperty("Home"));
        }
        Enumeration en = startupConnections.elements();
        while (en.hasMoreElements()) {
            Connection c = (Connection)en.nextElement();
            new ConnectionInterface(c.address, c.port, c.login, c.password, c.name);
        }
        startupConnections.removeAllElements();
    }

    static synchronized Shell getActiveShell() {
        return activeShell;
    }

    static synchronized void setActiveShell(Shell shell) {
        activeShell = shell;
        activeShellLocation = Main.activeShell.f.getLocationOnScreen();
        activeShellDimension = Main.activeShell.f.getSize();
    }

    static void addShell(Shell shell) {
        Vector vector = shells;
        synchronized (vector) {
            shells.addElement(shell);
        }
    }

    static void removeShell(Shell shell) {
        Vector vector = shells;
        synchronized (vector) {
            shells.removeElement(shell);
            if (activeShell == shell) {
                if (shells.size() > 0) {
                    activeShell = (Shell)shells.elementAt(shells.size() - 1);
                } else {
                    systemEvents.handleQuit();
                }
            }
        }
    }

    static void addMachine(Machine m) {
        machines.addElement(m);
    }

    static void removeMachine(Machine m) {
        machines.removeElement(m);
    }

    static Enumeration getMachines() {
        return machines.elements();
    }

    static void parseArgs(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals("-v") || argv[i].equals("--version")) {
                Main.printVersion();
                System.exit(0);
            } else if (argv[i].equals("-h") || argv[i].equals("--help")) {
                Main.printUsage();
                System.exit(0);
            } else if (argv[i].equals("-d") || argv[i].equals("--debug")) {
                DebuggerOutput.setEnabled(true);
            } else {
                Connection c = new Connection();
                File f = new File(argv[i]);
                if (!f.isAbsolute()) {
                    f = new File(System.getProperty("user.dir"), f.toString());
                }
                if (f.exists()) {
                    HLBookmarkFile bmf = new HLBookmarkFile(f);
                    try {
                        bmf.load();
                        c.address = bmf.get("address");
                        c.login = bmf.get("login");
                        c.password = bmf.get("password");
                        c.name = f.getName();
                    }
                    catch (IOException e) {
                        DebuggerOutput.debug(f + ": not a bookmark file.");
                        Main.printUsage();
                    }
                } else {
                    c.address = argv[i];
                    c.login = "guest";
                    c.password = "";
                    c.name = argv[i];
                }
                if (c.address.indexOf(":") != -1) {
                    c.port = new Integer(c.address.substring(c.address.lastIndexOf(":") + 1));
                    c.address = c.address.substring(0, c.address.lastIndexOf(":"));
                }
                startupConnections.addElement(c);
            }
            ++i;
        }
    }

    static void printUsage() {
        String s = LEGALESE + lSep + lSep + "Usage: rl [options] [FILE|HOST[:PORT]]..." + lSep + lSep + "Options:" + lSep + lSep + " -v, --version      display version information and exit" + lSep + " -h, --help         show this message and exit" + lSep + " -d, --debug        output lots of debugging information" + lSep + lSep + "FILE can be a relative or absolute path to a bookmark file." + lSep + "If FILE does not exist, then the argument is interpreted as" + lSep + "a hostname with an optional port specification." + lSep;
        Main.printVersion();
        System.out.print(s);
    }

    static void printVersion() {
        System.out.print(VERSION + lSep);
    }

    static {
        hosts = null;
        CONFIGURATION_DIRECTORY = new File(System.getProperty("user.home"), ".redlight");
        CONFIGURATION_FILE = new File(CONFIGURATION_DIRECTORY, "rl.conf");
        ICON_FILE = new File(CONFIGURATION_DIRECTORY, "hotline.dat");
        lSep = System.getProperty("line.separator");
        VERSION = "rl version 1.0 development, 25 october 2001" + lSep + "Options: " + "purejava 1.3 nosound" + lSep;
        LEGALESE = "rl (C) 1998 - 2001 Pascal Haakmat <groomed@users.sourceforge.net>" + lSep + "rl is free software, covered by the GNU General Public License." + lSep + "Modification and redistribution are encouraged. No warranty.";
        activeShell = null;
        activeTransfers = 0;
        systemEvents = new SystemEvents();
        rlo = null;
        tubeTracker = null;
        tubeBookmarks = null;
        rloInterface = null;
        tubeManualInterface = null;
        tubeAboutInterface = null;
        sharingInterface = null;
        quitting = false;
        iconFile = null;
    }
}

