/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import redlight.client.Main;
import redlight.utils.DebuggerOutput;

public class ManualInterface
implements WindowListener,
HyperlinkListener {
    Container contentPane;
    JFrame f = new JFrame("Red Light documentation");
    JEditorPane text;

    ManualInterface() {
        this.contentPane = this.f.getContentPane();
        this.contentPane.setLayout(new GridLayout(1, 1));
        try {
            this.text = new JEditorPane(ClassLoader.getSystemResource("redlight/Documentation/rl/index.html"));
        }
        catch (IOException e) {
            this.text = new JEditorPane("<b>An error occurred:</b> " + e.toString(), "text/html");
        }
        this.text.setEditable(false);
        this.text.addHyperlinkListener(this);
        this.text.setPreferredSize(new Dimension(550, 340));
        this.f.addWindowListener(this);
        this.contentPane.add(new JScrollPane(this.text));
        this.f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = new Dimension(550, 340);
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.f.show();
    }

    public void show() {
        if (this.f != null) {
            this.f.setVisible(true);
            this.f.toFront();
            return;
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.f.setVisible(false);
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void hyperlinkUpdate(final HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                if (e.getURL() == null) {
                    String location;
                    DebuggerOutput.debug(e.getDescription());
                    if (e.getDescription().startsWith("#")) {
                        location = new URL(this.text.getPage().toString() + e.getDescription()).toString();
                        DebuggerOutput.debug("newURL = " + location);
                    } else {
                        location = "text/manual/" + e.getDescription();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                ManualInterface.this.text.setPage(this.getClass().getResource(location));
                            }
                            catch (IOException e) {
                                DebuggerOutput.stackTrace(e);
                            }
                        }
                    });
                } else if (e.getURL().toString().startsWith("jar")) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                ManualInterface.this.text.setPage(e.getURL());
                            }
                            catch (IOException e2) {
                                DebuggerOutput.stackTrace(e2);
                            }
                        }
                    });
                } else {
                    String app = Main.rlo.getHelperApp(e.getURL());
                    if (app != null) {
                        String[] args = new String[]{app, e.getURL().toString()};
                        Runtime.getRuntime().exec(args);
                    }
                }
            }
            catch (IOException _e) {
                DebuggerOutput.stackTrace(_e);
            }
        }
    }
}

