/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import redlight.client.Main;
import redlight.client.Options;
import redlight.graphics.GraphicsUtils;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;

class OptionsPanel
extends JPanel
implements ActionListener {
    String[] macFileMethods = MacFile.getSupportedMacFileMethods();
    String defaultMFMethod = (String)Main.rlo.getProperty("MacFileMethod");
    JComboBox fontChoice;
    JComboBox listFontChoice;
    JComboBox macFileChoice;
    JCheckBox loadnews;
    JCheckBox queue;
    JCheckBox colors;
    JCheckBox joinleave;
    JCheckBox log;
    JCheckBox swallow;
    JCheckBox liveResize;
    JCheckBox showIcons;
    JTextField fontSize;
    JTextField listFontSize;

    OptionsPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.macFileChoice = this.createComboBox(this.macFileMethods, this.defaultMFMethod);
        this.fontChoice = this.createFontComboBox("Font.text");
        this.listFontChoice = this.createFontComboBox("Font.list");
        this.fontSize = new JTextField("", 2);
        this.listFontSize = new JTextField("", 2);
        this.queue = new JCheckBox("Queue downloads", true);
        this.loadnews = new JCheckBox("Load news", true);
        this.joinleave = new JCheckBox("Show join/leave in chat", true);
        this.log = new JCheckBox("Log chat by default", true);
        this.liveResize = new JCheckBox("Resize in real-time", true);
        this.showIcons = new JCheckBox("Show user icons", true);
        this.log.setToolTipText("Logs public and private chat to " + Main.CONFIGURATION_DIRECTORY + System.getProperty("file.separator") + "Log" + System.getProperty("file.separator"));
        this.queue.setToolTipText("Limits the number of simultaneous downloads per server to 1.");
        this.loadnews.setToolTipText("Loads news upon connecting. Slows down the connection process.");
        this.joinleave.setToolTipText("Shows user arrival and departure in the public chat.");
        this.liveResize.setToolTipText("Enables realtime interface updating. Needs a fast computer.");
        this.showIcons.setToolTipText("Shows user icons, turn off to save memory.");
        JPanel fontChoicePanel = new JPanel();
        fontChoicePanel.setLayout(new BorderLayout());
        fontChoicePanel.add((Component)this.fontChoice, "Center");
        fontChoicePanel.add((Component)this.fontSize, "East");
        JPanel listFontChoicePanel = new JPanel();
        listFontChoicePanel.setLayout(new BorderLayout());
        listFontChoicePanel.add((Component)this.listFontChoice, "Center");
        listFontChoicePanel.add((Component)this.listFontSize, "East");
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.addRow(new JLabel("Text font:"), fontChoicePanel, gbc);
        this.addRow(new JLabel("List font:"), listFontChoicePanel, gbc);
        this.addRow(new JLabel("Transfer method:"), this.macFileChoice, gbc);
        this.addRow(this.queue, this.joinleave, gbc);
        this.addRow(this.loadnews, this.liveResize, gbc);
        this.addRow(this.log, this.showIcons, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.addRow(Box.createGlue(), Box.createGlue(), gbc);
        this.setup(Main.rlo);
    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add(l, gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add(v, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
    }

    void setup(Options o) {
        this.setComboBoxDefault(this.fontChoice, ((Font)o.getProperty("Font.text")).getName());
        this.setComboBoxDefault(this.listFontChoice, ((Font)o.getProperty("Font.list")).getName());
        this.setComboBoxDefault(this.macFileChoice, o.getStringProperty("MacFileMethod"));
        this.fontSize.setText(new Integer(((Font)o.getProperty("Font.text")).getSize()).toString());
        this.listFontSize.setText(new Integer(((Font)o.getProperty("Font.list")).getSize()).toString());
        this.queue.setSelected(o.getBooleanProperty("Toggle.QueueDownloads"));
        this.loadnews.setSelected(o.getBooleanProperty("Toggle.LoadNews"));
        this.joinleave.setSelected(o.getBooleanProperty("Toggle.JoinLeave"));
        this.log.setSelected(o.getBooleanProperty("Toggle.Log"));
        this.liveResize.setSelected(o.getBooleanProperty("Toggle.LiveResizing"));
        this.showIcons.setSelected(o.getBooleanProperty("Toggle.ShowIcons"));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Save")) {
            try {
                Main.rlo.setProperty("Font.text", new Font((String)this.fontChoice.getSelectedItem(), 0, new Integer(this.fontSize.getText())));
            }
            catch (NumberFormatException ex) {
                System.out.println("Text font size not a number");
            }
            try {
                Main.rlo.setProperty("Font.list", new Font((String)this.listFontChoice.getSelectedItem(), 0, new Integer(this.listFontSize.getText())));
            }
            catch (NumberFormatException ex) {
                System.out.println("List font size not a number");
            }
            Main.rlo.setStringProperty("MacFileMethod", (String)this.macFileChoice.getSelectedItem());
            Main.rlo.setBooleanProperty("Toggle.LoadNews", this.loadnews.isSelected());
            Main.rlo.setBooleanProperty("Toggle.QueueDownloads", this.queue.isSelected());
            Main.rlo.setBooleanProperty("Toggle.JoinLeave", this.joinleave.isSelected());
            Main.rlo.setBooleanProperty("Toggle.Log", this.log.isSelected());
            Main.rlo.setBooleanProperty("Toggle.LiveResizing", this.liveResize.isSelected());
            Main.rlo.setBooleanProperty("Toggle.ShowIcons", this.showIcons.isSelected());
        }
    }

    void setComboBoxDefault(JComboBox comboBox, String def) {
        DebuggerOutput.debug("FIXME");
    }

    JComboBox createComboBox(String[] items, String def) {
        boolean setDefault = false;
        JComboBox<String> box = new JComboBox<String>();
        box.setEditable(false);
        box.setLightWeightPopupEnabled(true);
        int i = 0;
        while (i < items.length) {
            box.addItem(items[i]);
            if (items[i].equals(def)) {
                box.setSelectedIndex(i);
                setDefault = true;
            }
            ++i;
        }
        if (!setDefault) {
            box.setSelectedIndex(0);
        }
        return box;
    }

    JComboBox createFontComboBox(String whichFont) {
        String[] fontNames = GraphicsUtils.getAvailableFontFamilyNames();
        String defaultFontName = ((Font)Main.rlo.getProperty(whichFont)).getName();
        return this.createComboBox(fontNames, defaultFontName);
    }
}

