/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import redlight.hotline.AgreementRejectedException;
import redlight.hotline.BadMagicException;
import redlight.hotline.ComponentFactory;
import redlight.hotline.HLClientDispatcher;
import redlight.hotline.HLClientListener;
import redlight.hotline.HLException;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLTask;
import redlight.hotline.HLTaskNotFoundException;
import redlight.hotline.ReaderThread;
import redlight.hotline.Transfer;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.InterruptableInputStream;
import redlight.utils.Meter;
import redlight.utils.ToArrayConverters;

public class HLClient {
    InetAddress host;
    int port;
    Socket socket;
    DataOutputStream output;
    DataInputStream input;
    ReaderThread reader;
    HLClientDispatcher hlr;
    Hashtable tasks;
    Hashtable transfers;
    Vector hle;
    private static String default_nick = "Red Light library";
    private static String default_login = "";
    private static String default_password = "";
    private static short default_icon = (short)2015;
    String nick = default_nick;
    String login = default_login;
    String password = default_password;
    int icon = default_icon;
    boolean connected = false;
    boolean blocked = false;
    int transaction = 2;
    int serverVersion = 0;
    Integer closeLock = new Integer(0);
    HLProtocol hlp;

    public HLClient(String server) throws IOException {
        this(InetAddress.getByName(server), 5500);
    }

    public HLClient(InetAddress host) throws IOException {
        this(host, 5500);
    }

    public HLClient(String server, int port) throws IOException {
        this(InetAddress.getByName(server), port, default_login, default_password, default_nick, default_icon);
    }

    public HLClient(InetAddress host, int port) throws IOException {
        this(host, port, default_login, default_password, default_nick, default_icon);
    }

    public HLClient(String server, int port, String login, String password, String nick, short icon) throws UnknownHostException, IOException {
        this(InetAddress.getByName(server), port, login, password, nick, icon);
    }

    public HLClient(InetAddress h, int pr, String l, String ps, String n, short i) throws UnknownHostException, IOException {
        this.host = h;
        this.port = pr;
        this.login = l;
        this.password = ps;
        this.nick = n;
        this.icon = i;
        this.tasks = new Hashtable();
        this.transfers = new Hashtable();
        this.hle = new Vector();
        this.hlp = new HLProtocol();
        this.hlr = new HLClientDispatcher(this);
    }

    public void connect() throws IOException, BadMagicException {
        if (!this.connected) {
            this.connected = true;
            DebuggerOutput.debug("HLClient.connect: opening socket ...");
            this.socket = new Socket(this.host, (int)((char)this.port));
            DebuggerOutput.debug("HLClient.connect: socket opened");
            this.socket.setSoTimeout(1000);
            this.socket.setSoLinger(true, 5);
            this.output = new DataOutputStream(this.socket.getOutputStream());
            this.input = new DataInputStream(new InterruptableInputStream(this.socket.getInputStream()));
            this.output.writeBytes("TRTPHOTL\u0000\u0001\u0000\u0002");
            this.output.flush();
            DebuggerOutput.debug("HLClient.connect: wrote client magic");
            byte[] buf = new byte[8];
            this.input.readFully(buf, 0, 8);
            DebuggerOutput.debug("HLClient.connect: read server magic");
            if (!"TRTP\u0000\u0000\u0000\u0000".equals(new String(buf))) {
                this.socket.close();
                this.output = null;
                this.input = null;
                throw new BadMagicException("not a Hotline server: bad magic");
            }
            this.reader = new ReaderThread(this, this.input);
            this.reader.setBlocked(this.blocked);
            this.reader.setName("HLClient ReaderThread " + this.host.toString());
            this.reader.start();
            DebuggerOutput.debug("HLClient.connect: (" + this.getHost().toString() + ").");
        }
    }

    public void login() throws IOException, HLException, InterruptedException {
        this.login(this.login, this.password, this.nick, this.icon);
    }

    public void login(String login, String password, String nick, int icon) throws IOException, HLException, InterruptedException {
        if (login == null || password == null || nick == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.login = login;
        this.password = password;
        this.nick = nick;
        this.icon = icon;
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 105, HLProtocol.invert(login.getBytes())), new HLProtocol.DataComponent(this.hlp, 106, HLProtocol.invert(password.getBytes())), new HLProtocol.DataComponent(this.hlp, 102, nick.getBytes()), new HLProtocol.DataComponent(this.hlp, 104, ToArrayConverters.intToByteArray(icon))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 107, this.nextTrans(), dataComponents);
        HLTask task = this.createTask(packet, false);
        DebuggerOutput.debug("HLClient: writing login header");
        packet.write(this.output);
        DebuggerOutput.debug("HLClient: waiting for reply from login header");
        try {
            task.getData();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.disposeTask(packet.header.trans);
            throw throwable;
        }
        this.disposeTask(packet.header.trans);
        if (this.serverVersion >= 150) {
            try {
                this.hlr.waitForAgreement();
                if (!this.hlr.agreementAccepted) {
                    throw new AgreementRejectedException("agreement rejected");
                }
                this.sendAgree();
            }
            catch (InterruptedException e) {
                throw new HLException("wait for agreement interrupted");
            }
        }
    }

    public void close() throws IOException {
        this.setBlocked(false);
        if (this.reader != null) {
            this.reader.interrupt();
        }
        this.socketClose();
        if (this.reader != null) {
            try {
                DebuggerOutput.debug("HLClient.close: joining reader");
                this.reader.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.internalDisconnect();
        DebuggerOutput.debug("HLClient.close: (" + this.getHost().toString() + ").");
    }

    private synchronized void socketClose() throws IOException {
        if (this.socket != null) {
            DebuggerOutput.debug("HLClient.close: closing socket");
            this.socket.close();
            this.socket = null;
        }
        if (this.input != null) {
            DebuggerOutput.debug("HLClient.close: closing input");
            this.input.close();
            this.input = null;
        }
    }

    public synchronized void addHLClientListener(HLClientListener h) {
        this.hle.addElement(h);
    }

    public synchronized void removeHLClientListener(HLClientListener h) {
        this.hle.removeElement(h);
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNick() {
        return this.nick;
    }

    public int getIcon() {
        return this.icon;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    void setServerVersion(int v) {
        this.serverVersion = v;
    }

    public void setBlocked(boolean b) {
        this.blocked = b;
        if (this.reader != null) {
            this.reader.setBlocked(b);
        }
    }

    public int requestFileInfo(String path) throws IOException {
        return this.requestFileInfo(path, true);
    }

    public int requestFileInfo(String path, boolean disposeWhenReplyReceived) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        int trans = this.nextTrans();
        HLProtocol.DataComponent[] dataComponents = ComponentFactory.createPathComponents(path, (short)202, true);
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 206, trans, dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestAccountInfo(String login) throws IOException {
        return this.requestAccountInfo(login, true);
    }

    public int requestAccountInfo(String login, boolean disposeWhenReplyReceived) throws IOException {
        if (login == null) {
            throw new IllegalArgumentException("login == null");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 105, login.getBytes())};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 352, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestFileUpload(MacFile local, String remotePath, Meter meter, boolean resume) throws IOException {
        return this.requestFileUpload(local, remotePath, meter, resume, true);
    }

    public int requestFileUpload(MacFile local, String remotePath, Meter meter, boolean resume, boolean disposeWhenReplyReceived) throws IOException {
        if (meter == null) {
            throw new IllegalArgumentException("meter object cannot be null");
        }
        if (remotePath == null || local == null) {
            throw new IllegalArgumentException("null argument");
        }
        remotePath = remotePath + ':' + local.getFile().getName();
        HLProtocol.DataComponent[] pathComponents = ComponentFactory.createPathComponents(remotePath, (short)202, true);
        HLProtocol.FileTransferInfo fti = new HLProtocol.FileTransferInfo(this.hlp, local.getFile().getName(), local.getType(), local.getCreator(), local.getComment(), local.getCreationDate(), local.getModificationDate(), local.getFinderFlags());
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[resume ? 4 : 3];
        dataComponents[0] = new HLProtocol.DataComponent(this.hlp, 108, ToArrayConverters.intToByteArray(32 + fti.data.length + (int)local.getResourceSize() + (int)local.getDataSize()));
        dataComponents[1] = pathComponents[1];
        dataComponents[2] = pathComponents[0];
        if (resume) {
            dataComponents[3] = new HLProtocol.DataComponent(this.hlp, 204, ToArrayConverters.shortToByteArray(1));
        }
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 203, this.nextTrans(), dataComponents);
        Transfer tx = new Transfer();
        tx.local = local;
        tx.remote = remotePath;
        tx.local_data_size = local.getDataSize();
        tx.local_rsrc_size = local.getResourceSize();
        tx.remote_rsrc_size = 0L;
        tx.remote_data_size = 0L;
        tx.meter = meter;
        this.createTask(packet, disposeWhenReplyReceived);
        this.createTransfer(packet, tx);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestDataForkDownload(String path, PipedInputStream inputPipe, Meter meter) throws IOException {
        if (inputPipe == null) {
            throw new IllegalArgumentException("inputPipe == null");
        }
        return this.requestForkOrFileDownload(path, null, inputPipe, meter, 2, true);
    }

    public int requestFileDownload(String path, MacFile local, Meter meter) throws IOException {
        return this.requestFileDownload(path, local, meter, true);
    }

    public int requestFileDownload(String path, MacFile local, Meter meter, boolean disposeWhenReplyReceived) throws IOException {
        if (local == null) {
            throw new IllegalArgumentException("local == null");
        }
        return this.requestForkOrFileDownload(path, local, null, meter, 0, disposeWhenReplyReceived);
    }

    private int requestForkOrFileDownload(String path, MacFile local, PipedInputStream inputPipe, Meter meter, int forkOrFile, boolean disposeWhenReplyReceived) throws IOException {
        if (meter == null) {
            throw new IllegalArgumentException("meter object cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("null argument");
        }
        HLProtocol.DataComponent[] pathComponents = ComponentFactory.createPathComponents(path, (short)202, true);
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 204, ToArrayConverters.shortToByteArray(2)), pathComponents[1], pathComponents[0]};
        if (forkOrFile != 2) {
            dataComponents[0] = new HLProtocol.ResumeTransferComponent(this.hlp, local.getDataFork().size(), local.getResourceFork().size());
        }
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 202, this.nextTrans(), dataComponents);
        Transfer tx = new Transfer();
        tx.name = path;
        tx.local = local;
        tx.inputPipe = inputPipe;
        tx.remote = path;
        if (forkOrFile != 2) {
            tx.local_data_size = (int)local.getDataSize();
            tx.local_rsrc_size = (int)local.getResourceSize();
        }
        tx.remote_rsrc_size = 0L;
        tx.remote_data_size = 0L;
        tx.meter = meter;
        tx.forkOrFile = forkOrFile;
        this.createTask(packet, disposeWhenReplyReceived);
        this.createTransfer(packet, tx);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestFileList(String path) throws IOException {
        return this.requestFileList(path, true);
    }

    public int requestFileList(String path, boolean disposeWhenReplyReceived) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        HLProtocol.DataComponent[] pathComponents = ComponentFactory.createPathComponents(path, (short)202, false);
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{pathComponents[0]};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 200, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestUserList() throws IOException {
        return this.requestUserList(true);
    }

    public int requestUserList(boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 300, this.nextTrans(), null);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestNews() throws IOException {
        return this.requestNews(true);
    }

    public int requestNews(boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 101, this.nextTrans(), null);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestUserInfo(int sock) throws IOException {
        return this.requestUserInfo(sock, true);
    }

    public int requestUserInfo(int sock, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 103, ToArrayConverters.intToByteArray(sock))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 303, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public HLProtocol.AccountInfo getAccountInfo(String login) throws IOException, HLException, InterruptedException {
        Object o = this.waitFor(this.requestAccountInfo(login, false));
        return (HLProtocol.AccountInfo)o;
    }

    public HLProtocol.FileInfo getFileInfo(String path) throws IOException, HLException, InterruptedException {
        Object o = this.waitFor(this.requestFileInfo(path, false));
        return (HLProtocol.FileInfo)o;
    }

    public HLProtocol.FileListComponent[] getFileList(String path) throws IOException, HLException, InterruptedException {
        Object o = this.waitFor(this.requestFileList(path, false));
        return (HLProtocol.FileListComponent[])o;
    }

    public HLProtocol.UserListComponent[] getUserList() throws IOException, HLException, InterruptedException {
        Object o = this.waitFor(this.requestUserList(false));
        return (HLProtocol.UserListComponent[])o;
    }

    public String getNews() throws IOException, HLException, InterruptedException {
        Object o = this.waitFor(this.requestNews(false));
        return (String)o;
    }

    public String getUserInfo(int sock) throws IOException, HLException, InterruptedException {
        Object o = this.waitFor(this.requestUserInfo(sock, false));
        return (String)o;
    }

    public int requestFileInfoChange(String path, String newName, String newComment) throws IOException {
        return this.requestFileInfoChange(path, newName, newComment, true);
    }

    public int requestFileInfoChange(String path, String newName, String newComment, boolean disposeWhenReplyReceived) throws IOException {
        if (path == null || newName == null || newComment == null) {
            throw new IllegalArgumentException("null argument");
        }
        HLProtocol.DataComponent[] pathComponents = ComponentFactory.createPathComponents(path, (short)202, true);
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{pathComponents[1], pathComponents[0], new HLProtocol.DataComponent(this.hlp, 211, newName.getBytes()), new HLProtocol.DataComponent(this.hlp, 210, newComment.getBytes())};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 207, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    void sendAgree() throws IOException {
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 121, this.nextTrans(), null);
        packet.write(this.output);
    }

    public int requestFileMakeAlias(String source, String target) throws IOException {
        return this.requestFileMakeAlias(source, target, true);
    }

    public int requestFileMakeAlias(String source, String target, boolean disposeWhenReplyReceived) throws IOException {
        return this.requestFileMoveOrMakeAlias(209, source, target, disposeWhenReplyReceived);
    }

    public int requestFileMove(String source, String target) throws IOException {
        return this.requestFileMove(source, target, true);
    }

    public int requestFileMove(String source, String target, boolean disposeWhenReplyReceived) throws IOException {
        return this.requestFileMoveOrMakeAlias(208, source, target, disposeWhenReplyReceived);
    }

    private int requestFileMoveOrMakeAlias(int kind, String source, String target, boolean disposeWhenReplyReceived) throws IOException {
        if (source == null || target == null) {
            throw new IllegalArgumentException("null argument");
        }
        HLProtocol.DataComponent[] sourcePathComponents = ComponentFactory.createPathComponents(source, (short)202, true);
        HLProtocol.DataComponent[] targetPathComponents = ComponentFactory.createPathComponents(target, (short)212, false);
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{sourcePathComponents[1], sourcePathComponents[0], targetPathComponents[0]};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, kind, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestFileDelete(String path) throws IOException {
        return this.requestFileDelete(path, true);
    }

    public int requestFileDelete(String path, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] pathComponents = ComponentFactory.createPathComponents(path, (short)202, true);
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{pathComponents[1], pathComponents[0]};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 204, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestDirectoryCreate(String path) throws IOException {
        return this.requestDirectoryCreate(path, true);
    }

    public int requestDirectoryCreate(String path, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] pathComponents = ComponentFactory.createPathComponents(path, (short)202, true);
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{pathComponents[1], pathComponents[0]};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 205, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public void sendUserChange(String nick, int icon) throws IOException {
        if (nick == null) {
            throw new IllegalArgumentException("nick == null)");
        }
        this.nick = nick;
        this.icon = icon;
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 104, ToArrayConverters.charToByteArray((char)icon)), new HLProtocol.DataComponent(this.hlp, 102, nick.getBytes())};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 304, this.nextTrans(), dataComponents);
        packet.write(this.output);
    }

    public int requestAccountDelete(String login) throws IOException {
        return this.requestAccountDelete(login, true);
    }

    public int requestAccountDelete(String login, boolean disposeWhenReplyReceived) throws IOException {
        if (login == null) {
            throw new IllegalArgumentException("login == null)");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 105, HLProtocol.invert(login.getBytes()))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 351, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestAccountModify(String login, String password, String nick, long privileges) throws IOException {
        return this.requestAccountModify(login, password, nick, privileges, true);
    }

    public int requestAccountModify(String login, String password, String nick, long privileges, boolean disposeWhenReplyReceived) throws IOException {
        return this.requestAccountCreateOrModify(login, password, nick, privileges, 353, disposeWhenReplyReceived);
    }

    public int requestAccountCreate(String login, String password, String nick, long privileges) throws IOException {
        return this.requestAccountCreate(login, password, nick, privileges, true);
    }

    public int requestAccountCreate(String login, String password, String nick, long privileges, boolean disposeWhenReplyReceived) throws IOException {
        return this.requestAccountCreateOrModify(login, password, nick, privileges, 350, disposeWhenReplyReceived);
    }

    private int requestAccountCreateOrModify(String login, String password, String nick, long privileges, int packetType, boolean disposeWhenReplyReceived) throws IOException {
        if (login == null || nick == null) {
            throw new IllegalArgumentException("null argument");
        }
        byte[] p = password == null ? new byte[1] : HLProtocol.invert(password.getBytes());
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 105, HLProtocol.invert(login.getBytes())), new HLProtocol.DataComponent(this.hlp, 106, p), new HLProtocol.DataComponent(this.hlp, 102, nick.getBytes()), new HLProtocol.DataComponent(this.hlp, 110, ToArrayConverters.swapByteArray(ToArrayConverters.longToByteArray(privileges)))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, packetType, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public void sendChat(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 101, s.getBytes())};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 105, this.nextTrans(), dataComponents);
        packet.write(this.output);
    }

    public void sendChatAction(String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 101, s.getBytes()), new HLProtocol.DataComponent(this.hlp, 109, ToArrayConverters.shortToByteArray(1))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 105, this.nextTrans(), dataComponents);
        packet.write(this.output);
    }

    public int requestPrivateChatCreate(int sock) throws IOException {
        return this.requestPrivateChatCreate(sock, true);
    }

    public int requestPrivateChatCreate(int sock, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 103, ToArrayConverters.intToByteArray(sock))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 112, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestPrivateChatInvite(int pcref, int sock) throws IOException {
        return this.requestPrivateChatInvite(pcref, sock, true);
    }

    public int requestPrivateChatInvite(int pcref, int sock, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 103, ToArrayConverters.intToByteArray(sock)), new HLProtocol.DataComponent(this.hlp, 114, ToArrayConverters.intToByteArray(pcref))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 113, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestPrivateChatJoin(int pcref) throws IOException {
        return this.requestPrivateChatJoin(pcref, true);
    }

    public int requestPrivateChatJoin(int pcref, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 114, ToArrayConverters.intToByteArray(pcref))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 115, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public void sendPrivateChatDecline(int pcref) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 114, ToArrayConverters.intToByteArray(pcref))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 114, this.nextTrans(), dataComponents);
        packet.write(this.output);
    }

    public void sendPrivateChatLeave(int pcref) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 114, ToArrayConverters.intToByteArray(pcref))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 116, this.nextTrans(), dataComponents);
        packet.write(this.output);
    }

    public void sendPrivateChat(int pcref, String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 101, s.getBytes()), new HLProtocol.DataComponent(this.hlp, 114, ToArrayConverters.intToByteArray(pcref))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 105, this.nextTrans(), dataComponents);
        packet.write(this.output);
    }

    public void sendPrivateChatAction(int pcref, String s) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 109, ToArrayConverters.shortToByteArray(1)), new HLProtocol.DataComponent(this.hlp, 101, s.getBytes()), new HLProtocol.DataComponent(this.hlp, 114, ToArrayConverters.intToByteArray(pcref))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 105, this.nextTrans(), dataComponents);
        packet.write(this.output);
    }

    public int requestNewsPost(String s) throws IOException {
        return this.requestNewsPost(s, true);
    }

    public int requestNewsPost(String s, boolean disposeWhenReplyReceived) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 101, s.getBytes())};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 103, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestMessageSend(int sock, String s) throws IOException {
        return this.requestMessageSend(sock, s, true);
    }

    public int requestMessageSend(int sock, String s, boolean disposeWhenReplyReceived) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 103, ToArrayConverters.intToByteArray(sock)), new HLProtocol.DataComponent(this.hlp, 101, s.getBytes())};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 108, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestUserKick(int sock) throws IOException {
        return this.requestUserKick(sock, true);
    }

    public int requestUserKick(int sock, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 103, ToArrayConverters.intToByteArray(sock))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 110, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public int requestUserKickBan(int sock) throws IOException {
        return this.requestUserKickBan(sock, true);
    }

    public int requestUserKickBan(int sock, boolean disposeWhenReplyReceived) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[]{new HLProtocol.DataComponent(this.hlp, 113, ToArrayConverters.shortToByteArray(1)), new HLProtocol.DataComponent(this.hlp, 103, ToArrayConverters.intToByteArray(sock))};
        HLProtocol.Packet packet = new HLProtocol.Packet(this.hlp, 110, this.nextTrans(), dataComponents);
        this.createTask(packet, disposeWhenReplyReceived);
        packet.write(this.output);
        return packet.header.trans;
    }

    public Object waitFor(int id) throws HLException, IOException, InterruptedException {
        Object o = null;
        try {
            HLTask task = this.getTask(id);
            if (task.disposeWhenReceived) {
                throw new IllegalArgumentException("aborted attempted wait for task that has disposeWhenReceived flag set to true; unwise.");
            }
            o = task.getData();
            DebuggerOutput.debug("HLClient.waitFor[" + id + "]: got data.");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.disposeTask(id);
            throw throwable;
        }
        this.disposeTask(id);
        return o;
    }

    void fireDisconnect(String msg) {
        DebuggerOutput.debug("HLClient.fireDisconnect: accepted (reason = " + msg + ")");
        Enumeration en = this.hle.elements();
        while (en.hasMoreElements()) {
            HLClientListener l = (HLClientListener)en.nextElement();
            DebuggerOutput.debug("HLClient.fireDisconnect: invoking handleDisconnect on " + l);
            l.handleDisconnect(msg);
        }
    }

    private synchronized void internalDisconnect() {
        if (!this.connected) {
            DebuggerOutput.debug("HLClient.internalDisconnect: already disconnected.");
            return;
        }
        this.hlr.notifyAgreementAborted();
        DebuggerOutput.debug("HLClient.internalDisconnect: terminating tasks");
        this.terminateAllTasks("connection closed");
        DebuggerOutput.debug("HLClient.internalDisconnect: tasks terminated");
        this.connected = false;
        this.transaction = 2;
    }

    void terminateAllTasks(String msg) {
        Enumeration k = this.tasks.keys();
        while (k.hasMoreElements()) {
            int trans = (Integer)k.nextElement();
            if (!this.lockTask(trans)) continue;
            try {
                DebuggerOutput.debug("terminateAllTasks: terminating task " + this.getTask(trans).toString());
                HLTask task = this.getTask(trans);
                task.setError(new HLException(msg));
                if (!task.disposeWhenReceived) continue;
                this.disposeTask(trans);
            }
            catch (HLTaskNotFoundException e) {
                DebuggerOutput.stackTrace(e);
            }
        }
    }

    synchronized boolean lockTask(int trans) {
        boolean lockSucceeded = false;
        if (!this.tasks.containsKey(new Integer(trans))) {
            DebuggerOutput.debug("lockTask[" + trans + "]: task does not exist");
            return false;
        }
        try {
            HLTask task = this.getTask(trans);
            if (!task.isLocked()) {
                DebuggerOutput.debug("lockTask[" + trans + "]: task not locked, locking task ...");
                task.lock();
                DebuggerOutput.debug("lockTask[" + trans + "]: task locked.");
                lockSucceeded = true;
            } else {
                DebuggerOutput.debug("lockTask[" + trans + "]: task already locked, not locking");
            }
        }
        catch (HLTaskNotFoundException e) {
            DebuggerOutput.stackTrace(e);
        }
        return lockSucceeded;
    }

    synchronized int nextTrans() {
        return this.transaction++;
    }

    synchronized HLTask createTask(HLProtocol.Packet packet, boolean disposeWhenReplyReceived) throws IOException {
        if (!this.connected) {
            throw new IOException("not connected");
        }
        HLTask task = new HLTask(packet.header.id, disposeWhenReplyReceived);
        this.tasks.put(new Integer(packet.header.trans), task);
        DebuggerOutput.debug("createTask: created task[" + packet.header.trans + "]: " + task);
        return task;
    }

    synchronized void disposeTask(int trans) throws HLTaskNotFoundException {
        DebuggerOutput.debug("disposeTask: disposing task [" + trans + "] ... ");
        DebuggerOutput.debug("disposeTask: task list = " + this.tasks);
        Transfer xf = this.getTransfer(trans);
        if (xf != null) {
            this.disposeTransfer(trans);
        }
        if (!this.tasks.containsKey(new Integer(trans))) {
            DebuggerOutput.debug("disposeTask: no such task [" + trans + "]");
            throw new HLTaskNotFoundException("no such task: " + trans);
        }
        DebuggerOutput.debug("disposeTask: disposed task [" + trans + "].");
        this.tasks.remove(new Integer(trans));
    }

    synchronized HLTask getTask(int trans) throws HLTaskNotFoundException {
        if (this.tasks.containsKey(new Integer(trans))) {
            return (HLTask)this.tasks.get(new Integer(trans));
        }
        throw new HLTaskNotFoundException("no such task: " + trans);
    }

    synchronized void createTransfer(HLProtocol.Packet packet, Transfer tx) {
        this.createTransfer(packet.header.trans, tx);
    }

    synchronized void createTransfer(int trans, Transfer tx) {
        DebuggerOutput.debug("HLClient.createTransfer: transfer = " + trans);
        this.transfers.put(new Integer(trans), tx);
    }

    synchronized void disposeTransfer(int trans) {
        Transfer xf = (Transfer)this.transfers.get(new Integer(trans));
        if (xf != null) {
            if (xf.local != null) {
                try {
                    xf.local.close();
                }
                catch (IOException e) {
                    DebuggerOutput.stackTrace(e);
                }
            }
            this.transfers.remove(new Integer(trans));
        }
    }

    synchronized Transfer getTransfer(int trans) {
        return (Transfer)this.transfers.get(new Integer(trans));
    }

    public synchronized String toString() {
        String s = "HLClient";
        if (this.host != null) {
            s = s + this.host.toString();
            s = s + (this.connected ? " [connected]" : " [disconnected]");
            if (this.connected) {
                s = s + " tasks: " + this.tasks;
            }
        } else {
            s = s + " no host";
        }
        return s;
    }
}

