/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import redlight.hotline.HLClient;
import redlight.hotline.HLClientListener;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLTask;
import redlight.hotline.HLTaskErrorException;
import redlight.hotline.HLTaskNotFoundException;
import redlight.hotline.Transfer;
import redlight.macfiles.Transferrer;
import redlight.utils.DebuggerOutput;
import redlight.utils.InterruptableInputStream;
import redlight.utils.MacFileUtils;
import redlight.utils.ToArrayConverters;

public class HLClientDispatcher {
    HLProtocol hlp;
    HLClient hlc;
    boolean agreementAccepted = true;
    boolean agreementAborted = false;
    boolean agreementReceived = false;

    HLClientDispatcher(HLClient h) {
        this.hlc = h;
        this.hlp = new HLProtocol();
    }

    public void dispatch(HLProtocol.Packet packet) {
        try {
            switch (packet.header.id) {
                case 65536: {
                    this.dispatchTask(packet);
                    break;
                }
                case 106: {
                    this.dispatchChat(packet);
                    break;
                }
                case 104: {
                    this.dispatchMessage(packet);
                    break;
                }
                case 301: {
                    this.dispatchUserChange(packet);
                    break;
                }
                case 302: {
                    this.dispatchUserLeave(packet);
                    break;
                }
                case 102: {
                    this.dispatchNewsPost(packet);
                    break;
                }
                case 119: {
                    this.dispatchPrivateChatSubject(packet);
                    break;
                }
                case 113: {
                    this.dispatchPrivateChatInvite(packet);
                    break;
                }
                case 117: {
                    this.dispatchPrivateChatUserChange(packet);
                    break;
                }
                case 118: {
                    this.dispatchPrivateChatUserLeave(packet);
                    break;
                }
                case 109: {
                    this.dispatchAgreement(packet);
                    break;
                }
                case 211: {
                    this.dispatchTransferQueuePos(packet);
                    break;
                }
                default: {
                    DebuggerOutput.debug("dispatch: unknown header type: 0x" + Integer.toHexString(packet.header.id));
                    break;
                }
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        catch (HLTaskNotFoundException e) {
            DebuggerOutput.stackTrace(e);
        }
    }

    void dispatchPrivateChatUserChange(HLProtocol.Packet packet) throws IOException {
        int icon = 0;
        int sock = 0;
        int color = 0;
        int pcref = 0;
        byte[] nick = new byte[]{};
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 104: {
                    icon = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 102: {
                    nick = dh.data;
                    break;
                }
                case 112: {
                    color = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 114: {
                    pcref = ToArrayConverters.byteArrayToInt(dh.data);
                }
            }
        }
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handlePrivateChatUserChange(pcref, sock, new String(nick), icon, color);
        }
    }

    void dispatchPrivateChatUserLeave(HLProtocol.Packet packet) throws IOException {
        int sock = 0;
        int pcref = 0;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 114: {
                    pcref = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                }
            }
        }
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handlePrivateChatUserLeave(pcref, sock);
        }
    }

    void dispatchPrivateChatSubject(HLProtocol.Packet packet) throws IOException {
        int pcref = 0;
        byte[] subject = new byte[]{};
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 114: {
                    pcref = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 115: {
                    subject = dh.data;
                }
            }
        }
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handlePrivateChatSubject(pcref, new String(subject));
        }
    }

    void dispatchPrivateChatInvite(HLProtocol.Packet packet) throws IOException {
        int sock = 0;
        int pcref = 0;
        byte[] nick = new byte[]{};
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 114: {
                    pcref = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 102: {
                    nick = dh.data;
                }
            }
        }
        if (nick != null) {
            Enumeration en = this.hlc.hle.elements();
            while (en.hasMoreElements()) {
                ((HLClientListener)en.nextElement()).handlePrivateChatInvite(pcref, sock, new String(nick));
            }
        }
    }

    Object dispatchPrivateChatCreate(HLProtocol.Packet packet) throws IOException {
        int sock = 0;
        int pcref = 0;
        int icon = 0;
        int color = 0;
        byte[] nick = new byte[]{};
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 104: {
                    icon = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 102: {
                    nick = dh.data;
                    break;
                }
                case 112: {
                    color = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 114: {
                    pcref = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                default: {
                    DebuggerOutput.debug("dispatchPrivateChatCreate: unknown dh type: " + dh.type);
                }
            }
        }
        DebuggerOutput.debug("calling listener for private chat create");
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handlePrivateChatCreate(pcref, sock, new String(nick), icon, color);
        }
        return null;
    }

    Object dispatchPrivateChatJoin(HLProtocol.Packet packet) throws IOException {
        Vector<HLProtocol.UserListComponent> userV = new Vector<HLProtocol.UserListComponent>();
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 300: {
                    userV.addElement((HLProtocol.UserListComponent)dh);
                    break;
                }
                default: {
                    DebuggerOutput.debug("dispatchPrivateChatJoin: unknown dh type: " + dh.type);
                }
            }
        }
        HLProtocol.UserListComponent[] users = new HLProtocol.UserListComponent[userV.size()];
        int i = 0;
        while (i < userV.size()) {
            users[i] = (HLProtocol.UserListComponent)userV.elementAt(i);
            ++i;
        }
        userV.removeAllElements();
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handlePrivateChatJoin(packet.header.trans, users);
        }
        return users;
    }

    void dispatchChat(HLProtocol.Packet packet) throws IOException {
        block9: {
            byte[] msg = new byte[]{};
            int pcref = -1;
            while (packet.hasMoreComponents()) {
                HLProtocol.DataComponent dh = packet.nextComponent();
                switch (dh.type) {
                    case 114: {
                        pcref = ToArrayConverters.byteArrayToInt(dh.data);
                        break;
                    }
                    case 101: {
                        msg = dh.data;
                    }
                }
            }
            if (msg == null) break block9;
            if (pcref == -1) {
                Enumeration en = this.hlc.hle.elements();
                while (en.hasMoreElements()) {
                    ((HLClientListener)en.nextElement()).handleChat(new String(msg));
                }
            } else {
                Enumeration en = this.hlc.hle.elements();
                while (en.hasMoreElements()) {
                    ((HLClientListener)en.nextElement()).handlePrivateChat(pcref, new String(msg));
                }
            }
        }
    }

    void dispatchMessage(HLProtocol.Packet packet) throws IOException {
        byte[] msg = new byte[]{};
        byte[] nick = null;
        int sock = 0;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 101: {
                    msg = dh.data;
                    break;
                }
                case 102: {
                    nick = dh.data;
                    break;
                }
                default: {
                    DebuggerOutput.debug("dispatchMessage: unknown dh.type: 0x" + Integer.toHexString(dh.type));
                }
            }
        }
        if (nick == null) {
            Enumeration en = this.hlc.hle.elements();
            while (en.hasMoreElements()) {
                ((HLClientListener)en.nextElement()).handleAdministratorMessage(new String(msg));
            }
        } else {
            Enumeration en = this.hlc.hle.elements();
            while (en.hasMoreElements()) {
                ((HLClientListener)en.nextElement()).handleMessage(sock, new String(nick), new String(msg));
            }
        }
    }

    void dispatchTransferQueuePos(HLProtocol.Packet packet) throws IOException {
        int ref = -1;
        int queuepos = -1;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 107: {
                    ref = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 116: {
                    queuepos = ToArrayConverters.byteArrayToInt(dh.data);
                }
            }
        }
        if (ref != -1 && queuepos != -1) {
            Enumeration en = this.hlc.hle.elements();
            while (en.hasMoreElements()) {
                ((HLClientListener)en.nextElement()).handleTransferQueuePosition(ref, queuepos);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    Object dispatchFileGet(HLProtocol.Packet packet) throws IOException {
        block54: {
            block53: {
                block52: {
                    block51: {
                        size = 0L;
                        fileSize = 0L;
                        ref = 0;
                        queuepos = -1;
                        while (packet.hasMoreComponents()) {
                            dh = packet.nextComponent();
                            switch (dh.type) {
                                case 108: {
                                    size = ToArrayConverters.byteArrayToInt(dh.data);
                                    break;
                                }
                                case 207: {
                                    fileSize = ToArrayConverters.byteArrayToInt(dh.data);
                                    break;
                                }
                                case 107: {
                                    ref = ToArrayConverters.byteArrayToInt(dh.data);
                                    break;
                                }
                                case 116: {
                                    queuepos = ToArrayConverters.byteArrayToInt(dh.data);
                                }
                            }
                        }
                        hlp = new HLProtocol();
                        xfsocket = null;
                        transferrer = null;
                        outputPipe = null;
                        xf = this.hlc.getTransfer(packet.header.trans);
                        if (xf == null) {
                            throw new IOException("Invalid transfer ID " + packet.header.trans);
                        }
                        DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: creating Transferrer");
                        transferrer = new Transferrer(packet.header.trans, ref, xf.meter);
                        if (xf.forkOrFile == 2) {
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: creating output pipe");
                            outputPipe = new PipedOutputStream();
                            xf.inputPipe.connect(outputPipe);
                        }
                        DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: starting Meter");
                        xf.meter.startMeter(transferrer, ref, xf.name, size);
                        if (queuepos != -1) {
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: got queuepos = " + queuepos + ", calling handleTransferQueuePosition");
                            en = this.hlc.hle.elements();
                            while (en.hasMoreElements()) {
                                ((HLClientListener)en.nextElement()).handleTransferQueuePosition(ref, queuepos);
                            }
                        }
                        DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: opening transfer socket");
                        xfsocket = new Socket(this.hlc.getHost(), this.hlc.getPort() + 1);
                        xfsocket.setSoTimeout(500);
                        xfsocket.setSoLinger(true, 5);
                        xfsocket.setReceiveBufferSize(16384);
                        xfoutput = new DataOutputStream(new BufferedOutputStream(xfsocket.getOutputStream()));
                        xfinput = new DataInputStream(new BufferedInputStream(new InterruptableInputStream(xfsocket.getInputStream())));
                        DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: setting up Transferrer");
                        transferrer.setDataInputStream(xfinput);
                        transferrer.setDataOutputStream(xfoutput);
                        fth = new HLProtocol.FileTransferHeader(hlp, ref, 0L);
                        fth.write(xfoutput);
                        fti = null;
                        if (xf.forkOrFile != 2) {
                            fti = new HLProtocol.FileTransferInfo(hlp, xfinput);
                            if (xf.local.getDataSize() == 0L) {
                                xf.local.writeHeader(fti.fileName, fti.fileType, fti.fileCreator, fti.fileComment, fti.creationDate, fti.modificationDate, fti.finderFlags);
                            }
                        }
                        l = null;
                        if (xf.forkOrFile != 2) {
                            l = new byte[8];
                            xfinput.skipBytes(8);
                            xfinput.readFully(l, 0, 8);
                            size = ToArrayConverters.byteArrayToLong(l);
                            xf.local.getDataFork().seek(xf.local.getDataFork().size());
                        }
                        output = xf.forkOrFile != 2 ? xf.local.getDataFork().getDataOutput() : new DataOutputStream(outputPipe);
                        try {
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: transferring data fork ...");
                            transferrer.transferDataFork(xfinput, output, size);
                            var22_19 = null;
                            ** if (xf.forkOrFile == 2) goto lbl-1000
                        }
                        catch (Throwable var21_25) {
                            var22_20 = null;
                            if (xf.forkOrFile != 2) {
                                DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing data fork.");
                                xf.local.setDataSize(xf.local.getDataSize() + transferrer.getDataBytesWritten());
                                xf.local.getDataFork().close();
                            }
                            throw var21_25;
                        }
lbl-1000:
                        // 1 sources

                        {
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing data fork.");
                            xf.local.setDataSize(xf.local.getDataSize() + transferrer.getDataBytesWritten());
                            xf.local.getDataFork().close();
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block51;
                            catch (InterruptedException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                throw e;
                            }
                        }
                    }
                    if (xf.forkOrFile != 2) {
                        size = 0L;
                        if (fti.numberOfBlocks == 3) {
                            xfinput.skipBytes(8);
                            xfinput.readFully(l, 0, 8);
                            size = ToArrayConverters.byteArrayToLong(l);
                        }
                        xf.local.getResourceFork().seek(xf.local.getResourceFork().size());
                        try {
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: transferring resource fork");
                            transferrer.transferResourceFork(xfinput, xf.local.getResourceFork().getDataOutput(), size);
                            var24_26 = null;
                        }
                        catch (Throwable var23_28) {
                            var24_27 = null;
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing resource fork");
                            xf.local.setResourceSize(xf.local.getResourceSize() + transferrer.getResourceBytesWritten());
                            xf.local.getResourceFork().close();
                            throw var23_28;
                        }
                        DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing resource fork");
                        xf.local.setResourceSize(xf.local.getResourceSize() + transferrer.getResourceBytesWritten());
                        xf.local.getResourceFork().close();
                        {
                            break block52;
                            catch (InterruptedException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                throw e;
                            }
                        }
                    }
                }
                DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: stopping meter");
                xf.meter.stopMeter(ref);
                if (xf.forkOrFile == 2) break block53;
                MacFileUtils.setFileTypeAndCreator(xf.local.getFile(), fti.fileType.getBytes(), fti.fileCreator.getBytes());
            }
            var26_29 = null;
            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: in final block");
            try {
                if (outputPipe != null) {
                    outputPipe.flush();
                    outputPipe.close();
                }
                if (xf.forkOrFile != 2 && xf.local != null) {
                    xf.local.cleanup();
                }
                if (xfsocket != null) {
                    DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing socket");
                    xfsocket.close();
                }
                break block54;
            }
            catch (IOException e) {}
            break block54;
            {
                catch (InterruptedException e) {
                    DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: caught InterruptedException");
                    var26_30 = null;
                    DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: in final block");
                    try {
                        if (outputPipe != null) {
                            outputPipe.flush();
                            outputPipe.close();
                        }
                        if (xf.forkOrFile != 2 && xf.local != null) {
                            xf.local.cleanup();
                        }
                        if (xfsocket != null) {
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing socket");
                            xfsocket.close();
                        }
                        break block54;
                    }
                    catch (IOException e) {}
                    break block54;
                }
                catch (IOException e) {
                    DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: caught IOException: " + e.toString());
                    DebuggerOutput.stackTrace(e);
                    if (!transferrer.interrupted) {
                        xf.meter.stopMeterWithError(ref, e);
                    }
                    var26_31 = null;
                    DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: in final block");
                    try {
                        if (outputPipe != null) {
                            outputPipe.flush();
                            outputPipe.close();
                        }
                        if (xf.forkOrFile != 2 && xf.local != null) {
                            xf.local.cleanup();
                        }
                        if (xfsocket != null) {
                            DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing socket");
                            xfsocket.close();
                        }
                        break block54;
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable var25_37) {
                var26_32 = null;
                DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: in final block");
                try {
                    if (outputPipe != null) {
                        outputPipe.flush();
                        outputPipe.close();
                    }
                    if (xf.forkOrFile != 2 && xf.local != null) {
                        xf.local.cleanup();
                    }
                    if (xfsocket != null) {
                        DebuggerOutput.debug("dispatchFileGet[" + packet.header.trans + "]: closing socket");
                        xfsocket.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw var25_37;
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    Object dispatchFilePut(HLProtocol.Packet packet) throws IOException {
        block30: {
            boolean size = false;
            int ref = 0;
            HLProtocol.ResumeTransferComponent rflt = new HLProtocol.ResumeTransferComponent(this.hlp);
            while (packet.hasMoreComponents()) {
                HLProtocol.DataComponent dh = packet.nextComponent();
                switch (dh.type) {
                    case 107: {
                        ref = ToArrayConverters.byteArrayToInt(dh.data);
                        break;
                    }
                    case 203: {
                        rflt = (HLProtocol.ResumeTransferComponent)dh;
                        break;
                    }
                    default: {
                        DebuggerOutput.debug("dispatchFilePut: unknown dh.type: " + dh.type);
                    }
                }
            }
            Transferrer transferrer = null;
            FilterOutputStream xfoutput = null;
            Transfer xf = this.hlc.getTransfer(packet.header.trans);
            if (xf == null) {
                throw new IOException("Invalid transaction ID " + packet.header.trans);
            }
            Socket xfsocket = null;
            long rflt_data_size = (Long)rflt.chunks.get("DATA");
            long rflt_macr_size = (Long)rflt.chunks.get("MACR");
            long dataRemaining = xf.local_data_size - rflt_data_size;
            long rsrcRemaining = xf.local_rsrc_size - rflt_macr_size;
            transferrer = new Transferrer(packet.header.trans, ref, xf.meter);
            xf.meter.startMeter(transferrer, ref, xf.local.getFile().getName(), dataRemaining + rsrcRemaining);
            if (dataRemaining < 0L || rsrcRemaining < 0L) {
                throw new IOException("Attempt to resume beyond end of file");
            }
            xfsocket = new Socket(this.hlc.getHost(), this.hlc.getPort() + 1);
            xfsocket.setSoTimeout(2500);
            xfsocket.setSoLinger(true, 5);
            xfsocket.setSendBufferSize(16384);
            xfoutput = new DataOutputStream(xfsocket.getOutputStream());
            DataInputStream xfinput = new DataInputStream(new InterruptableInputStream(xfsocket.getInputStream()));
            transferrer.setDataInputStream(xfinput);
            transferrer.setDataOutputStream((DataOutputStream)xfoutput);
            HLProtocol.FileTransferInfo fti = new HLProtocol.FileTransferInfo(this.hlp, xf.local.getFile().getName(), xf.local.getType(), xf.local.getCreator(), xf.local.getComment(), xf.local.getCreationDate(), xf.local.getModificationDate(), xf.local.getFinderFlags());
            HLProtocol.FileTransferHeader fth = new HLProtocol.FileTransferHeader(this.hlp, ref, 16L + (dataRemaining + rsrcRemaining + (long)fti.data.length));
            fth.write((DataOutputStream)xfoutput);
            fti.write((DataOutputStream)xfoutput);
            ((DataOutputStream)xfoutput).flush();
            xfoutput.write(new String("DATA").getBytes());
            ((DataOutputStream)xfoutput).writeInt(0);
            ((DataOutputStream)xfoutput).writeLong(dataRemaining);
            ((DataOutputStream)xfoutput).flush();
            if (dataRemaining > 0L) {
                xf.local.getDataFork().seek(rflt_data_size);
                transferrer.transferDataFork(xf.local.getDataFork().getDataInput(), (DataOutput)((Object)xfoutput), dataRemaining);
            }
            xfoutput.write(new String("MACR").getBytes());
            ((DataOutputStream)xfoutput).writeInt(0);
            ((DataOutputStream)xfoutput).writeLong(rsrcRemaining);
            ((DataOutputStream)xfoutput).flush();
            if (rsrcRemaining > 0L) {
                xf.local.getResourceFork().seek(rflt_macr_size);
                transferrer.transferResourceFork(xf.local.getResourceFork().getDataInput(), (DataOutput)((Object)xfoutput), rsrcRemaining);
            }
            ((DataOutputStream)xfoutput).flush();
            if (!HLProtocol.asynchronousFileTransfers) {
                try {
                    xfinput.read();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            xf.meter.stopMeter(ref);
            Object var22_19 = null;
            try {
                if (xfoutput != null) {
                    xfoutput.close();
                }
                if (xfsocket != null) {
                    xfsocket.close();
                }
                break block30;
            }
            catch (IOException e2) {}
            break block30;
            {
                catch (InterruptedException e) {
                    Object var22_20 = null;
                    try {
                        if (xfoutput != null) {
                            xfoutput.close();
                        }
                        if (xfsocket != null) {
                            xfsocket.close();
                        }
                        break block30;
                    }
                    catch (IOException e2) {}
                    break block30;
                }
                catch (IOException e) {
                    xf.meter.stopMeterWithError(ref, e);
                    Object var22_21 = null;
                    try {
                        if (xfoutput != null) {
                            xfoutput.close();
                        }
                        if (xfsocket != null) {
                            xfsocket.close();
                        }
                        break block30;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var22_22 = null;
                try {
                    if (xfoutput != null) {
                        xfoutput.close();
                    }
                    if (xfsocket != null) {
                        xfsocket.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    Object dispatchFileList(HLProtocol.Packet packet) throws IOException {
        Vector<HLProtocol.FileListComponent> fileV = new Vector<HLProtocol.FileListComponent>();
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 200: {
                    fileV.insertElementAt((HLProtocol.FileListComponent)dh, 0);
                }
            }
        }
        HLProtocol.FileListComponent[] files = new HLProtocol.FileListComponent[fileV.size()];
        int i = 0;
        while (i < fileV.size()) {
            files[i] = (HLProtocol.FileListComponent)fileV.elementAt(i);
            ++i;
        }
        fileV.removeAllElements();
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handleFileList(packet.header.trans, files);
        }
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchTask(HLProtocol.Packet packet) throws IOException, HLTaskNotFoundException {
        Throwable throwable2;
        block36: {
            block34: {
                Enumeration en2;
                Object resultValue;
                block35: {
                    block33: {
                        HLTask task = this.hlc.getTask(packet.header.trans);
                        resultValue = null;
                        try {
                            block32: {
                                if (packet.header.isError == 1) {
                                    String error = new String("Unspecified error.");
                                    block18: while (true) {
                                        if (!packet.hasMoreComponents()) {
                                            resultValue = error;
                                            break block32;
                                        }
                                        HLProtocol.DataComponent dh = packet.nextComponent();
                                        switch (dh.type) {
                                            case 100: {
                                                error = new String(dh.data);
                                                continue block18;
                                            }
                                        }
                                    }
                                }
                                switch (task.type) {
                                    case 107: {
                                        this.dispatchLogin(packet);
                                        break;
                                    }
                                    case 200: {
                                        resultValue = this.dispatchFileList(packet);
                                        break;
                                    }
                                    case 303: {
                                        resultValue = this.dispatchUserInfo(packet);
                                        break;
                                    }
                                    case 300: {
                                        resultValue = this.dispatchUserList(packet);
                                        break;
                                    }
                                    case 101: {
                                        resultValue = this.dispatchNews(packet);
                                        break;
                                    }
                                    case 202: {
                                        resultValue = this.dispatchFileGet(packet);
                                        break;
                                    }
                                    case 203: {
                                        resultValue = this.dispatchFilePut(packet);
                                        break;
                                    }
                                    case 112: {
                                        resultValue = this.dispatchPrivateChatCreate(packet);
                                        break;
                                    }
                                    case 115: {
                                        resultValue = this.dispatchPrivateChatJoin(packet);
                                        break;
                                    }
                                    case 352: {
                                        resultValue = this.dispatchAccountInfo(packet);
                                        break;
                                    }
                                    case 206: {
                                        resultValue = this.dispatchFileInfo(packet);
                                        break;
                                    }
                                    default: {
                                        DebuggerOutput.debug("dispatchTask[" + packet.header.trans + "] task [" + packet.header.trans + "] undispatched: " + task);
                                    }
                                }
                            }
                            Object var7_6 = null;
                            if (packet.header.isError == 1) {
                                task.setError(new HLTaskErrorException((String)resultValue));
                            } else {
                                task.setData(resultValue);
                            }
                            if (!task.disposeWhenReceived) break block33;
                        }
                        catch (Throwable throwable2) {
                            Object var7_7 = null;
                            if (packet.header.isError == 1) {
                                task.setError(new HLTaskErrorException((String)resultValue));
                            } else {
                                task.setData(resultValue);
                            }
                            if (task.disposeWhenReceived) {
                                DebuggerOutput.debug("dispatchTask: task[" + packet.header.trans + "]: disposing task ...");
                                this.hlc.disposeTask(packet.header.trans);
                            }
                            if (packet.header.isError != 1) break block34;
                            en2 = this.hlc.hle.elements();
                            break block35;
                        }
                        DebuggerOutput.debug("dispatchTask: task[" + packet.header.trans + "]: disposing task ...");
                        this.hlc.disposeTask(packet.header.trans);
                    }
                    if (packet.header.isError == 1) {
                        Enumeration en2 = this.hlc.hle.elements();
                        while (en2.hasMoreElements()) {
                            ((HLClientListener)en2.nextElement()).handleTaskError(packet.header.trans, (String)resultValue);
                        }
                    } else {
                        Enumeration en3 = this.hlc.hle.elements();
                        while (en3.hasMoreElements()) {
                            ((HLClientListener)en3.nextElement()).handleTaskComplete(packet.header.trans);
                        }
                    }
                    DebuggerOutput.debug("dispatchTask: task[" + packet.header.trans + "]: dispatcher done.");
                    return;
                }
                while (en2.hasMoreElements()) {
                    ((HLClientListener)en2.nextElement()).handleTaskError(packet.header.trans, (String)resultValue);
                }
                break block36;
            }
            Enumeration en3 = this.hlc.hle.elements();
            while (en3.hasMoreElements()) {
                ((HLClientListener)en3.nextElement()).handleTaskComplete(packet.header.trans);
            }
        }
        DebuggerOutput.debug("dispatchTask: task[" + packet.header.trans + "]: dispatcher done.");
        throw throwable2;
    }

    Object dispatchFileInfo(HLProtocol.Packet packet) throws IOException {
        byte[] icon = new byte[]{};
        byte[] type = new byte[]{};
        byte[] creator = new byte[]{};
        byte[] name = new byte[]{};
        byte[] comment = new byte[]{};
        long size = 0L;
        Calendar created = Calendar.getInstance();
        Calendar modified = Calendar.getInstance();
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 213: {
                    icon = dh.data;
                    break;
                }
                case 205: {
                    type = dh.data;
                    break;
                }
                case 206: {
                    creator = dh.data;
                    break;
                }
                case 201: {
                    name = dh.data;
                    break;
                }
                case 210: {
                    comment = dh.data;
                    break;
                }
                case 208: {
                    created = ((HLProtocol.DateComponent)dh).date;
                    break;
                }
                case 209: {
                    modified = ((HLProtocol.DateComponent)dh).date;
                    break;
                }
                case 207: {
                    size = ToArrayConverters.byteArrayToLong(dh.data);
                }
            }
        }
        HLProtocol.FileInfo info = new HLProtocol.FileInfo(this.hlp);
        info.icon = new String(icon);
        info.type = new String(type);
        info.creator = new String(creator);
        info.name = new String(name);
        info.comment = new String(comment);
        info.size = size;
        info.created = created;
        info.modified = modified;
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handleFileInfo(packet.header.trans, info);
        }
        return info;
    }

    Object dispatchAccountInfo(HLProtocol.Packet packet) throws IOException {
        byte[] nick = new byte[]{};
        byte[] password = new byte[]{};
        byte[] login = new byte[]{};
        byte[] access2 = new byte[]{};
        long access = 0L;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            if (dh.data == null) continue;
            switch (dh.type) {
                case 102: {
                    nick = dh.data;
                    break;
                }
                case 105: {
                    login = HLProtocol.invert(dh.data);
                    break;
                }
                case 106: {
                    password = HLProtocol.invert(dh.data);
                    break;
                }
                case 110: {
                    access = ToArrayConverters.byteArrayToLong(ToArrayConverters.swapByteArray(dh.data));
                }
            }
        }
        HLProtocol.AccountInfo account = new HLProtocol.AccountInfo(this.hlp, new String(login), new String(nick), new String(password), access, null);
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handleAccountInfo(packet.header.trans, account);
        }
        return account;
    }

    Object dispatchUserList(HLProtocol.Packet packet) throws IOException {
        Vector<HLProtocol.UserListComponent> userV = new Vector<HLProtocol.UserListComponent>();
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 300: {
                    userV.insertElementAt((HLProtocol.UserListComponent)dh, 0);
                }
            }
        }
        HLProtocol.UserListComponent[] users = new HLProtocol.UserListComponent[userV.size()];
        int i = 0;
        while (i < userV.size()) {
            users[i] = (HLProtocol.UserListComponent)userV.elementAt(i);
            ++i;
        }
        userV.removeAllElements();
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handleUserList(packet.header.trans, users);
        }
        return users;
    }

    Object dispatchUserInfo(HLProtocol.Packet packet) throws IOException {
        String userinfo = new String();
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 101: {
                    userinfo = new String(dh.data);
                }
            }
        }
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handleUserInfo(packet.header.trans, userinfo);
        }
        return userinfo;
    }

    void dispatchUserChange(HLProtocol.Packet packet) throws IOException {
        int icon = 0;
        int sock = 0;
        int color = 0;
        byte[] nick = new byte[]{};
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 104: {
                    icon = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                case 102: {
                    nick = dh.data;
                    break;
                }
                case 112: {
                    color = ToArrayConverters.byteArrayToInt(dh.data);
                }
            }
        }
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handleUserChange(sock, new String(nick), icon, color);
        }
    }

    void dispatchUserLeave(HLProtocol.Packet packet) throws IOException {
        int sock = 0;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 103: {
                    sock = ToArrayConverters.byteArrayToInt(dh.data);
                }
            }
        }
        Enumeration en = this.hlc.hle.elements();
        while (en.hasMoreElements()) {
            ((HLClientListener)en.nextElement()).handleUserLeave(sock);
        }
    }

    void dispatchNewsPost(HLProtocol.Packet packet) throws IOException {
        String post = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 101: {
                    post = new String(dh.data);
                }
            }
        }
        if (post != null) {
            Enumeration en = this.hlc.hle.elements();
            while (en.hasMoreElements()) {
                ((HLClientListener)en.nextElement()).handleNewsPost(post);
            }
        }
    }

    Object dispatchNews(HLProtocol.Packet packet) throws IOException {
        String news = null;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 101: {
                    news = new String(dh.data);
                }
            }
        }
        if (news != null) {
            Enumeration en = this.hlc.hle.elements();
            while (en.hasMoreElements()) {
                ((HLClientListener)en.nextElement()).handleNews(packet.header.trans, news);
            }
        }
        return news;
    }

    synchronized void waitForAgreement() throws InterruptedException {
        if (this.agreementAborted) {
            throw new InterruptedException("agreement aborted");
        }
        DebuggerOutput.debug("HLClientDispatcher: waiting for agreement ...");
        while (!this.agreementReceived && !this.agreementAborted) {
            this.wait();
        }
        DebuggerOutput.debug("HLClientDispatcher: got agreement.");
        if (this.agreementAborted) {
            throw new InterruptedException("agreement aborted");
        }
    }

    synchronized void notifyAgreementAborted() {
        this.agreementAborted = true;
        this.notify();
    }

    synchronized void notifyAgreementReceived() {
        if (!this.agreementAborted) {
            this.agreementReceived = true;
            this.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchAgreement(HLProtocol.Packet packet) throws IOException {
        try {
            block6: while (true) {
                if (!packet.hasMoreComponents()) {
                    Object var7_6 = null;
                    this.notifyAgreementReceived();
                    return;
                }
                HLProtocol.DataComponent dh = packet.nextComponent();
                switch (dh.type) {
                    case 101: {
                        String agreement = new String(dh.data);
                        Enumeration en = this.hlc.hle.elements();
                        while (true) {
                            if (!en.hasMoreElements()) continue block6;
                            boolean ok = ((HLClientListener)en.nextElement()).handleAgreement(agreement);
                            if (ok) continue;
                            this.agreementAccepted = false;
                        }
                    }
                    case 154: {
                        this.agreementAccepted = true;
                        int autoAgree = ToArrayConverters.byteArrayToInt(dh.data);
                        continue block6;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.notifyAgreementReceived();
            throw throwable;
        }
    }

    void dispatchLogin(HLProtocol.Packet packet) throws IOException {
        int version = 0;
        while (packet.hasMoreComponents()) {
            HLProtocol.DataComponent dh = packet.nextComponent();
            switch (dh.type) {
                case 160: {
                    version = ToArrayConverters.byteArrayToInt(dh.data);
                    break;
                }
                default: {
                    DebuggerOutput.debug("dispatchLogin: unknown dh.type: " + dh.type);
                }
            }
        }
        this.hlc.setServerVersion(version);
    }
}

