/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import redlight.hotline.HLProtocol;
import redlight.hotline.iconlib.HLData;
import redlight.hotline.iconlib.HLExtractor;
import redlight.hotline.iconlib.HLIconData;
import redlight.utils.DebuggerOutput;

public class HLIconFile {
    private Hashtable iconCache;
    private Color alpha;
    private Icon emptyIcon;
    private HLExtractor extractor = new HLExtractor();
    static int PADSIZE = 32;

    public HLIconFile(File f) throws IOException {
        try {
            this.extractor.quickStart(f.toString());
            this.iconCache = new Hashtable();
            this.alpha = new Color(0, 0, 0, 1);
            int[] emptyIconPixels = new int[PADSIZE * 16];
            this.emptyIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(PADSIZE, 16, emptyIconPixels, 0, PADSIZE)));
        }
        catch (IOException e) {
            this.extractor = null;
            throw e;
        }
    }

    public Icon getIconOrPlaceholder(int iconNumber) {
        Icon icon = this.getIcon(iconNumber);
        if (icon == null) {
            return this.emptyIcon;
        }
        return icon;
    }

    public synchronized Icon getIcon(int iconNumber) {
        Integer cacheID = new Integer(iconNumber);
        if (this.iconCache.containsKey(cacheID)) {
            return (Icon)this.iconCache.get(cacheID);
        }
        if (this.extractor == null) {
            return null;
        }
        if (!this.extractor.hasICON) {
            return null;
        }
        HLIconData iconData = null;
        try {
            iconData = this.extractor.getIcon(iconNumber);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (iconData == null) {
            return null;
        }
        int fpos = this.extractor.indexTable.get(this.extractor.idICONTable).find(iconNumber);
        HLData hld = this.extractor.indexTable.get(this.extractor.idICONTable).get(fpos);
        if (hld == null) {
            return null;
        }
        DebuggerOutput.debug("HLIconFile.getIcon: icon name: " + hld.getName() + " identity: " + hld.getIdentity() + " width: " + iconData.getWidth() + " height: " + iconData.getHeight() + " palette length(b): " + iconData.getPalLengthBytes() + " filePos: " + hld.getDataOffset() + " dataSize: " + hld.getDataSize());
        int sourceWidth = iconData.getWidth();
        int sourceHeight = iconData.getHeight();
        int destinationWidth = sourceWidth;
        if (sourceWidth < PADSIZE) {
            destinationWidth = PADSIZE;
        }
        if (sourceWidth > 215) {
            destinationWidth = sourceWidth - 215;
        }
        int[] destinationPixels = new int[destinationWidth * sourceHeight];
        int numSourcePixels = sourceWidth * sourceHeight;
        int destinationMargin = 0;
        if (iconData.getWidth() < PADSIZE) {
            destinationMargin = (PADSIZE - sourceWidth) / 2;
        }
        int destinationMarginTwice = destinationMargin * 2;
        int roundingErrorAdjustment = 0;
        if (destinationMarginTwice + sourceWidth < PADSIZE) {
            roundingErrorAdjustment = PADSIZE - (destinationMarginTwice + sourceWidth);
        }
        int destinationRowOffset = 0;
        int sourceRowOffset = 0;
        if (destinationMargin > 0) {
            destinationRowOffset = destinationMargin + roundingErrorAdjustment;
        }
        if (sourceWidth > 215) {
            sourceRowOffset = 215;
        }
        int[] pixelData = iconData.getRGBField();
        int sourceOffset = sourceRowOffset;
        int pixel = sourceRowOffset;
        while (pixel < numSourcePixels) {
            if (pixel != 0 && pixel % sourceWidth == 0) {
                destinationRowOffset += destinationMarginTwice + roundingErrorAdjustment;
                sourceOffset += sourceRowOffset;
                pixel += sourceRowOffset;
            }
            destinationPixels[pixel - sourceOffset + destinationRowOffset] = 0xFF000000 | pixelData[pixel];
            if (pixelData[pixel] == iconData.getTransparency() || pixelData[pixel] == 0xFFFFFF) {
                destinationPixels[pixel - sourceOffset + destinationRowOffset] = this.alpha.getRGB();
            }
            ++pixel;
        }
        ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(destinationWidth, sourceHeight, destinationPixels, 0, destinationWidth)));
        if (this.iconCache.size() > 80) {
            this.iconCache.clear();
        }
        this.iconCache.put(cacheID, icon);
        return icon;
    }

    public Icon getIconForFile(HLProtocol.FileListComponent file) {
        Icon icon = this.getIconOrPlaceholder(400);
        if (file != null) {
            String fn = file.fileName.toLowerCase();
            if (file.fileType.equals("fldr")) {
                icon = this.getIconOrPlaceholder(401);
            }
            if (file.fileType.equals("fldr") && (fn.indexOf("drop box") != -1 || fn.indexOf("upload") != -1)) {
                icon = this.getIconOrPlaceholder(421);
            } else if (file.fileType.equals("HTft") || fn.endsWith(".hpf")) {
                icon = this.getIconOrPlaceholder(402);
            } else if (file.fileType.equals("alis")) {
                icon = this.getIconOrPlaceholder(422);
            } else if (file.fileType.equals("APPL") || fn.endsWith(".exe") || fn.endsWith(".jar")) {
                icon = this.getIconOrPlaceholder(407);
            } else if (file.fileType.equals("GIFf") || fn.endsWith(".gif") || file.fileType.equals("JPEG") || fn.endsWith(".jpg") || fn.endsWith(".bmp") || fn.endsWith(".png")) {
                icon = this.getIconOrPlaceholder(406);
            } else if (file.fileType.equals("TEXT") || file.fileName.endsWith(".htm") || file.fileName.endsWith(".html")) {
                icon = this.getIconOrPlaceholder(404);
            } else if (file.fileCreator.equals("ttro") || fn.startsWith("readme")) {
                icon = this.getIconOrPlaceholder(405);
            } else if (file.fileType.equals("MPEG") || fn.endsWith(".mpg") || fn.endsWith(".mpeg") || file.fileCreator.equals("MooV") || fn.endsWith(".mov") || file.fileCreator.equals("VfW ") || fn.endsWith(".avi") || fn.endsWith(".asf") || fn.endsWith(".divx") || fn.endsWith(".rm") || fn.endsWith(".ra") || fn.endsWith(".ram") || file.fileType.equals("PNRA") || file.fileType.equals("PNst")) {
                icon = this.getIconOrPlaceholder(425);
            } else if (fn.endsWith(".iso")) {
                icon = this.getIconOrPlaceholder(423);
            } else if (fn.endsWith(".img")) {
                icon = this.getIconOrPlaceholder(423);
            } else if (file.fileType.equals("AIFF") || fn.endsWith(".aif") || fn.endsWith(".aiff") || file.fileType.equals("MP3 ") || fn.endsWith(".mp3") || file.fileType.equals("WAVE") || fn.endsWith(".wav") || file.fileType.equals("SWFL") || fn.endsWith(".swf")) {
                icon = this.getIconOrPlaceholder(424);
            } else if (file.fileType.equals("SIT!") || file.fileType.equals("SITD") || file.fileType.equals("SIT2") || fn.endsWith(".sit")) {
                icon = this.getIconOrPlaceholder(403);
            } else if (file.fileType.equals("SegM") || file.fileType.equals("Seg1") || file.fileType.equals("Seg2") || file.fileType.equals("Seg3") || file.fileType.equals("SegN")) {
                icon = this.getIconOrPlaceholder(409);
            } else if (file.fileType.equals("ZIP ") || fn.endsWith(".zip") || fn.endsWith(".lzh") || fn.endsWith(".gz") || fn.endsWith(".rar") || fn.endsWith(".arj") || fn.endsWith(".sit") || fn.endsWith(".cpt")) {
                icon = this.getIconOrPlaceholder(426);
            }
        }
        return icon;
    }
}

