/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import redlight.hotline.HLServer;
import redlight.hotline.TransferThread;
import redlight.utils.DebuggerOutput;

class HLTransferServer
extends Thread {
    ServerSocket transferSocket;
    HLServer hls;
    protected Vector transferThreads = new Vector();

    HLTransferServer(HLServer hls, ServerSocket transferSocket) {
        this.hls = hls;
        this.transferSocket = transferSocket;
        this.setName("HLTransferServer " + transferSocket);
        this.start();
    }

    public void run() {
        DebuggerOutput.debug("HLTransferServer starting ...");
        while (!this.isInterrupted()) {
            try {
                this.transferSocket.setSoTimeout(2000);
                Socket client = this.transferSocket.accept();
                if (this.hls.banTable.contains(client.getInetAddress())) {
                    this.hls.log("Client " + client.getInetAddress().toString() + " is on bantable, disconnecting.");
                    try {
                        client.close();
                    }
                    catch (IOException _e) {}
                    continue;
                }
                client.setSoLinger(true, 5);
                if (this.isInterrupted()) continue;
                new TransferThread(this, client);
            }
            catch (InterruptedIOException e) {
            }
            catch (IOException e) {
                DebuggerOutput.stackTrace(e);
            }
        }
        DebuggerOutput.debug("HLTransferServer: stopping transfer threads");
        Enumeration en = this.transferThreads.elements();
        while (en.hasMoreElements()) {
            TransferThread t = (TransferThread)en.nextElement();
            t.disconnect();
        }
        this.transferThreads.clear();
        DebuggerOutput.debug("HLTransferServer exiting");
    }
}

