/*
 * Decompiled with CFR 0.152.
 */
package redlight.macfiles;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import redlight.macfiles.MacBinaryDataFork;
import redlight.macfiles.MacBinaryResourceFork;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;
import redlight.utils.ToArrayConverters;

public class MacBinaryMacFile
extends MacFile {
    byte[] macBinaryHeader;
    RandomAccessFile raf;

    public MacBinaryMacFile(File f, Integer p) throws IOException {
        super(new File(f.getParent(), f.getName() + ".bin"), p);
        String perms = new String();
        DebuggerOutput.debug("MacBinaryMacFile: p = " + p.toString());
        if ((p & MacFile.READ_PERM) == MacFile.READ_PERM) {
            perms = "r";
        }
        if ((p & MacFile.WRITE_PERM) == MacFile.WRITE_PERM) {
            perms = perms + "w";
        }
        this.raf = new RandomAccessFile(this.getFile(), perms);
        this.resourceFork = new MacBinaryResourceFork(this);
        this.dataFork = new MacBinaryDataFork(this);
        this.macBinaryHeader = new byte[128];
        if (this.raf.length() > 128L) {
            this.readHeader();
        }
    }

    public void readHeader() throws IOException {
        this.raf.readFully(this.macBinaryHeader, 0, 128);
        byte[] r = new byte[4];
        byte[] d = new byte[4];
        System.arraycopy(this.macBinaryHeader, 83, d, 0, 4);
        System.arraycopy(this.macBinaryHeader, 87, r, 0, 4);
        this.setDataSize(ToArrayConverters.byteArrayToInt(d));
        this.setResourceSize(ToArrayConverters.byteArrayToInt(r));
        DebuggerOutput.debug("MacBinaryMacFile: header read (data size = " + this.getDataSize() + ", rsrc size = " + this.getResourceSize() + ")");
    }

    public void writeHeader(String name, String type, String creator, String comments, Calendar created, Calendar modifed, int finderFlags) throws IOException {
        byte[] header = this.macBinaryHeader;
        RandomAccessFile dos = this.raf;
        try {
            header[0] = 0;
            header[1] = (byte)name.length();
            System.arraycopy(name.getBytes(), 0, header, 2, name.length());
            System.arraycopy(type.getBytes(), 0, header, 65, type.length());
            System.arraycopy(creator.getBytes(), 0, header, 69, creator.length());
            byte[] b = ToArrayConverters.intToByteArray((int)this.getDataSize());
            System.arraycopy(b, 0, header, 83, b.length);
            b = ToArrayConverters.intToByteArray((int)this.getResourceSize());
            System.arraycopy(b, 0, header, 87, b.length);
            int mac_date = (int)System.currentTimeMillis();
            b = ToArrayConverters.intToByteArray(mac_date);
            System.arraycopy(b, 0, header, 91, 4);
            System.arraycopy(b, 0, header, 95, 4);
            dos.write(header);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void cleanup() throws IOException {
        RandomAccessFile dos = (RandomAccessFile)this.getDataFork().getDataOutput();
        dos.seek(83L);
        DebuggerOutput.debug("MacBinaryMacFile: cleaning up (data size = " + this.getDataSize() + ", rsrc size = " + this.getResourceSize() + ")");
        byte[] b = ToArrayConverters.intToByteArray((int)this.getDataSize());
        dos.write(b, 0, b.length);
        b = ToArrayConverters.intToByteArray((int)this.getResourceSize());
        dos.write(b, 0, b.length);
    }

    RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public void close() throws IOException {
        this.raf.close();
        DebuggerOutput.debug("MacBinaryMacFile: output file closed");
    }

    public boolean exists() {
        try {
            DebuggerOutput.debug("MacBinaryMacFile: exists (raf.length() == " + this.raf.length());
            return this.raf.length() > 0L;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean delete() {
        boolean s = false;
        try {
            this.raf.close();
            s = this.getFile().delete();
            this.raf = new RandomAccessFile(this.getFile(), "rw");
            this.macBinaryHeader = new byte[128];
            this.setDataSize(0L);
            this.setResourceSize(0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    public boolean renameTo(File f) {
        return this.getFile().renameTo(new File(f.toString() + ".bin"));
    }
}

