/*
 * Decompiled with CFR 0.152.
 */
package redlight.macfiles;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import redlight.macfiles.Fork;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;

public abstract class MacFile {
    File file;
    Fork dataFork;
    Fork resourceFork;
    long dataSize;
    long resourceSize;
    Integer permissions;
    String comment;
    String type;
    String creator;
    int finderFlags;
    private static String[] macFileMethods = new String[]{"Native", "Split", "MacBinary"};
    private static int currentMacFileMethod;
    static int NATIVE;
    static int SPLIT;
    static int MACBINARY;
    public static int READ_PERM;
    public static int WRITE_PERM;
    public static boolean mappingsInitialized;
    public static Hashtable typeCodeMapping;
    public static Hashtable creatorCodeMapping;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Integer;

    public static final void createTypeCreatorCodeMapping() {
        typeCodeMapping = new Hashtable();
        typeCodeMapping.put("ChangeLog", "TEXT");
        typeCodeMapping.put("TODO", "TEXT");
        typeCodeMapping.put("AUTHORS", "TEXT");
        typeCodeMapping.put("", "TEXT");
        typeCodeMapping.put(".c", "TEXT");
        typeCodeMapping.put(".cpp", "TEXT");
        typeCodeMapping.put(".hpf", "HTft");
        typeCodeMapping.put(".gif", "GIFf");
        typeCodeMapping.put(".jpg", "JPEG");
        typeCodeMapping.put(".html", "TEXT");
        typeCodeMapping.put(".txt", "TEXT");
        typeCodeMapping.put(".mov", "MooV");
        typeCodeMapping.put(".rm", "PNRA");
        typeCodeMapping.put(".ra", "PNRA");
        typeCodeMapping.put(".ram", "PNst");
        typeCodeMapping.put(".sit", "SITD");
        typeCodeMapping.put(".zip", "ZIP ");
        typeCodeMapping.put(".smi", "APPL");
        typeCodeMapping.put(".gz", "Gzip");
        typeCodeMapping.put(".rsrc", "rsrc");
        typeCodeMapping.put(".aif", "AIFF");
        typeCodeMapping.put(".aiff", "AIFF");
        typeCodeMapping.put(".avi", "VfW ");
        typeCodeMapping.put(".asf", "VfW ");
        typeCodeMapping.put(".mpg", "MPEG");
        typeCodeMapping.put(".mpeg", "MPEG");
        typeCodeMapping.put(".mp3", "MP3 ");
        typeCodeMapping.put(".wav", "WAVE");
        typeCodeMapping.put("DEFAULTMAPPING", "TEXT");
        creatorCodeMapping = new Hashtable();
        creatorCodeMapping.put(".java", "R*ch");
        creatorCodeMapping.put(".c", "R*ch");
        creatorCodeMapping.put(".cpp", "R*ch");
        creatorCodeMapping.put(".txt", "ttxt");
        creatorCodeMapping.put(".hpf", "HTLC");
        creatorCodeMapping.put(".sit", "SIT!");
        creatorCodeMapping.put(".rm", "PNst");
        creatorCodeMapping.put(".ra", "PNst");
        creatorCodeMapping.put(".ram", "PNst");
        creatorCodeMapping.put(".smi", "oneb");
        creatorCodeMapping.put(".gz", "Gzip");
        creatorCodeMapping.put(".rsrc", "RSED");
        creatorCodeMapping.put(".avi", "TVOD");
        creatorCodeMapping.put(".mpg", "TVOD");
        creatorCodeMapping.put(".asf", "TVOD");
        creatorCodeMapping.put(".mpeg", "TVOD");
        creatorCodeMapping.put(".mp3", "MAmp");
        creatorCodeMapping.put(".wav", "TVOD");
        creatorCodeMapping.put("DEFAULTMAPPING", "ttxt");
        mappingsInitialized = true;
    }

    public MacFile(File f, Integer p) {
        this.file = new File(f.getParent(), FilenameUtils.qualify(f.getName()));
        if (!mappingsInitialized) {
            MacFile.createTypeCreatorCodeMapping();
        }
        this.permissions = p;
    }

    public static String[] getMacFileMethods() {
        return macFileMethods;
    }

    public static String[] getSupportedMacFileMethods() {
        String[] allmodes = MacFile.getMacFileMethods();
        String[] filter = new String[allmodes.length];
        int count = 0;
        int i = 0;
        while (i < allmodes.length) {
            if (MacFile.isSupportedMacFileMethod(allmodes[i])) {
                filter[count++] = allmodes[i];
            }
            ++i;
        }
        String[] modes = new String[count];
        int i2 = 0;
        while (i2 < count) {
            modes[i2] = filter[i2];
            ++i2;
        }
        return modes;
    }

    public static boolean isSupportedMacFileMethod(String s) {
        if (s.equals("Native")) {
            return System.getProperty("os.name").startsWith("Mac") && !System.getProperty("os.name").equals("Mac OS X");
        }
        return true;
    }

    public Fork getResourceFork() {
        return this.resourceFork;
    }

    public Fork getDataFork() {
        return this.dataFork;
    }

    public File getFile() {
        return this.file;
    }

    public abstract void writeHeader(String var1, String var2, String var3, String var4, Calendar var5, Calendar var6, int var7) throws IOException;

    public abstract void readHeader() throws IOException;

    public long getDataSize() {
        return this.dataSize;
    }

    public long getResourceSize() {
        return this.resourceSize;
    }

    public void setDataSize(long s) {
        this.dataSize = s;
    }

    public void setResourceSize(long s) {
        this.resourceSize = s;
    }

    public abstract void cleanup() throws IOException;

    public abstract void close() throws IOException;

    public abstract boolean delete();

    public abstract boolean exists();

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public long length() {
        return this.getDataSize() + this.getResourceSize();
    }

    public String[] list() {
        return this.getFile().list();
    }

    public int getFinderFlags() {
        return this.finderFlags;
    }

    public String getType() {
        if (this.getFile().getName().endsWith(".hpf")) {
            return "HTft";
        }
        if (this.type != null) {
            return this.type;
        }
        if (this.getFile().isDirectory()) {
            return "fldr";
        }
        return this.getMapping(typeCodeMapping);
    }

    public String getCreator() {
        if (this.getFile().getName().endsWith(".hpf")) {
            return "HTLC";
        }
        if (this.creator != null) {
            return this.creator;
        }
        if (this.getFile().isDirectory()) {
            return "n/a ";
        }
        return this.getMapping(creatorCodeMapping);
    }

    private String getMapping(Hashtable mapTable) {
        String name = this.file.getName();
        if (name.indexOf(46) > 0) {
            int dotpos = name.lastIndexOf(46);
            String extension = name.substring(dotpos).toLowerCase();
            String type = (String)mapTable.get(extension);
            if (mapTable.containsKey(extension)) {
                return type;
            }
            return (String)mapTable.get("DEFAULTMAPPING");
        }
        return (String)mapTable.get("DEFAULTMAPPING");
    }

    public String getComment() {
        return this.comment;
    }

    public Calendar getCreationDate() {
        return this.getModificationDate();
    }

    public Calendar getModificationDate() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(this.file.lastModified()));
        return c;
    }

    public boolean renameTo(File f) {
        DebuggerOutput.debug("Renaming " + this.file.toString() + " to " + f.toString());
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[" + (this.file.isDirectory() ? this.file.toString() + " (directory)]" : this.resourceFork.toString() + ", " + this.dataFork.toString() + "]");
    }

    public static MacFile createMacFile(String method, File file, int permissions) throws InvocationTargetException, ClassNotFoundException, InstantiationException {
        try {
            String macFileMethod = method + "MacFile";
            Class<?> c = Class.forName("redlight.macfiles." + macFileMethod);
            Class[] paramTypes = new Class[]{class$java$io$File == null ? (class$java$io$File = MacFile.class$("java.io.File")) : class$java$io$File, class$java$lang$Integer == null ? (class$java$lang$Integer = MacFile.class$("java.lang.Integer")) : class$java$lang$Integer};
            Constructor<?> cs = c.getConstructor(paramTypes);
            Object[] params = new Object[]{file, new Integer(permissions)};
            return (MacFile)cs.newInstance(params);
        }
        catch (NoSuchMethodException e) {
            DebuggerOutput.stackTrace(e);
        }
        catch (IllegalAccessException e) {
            DebuggerOutput.stackTrace(e);
        }
        System.out.println("MacFile.createMacFile: FIXME: returning null");
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NATIVE = 0;
        SPLIT = 1;
        MACBINARY = 2;
        READ_PERM = 1;
        WRITE_PERM = 2;
        mappingsInitialized = false;
        typeCodeMapping = null;
        creatorCodeMapping = null;
    }
}

