/*
 * Decompiled with CFR 0.152.
 */
package redlight.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import redlight.utils.FilenameUtils;
import redlight.utils.MacFileUtils;
import redlight.utils.TextUtils;

public class Logger {
    FileWriter logWriter;
    Exception error;

    public boolean writeLog(String s) {
        boolean ok = false;
        if (this.logWriter != null) {
            String stripped_crlf = TextUtils.findAndReplace(s, "\r", " ");
            stripped_crlf = TextUtils.findAndReplace(stripped_crlf, "\n", " ");
            String line = DateFormat.getInstance().format(new Date(System.currentTimeMillis())) + "  " + stripped_crlf + System.getProperty("line.separator");
            try {
                this.logWriter.write(line, 0, line.length());
                this.logWriter.flush();
                ok = true;
            }
            catch (IOException e) {
                this.error = e;
            }
        }
        return ok;
    }

    public boolean openLog(File logFile, String first, boolean append) {
        boolean ok = false;
        try {
            if (!new File(logFile.getParent()).exists()) {
                new File(logFile.getParent()).mkdirs();
            }
            this.logWriter = new FileWriter(new File(logFile.getParent(), FilenameUtils.qualify(logFile.getName())).getPath(), append);
            MacFileUtils.setFileTypeAndCreator(logFile, new String("TEXT").getBytes(), new String("ttxt").getBytes());
            String line = "Log started";
            this.logWriter.write(System.getProperty("line.separator"));
            this.writeLog("Log started");
            this.writeLog(first);
            ok = true;
        }
        catch (IOException e) {
            this.error = e;
        }
        return ok;
    }

    public void closeLog() {
        if (this.logWriter != null) {
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.logWriter = null;
    }

    public Exception getError() {
        return this.error;
    }
}

