dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl AC_CHECK_JAVA_CLASS(CLASSNAME, ACTION-IF-FOUND, ACTION-IF-NOT-FOUND)
dnl Determines whether the given class can be imported and executes
dnl ACTION-IF-FOUND or ACTION-IF-NOT-FOUND correspondingly. The 
dnl macro's argument is available to the ACTIONs in the shell variable 
dnl `withval'.
AC_DEFUN(AC_CHECK_JAVA_CLASS,
[AC_REQUIRE([AC_JAVA])
AC_MSG_CHECKING(for $1)
temp_file=/tmp/ClassCheck$$
echo 'import $1;' > "$temp_file.java"
echo "public class ClassCheck$$ { }" >> "$temp_file.java"

"$JAVAC" "$temp_file.java" < /dev/null &> "$temp_file.output"

if test '!' -s "$temp_file.output"; then

  AC_MSG_RESULT(yes)
  rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"
  withval=$1
  $2

else

  cat "$temp_file.output" >&5
  AC_MSG_RESULT(no)
  rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"
  withval=$1
  $3

fi
])

dnl AC_JAVA
dnl Finds javac and java executables and tries to compile and run 
dnl test program. Failure to find the executables, or to compile
dnl the test program, or to run the test program, is fatal.
dnl Sets JAVA and JAVAC variables.
AC_DEFUN(AC_JAVA,
[AC_CHECK_PROG(JAVAC,javac,javac)
AC_CHECK_PROG(JAVA,java,java)
if test "x$JAVAC" = "x"; then

  AC_MSG_ERROR([could not find Java compiler javac.])

else

  if test "x$JAVA" = "x"; then

    AC_MSG_ERROR([could not find Java interpreter java.])

  else

    AC_MSG_CHECKING([to see if Java compiler works])

    temp_file=/tmp/GetJavaVersion$$
    cat > "$temp_file.java" <<EOF
public class GetJavaVersion$$ {
   public static void main(String args[[]]) {
      System.out.println(System.getProperty("java.version"));
   }
}
EOF

    "$JAVAC" "$temp_file.java" < /dev/null &> "$temp_file.output"

    if test '!' -s "$temp_file.output"; then

      AC_MSG_RESULT(yes)
      AC_MSG_CHECKING([for java.version property])

      oldpwd="`pwd`"
      cd /tmp
      JAVA_VERSION=`$JAVA GetJavaVersion$$ < /dev/null 2>&5`
      cd "$oldpwd"

      rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"

      if test "x$JAVA_VERSION" != "x"; then

        AC_MSG_RESULT([$JAVA_VERSION])

      else

        AC_MSG_ERROR([could not run test program; look in config.log for details.])

      fi

    else

      cat "$temp_file.output" >&5
      rm -f "$temp_file.java" "$temp_file.class" "$temp_file.output"
      AC_MSG_ERROR([could not compile test program; look in config.log for details.])
  
    fi

  fi

fi 

AC_SUBST(JAVA)
AC_SUBST(JAVAC)])

dnl AC_UPDATE_CONFIG(VAR, FILE)
dnl Strange utility function for caching configuration values.
AC_DEFUN(AC_UPDATE_CONFIG, [
if test -f "$2"; then
  old=`cat "$2"`
  if test "$old" != "$1"; then
    for i in */targets/"$1"/*.java; do
     dir=`dirname "$i"`
     dir=`dirname "$dir"`
     dir=`dirname "$dir"`
     class=`basename "$i" .java`.class
     rm -f "$dir/$class"
    done
  fi
fi
echo "$1" > "$2"])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

