/**
 * $Id: AbstractViewInterface.java,v 1.4 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;
import redlight.utils.DebuggerOutput;

/**
 * This class provides skeleton code common to all 
 * data viewers.
 */
public abstract class AbstractViewInterface 
    implements Runnable {

    Machine rlm;
    JFrame f;
    JPanel contentPane;
    PipedInputStream inputPipe;
    String filename;
    long total;
    TransferInterface transferInterface;

    public AbstractViewInterface(Machine machine, 
                                 TransferInterface transferInterface,
                                 String type,
                                 String filename,
                                 long total,
                                 PipedInputStream inputPipe) {
        
	f = new JFrame();
	contentPane = new JPanel();

        setContent(machine, transferInterface, type, filename, total, inputPipe);

        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add(contentPane, BorderLayout.CENTER);

        contentPane.registerKeyboardAction(new ActionListener() {
                
                public void actionPerformed(ActionEvent e) {
                    
                    if(e.getActionCommand().equals("Cancel"))
                        closeWindow();
                    
                }

            }, "Cancel", KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), 
                                           JComponent.WHEN_IN_FOCUSED_WINDOW);

	f.addWindowListener(new WindowAdapter() {

                public void windowClosing(WindowEvent e) {
                    
                    closeWindow();
                    
                }

            });

    }

    public void show() {

        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = f.getSize();
                
        f.setLocation((d.width / 2) - (w.width / 2), 
                      (d.height / 2) - (w.height / 2));

        f.show();

    }

    /**
     * Just try and keep up with the stream ...
     */
    abstract public void run();

    public void setContent(Machine rlm,
                           TransferInterface transferInterface, 
                           String type,
                           String filename,
                           long total,
                           PipedInputStream inputPipe) {

        this.rlm = rlm;
        this.transferInterface = transferInterface;
        this.inputPipe = inputPipe;
        this.total = total;
        this.filename = filename;

        f.setTitle("Viewing " + filename + " as " + type + " (" + rlm.getServerName() + ")");

    }

    void closeWindow() {

        transferInterface.close();
        f.dispose();
        f = null;
        contentPane = null;
        transferInterface = null;
        System.gc();

    }

}
