/**
 * $Id: BorderedPanel.java,v 1.2 2001/10/04 01:03:59 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.Insets;
import javax.swing.*;
import javax.swing.border.*;

/**
 * Borders a JPanel with a title and an etched line.
 */
public class BorderedPanel extends JPanel {
    
    static Border emptyBorder = 
        new EmptyBorder((Insets) Main.rlo.getProperty("BorderInsets"));

    BorderedPanel(String title) {

        super();

        Border lineBorder = 
            BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
        Border titleBorder = 
            BorderFactory.createCompoundBorder(lineBorder, emptyBorder);

        setBorder(titleBorder);

    }   

}
