/**
 * $Id: ButtonedPanel.java,v 1.1 2001/10/06 14:32:01 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import redlight.hotline.*;
import redlight.utils.DebuggerOutput;
import redlight.graphics.Spinner;

/**
 */
public class ButtonedPanel extends JPanel {

    JComponent top;
    ButtonPanel buttons;

    public ButtonedPanel(JComponent top, ButtonPanel buttons) {

        super();

        this.top = top;
        this.buttons = buttons;

        GridBagConstraints gbc = new GridBagConstraints();

        setLayout(new BorderLayout());

        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1;
        gbc.weighty = 1;
        gbc.fill = gbc.BOTH;
        gbc.anchor = gbc.NORTHWEST;
        gbc.insets = (Insets) Main.rlo.getProperty("BorderInsets");
        add(top, BorderLayout.CENTER);

        gbc.gridx = 0;
        gbc.gridy = 1;
	gbc.weightx = 0; 
        gbc.weighty = 0;
	gbc.fill = gbc.BOTH;
	gbc.anchor = gbc.NORTHWEST;
        gbc.insets = new Insets(0, 8, 0, 8); /* keep a little to the right & left */
        add(buttons, BorderLayout.SOUTH);

    }

}

