/**
 * $Id: ChatInterface.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.io.File;
import java.util.BitSet;

import javax.swing.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;
import redlight.script.*;
import redlight.utils.DebuggerOutput;

/**
 * The chat interface.
 */
public class ChatInterface extends ChatWindow
    implements ActionListener, 
               WindowListener, 
               Scriptable {

    static int x = 0, y = 0;
    Machine rlm;
    Container contentPane;
    JTextField input;
    JCheckBox logEnabled;
    JFrame chatFrame;
    boolean swallow;

    public ChatInterface(Machine machine) {

	this(machine, false);

    }

    public ChatInterface(Machine machine, boolean sw) {

	rlm = machine;
	swallow = sw;
	rlm.getScriptBroker().addTarget(this);
	Font guiFont = (Font) Main.rlo.getProperty("Font.gui");

        if(swallow == false) {
            
            chatFrame = new JFrame("Chat (" + 
                                   rlm.getServerName() + ")");
            contentPane = chatFrame.getContentPane();

	    } else {

		try {

		    ScriptResult[] sr = rlm.getScriptBroker().
			executeScript(new ScriptObject(Scripting.
						       SWALLOW_REQUEST, 
						       this));
		    contentPane = (Container) sr[0].getUserObject();

		} catch (UnknownMessageException e) {

		    e.printStackTrace();

		}

	    }

            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();

	    chat = new JTextArea("", 10, 70);
	    input = new JTextField("", 40);
	    logEnabled = new JCheckBox("Log", 
				       rlm.isLogEnabled());
	    JPanel p = new JPanel();
	    JPanel p2 = new JPanel();

	    logEnabled.setFont(guiFont);
	    chat.setBackground(rlm.getSchemeColor("background"));
	    chat.setForeground(rlm.getSchemeColor("foreground"));
	    chat.setLineWrap(true);
	    chat.setWrapStyleWord(true);
	    chat.setFont((Font) Main.rlo.getProperty("Font.text"));
	    chat.setEditable(false);
	    input.setBackground(rlm.getSchemeColor("background"));
	    input.setForeground(rlm.getSchemeColor("foreground"));
	    input.setFont(chat.getFont());
            input.requestFocus();

	    logEnabled.addActionListener(this);
            input.addActionListener(this);

            /* Sensible focus handling in Swing is a disaster. For
               some reason it is necessary to explicitly bind our
               action listener to the VK_ENTER key to ensure that the
               listener gets called when the user presses VK_ENTER on
               our chat input field. If we don't do this, giving focus
               to another (new) JTextArea while the chat input
               JTextField is focused will result in VK_ENTER being
               ignored on the chat input JTextField. */

            //            input.registerKeyboardAction(this, KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), JComponent.WHEN_FOCUSED);

	    p2.setLayout(new FlowLayout());
	    p2.add(logEnabled);
	    p.setLayout(new BorderLayout());
	    p.add(input, BorderLayout.CENTER);
	    p.add(p2, BorderLayout.EAST);

            contentPane.setLayout(gbl);
            gbc.weighty = 1;
            gbc.weightx = 1;
            gbc.gridheight = gbc.RELATIVE;
            gbc.gridwidth = gbc.REMAINDER;
            gbc.fill = gbc.BOTH;
            gbc.anchor = gbc.CENTER;
            gbc.insets = new Insets(4, 4, 0, 4);
            contentPane.add(new JScrollPane(chat), gbc);
            gbc.gridy = 1;
            gbc.weighty = 0;
            gbc.gridheight = gbc.REMAINDER;
            gbc.fill = gbc.HORIZONTAL;
            gbc.anchor = gbc.SOUTH;
            gbc.insets = new Insets(0, 4, 4, 4);
            contentPane.add(p, gbc);

	    if(swallow == false) {

		chatFrame.pack();
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension w = chatFrame.getSize();
		
		if(x == 0) {
		    x = (d.width / 100) * 2;
		    y = (d.height / 100) * 2;
		}
		chatFrame.setLocation(x, y);
		
		chatFrame.addWindowListener(this);
		chatFrame.show();

	    }

	    rlm.registerChat(this);

    }

    public void show() {

        input.requestFocus();

        if(swallow == false) 
            chatFrame.show();

    }

    ScriptResult processStateChange(StateObject state) {

	if(state.isPublicState()) {

	    switch(state.what) {
	    case StateObject.LOG:
		logEnabled.setSelected(rlm.isLogEnabled());
		break;
	    }

	}

	return new ScriptResult(this, null);

    }

    /**
     * Following method implements ActionListener.
     */
    public void actionPerformed(ActionEvent e) {

	input.setBackground(rlm.getSchemeColor("background"));
	input.setForeground(rlm.getSchemeColor("foreground"));

	if(e.getSource() == input) {

	    if(!input.getText().trim().equals("")) {

		try {

		    if(((e.getModifiers() & 
			 ActionEvent.SHIFT_MASK) == ActionEvent.SHIFT_MASK)
		       || (input.getText().length() > 4 && 
			   input.getText().substring(0,4).equals("/me ")))
			
			rlm.getHLC().
			    sendChatAction(input.getText().substring(4));

		    else

			rlm.getHLC().sendChat(input.getText());

		    input.setText("");
                    input.setCaretPosition(0);

		} catch (IOException _e) {

		    _e.printStackTrace();
		    rlm.getInterface().error(_e);

		}

	    }

	} else if(e.getSource() == logEnabled) {

	    rlm.setState(StateObject.LOG,
				 new Boolean(logEnabled.isSelected()));

	}

    }

    /**
     * Following methods implement WindowListener.
     */
    public void windowActivated(WindowEvent e) {

	chat.requestFocus();
	input.requestFocus();

    }

    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) { }
    public void windowClosing(WindowEvent e) {

	e.getWindow().setVisible(false);

    }

    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
	
    /**
     * Following methods implement Child.
     */
    public void close() {

        if(swallow == false) {
            
            chatFrame.setVisible(false);
            chatFrame.dispose();
            
        } else {
            
            try {
                
                rlm.getScriptBroker().
                    executeScript(new ScriptObject(Scripting.
                                                   UNSWALLOW_REQUEST, 
                                                   contentPane));
                
            } catch (UnknownMessageException e) {}
            
        }
        
        rlm.getScriptBroker().removeTarget(this);
        
    }

    public void displayPropertyChanged(String what, final Object property) {

	if(what.equals("textfont")) {

            SwingUtilities.invokeLater(new Runnable() {

                    public void run() {

                        chat.setEnabled(false);
                        chat.setFont((Font) property);
                        input.setFont((Font) property);
                        chat.setText(chat.getText());
                        chat.repaint();
                        input.repaint();
                        chat.setEnabled(true);

                    }

                });

	} else {

            SwingUtilities.invokeLater(new Runnable() {

                    public void run() {

                        chat.setBackground(rlm.getSchemeColor("background"));
                        chat.setForeground(rlm.getSchemeColor("foreground"));
                        input.setBackground(rlm.getSchemeColor("background"));
                        input.setForeground(rlm.getSchemeColor("foreground"));
                        
                    }

                });

	}

	if(swallow == false)
	    chatFrame.repaint();

    }

    /**
     * Following methods implement Scriptable.
     */

    public void gotTarget(ScriptBroker sb) {}
    public void lostTarget(ScriptBroker sb) {}
    public long getKnownMessages() {

	return Scripting.CLOSE_WINDOW |
	    Scripting.STATE_CHANGED;

    }

    public ScriptResult executeScript(ScriptObject s) 
	throws UnknownMessageException {

	int value = (int) s.getType();

	switch(value) {

	case Scripting.CLOSE_WINDOW:
	    if((Container) s.getUserObject() == contentPane) {
		//		closeUnregister();
		return new ScriptResult(this, null);
	    }
	    break;

	case Scripting.STATE_CHANGED:
	    StateObject state = (StateObject) s.getUserObject();
	    return processStateChange(state);	    

	}

	throw new UnknownMessageException();
    }

}





