/**
 * $Id: FileSizeTableCellRenderer.java,v 1.2 2001/09/09 11:41:10 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import javax.swing.table.*;
import javax.swing.*;
import java.awt.*;

/**
 * Renderer for file size.
 */
public class FileSizeTableCellRenderer extends JLabel 
    implements TableCellRenderer {
    boolean selected = false;

    public FileSizeTableCellRenderer() {
	super();
	setHorizontalAlignment(SwingConstants.RIGHT);
	setOpaque(true);	
    }

    public Component getTableCellRendererComponent(JTable table,
						   Object value,
						   boolean isSelected,
						   boolean hasFocus,
						   int row,
						   int column) {
	setBackground(isSelected ? table.getSelectionBackground() :
		      table.getBackground());
	setText(value.toString() + " ");
	return this;
    }

    public void paint(Graphics g) {
	g.clearRect(0, 0, getWidth(), getHeight());
	super.paint(g);
    }
}

