/**
 * $Id: HelpTextPanel.java,v 1.3 2001/10/07 04:43:39 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.Insets;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.*;

public class HelpTextPanel extends BorderedPanel {

    GridBagConstraints gbc = new GridBagConstraints();
    HelpTextArea helpTextArea;

    HelpTextPanel(String title, String helpText, JComponent center) {

        this(title, helpText);

        gbc.anchor = gbc.WEST;
        gbc.fill = gbc.BOTH;
        gbc.weightx = 1;
        gbc.weighty = 1;
        add(center, gbc);

    }

    HelpTextPanel(String title, String helpText) {
        
        super(title);

        setLayout(new GridBagLayout());

        Insets oldInsets = gbc.insets;
        gbc.anchor = gbc.NORTHWEST;
	gbc.gridx = 1;
	gbc.gridy = 1;
        gbc.fill = gbc.HORIZONTAL;
        gbc.gridwidth = gbc.REMAINDER;
        gbc.weightx = 1;
        gbc.weighty = 0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbc.insets = new Insets(0, 0, 8, 0);
        helpTextArea = new HelpTextArea(helpText);
        add(helpTextArea, gbc);
        gbc.insets = oldInsets;
        gbc.gridy++;
        gbc.gridwidth = 1;
        gbc.weightx = 0;
        gbc.weighty = 0;
        gbc.fill = gbc.NONE;

    }

}

