/**
 * $Id: ManualInterface.java,v 1.5 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.*;
import java.net.URL;

import redlight.utils.DebuggerOutput;

public class ManualInterface implements WindowListener, HyperlinkListener {

    Container contentPane;
    JFrame f;
    JEditorPane text;
    
    ManualInterface() {

	f = new JFrame("Red Light documentation");
	contentPane = f.getContentPane();
	contentPane.setLayout(new GridLayout(1, 1));

        try {

            text = new JEditorPane(ClassLoader.getSystemResource("redlight/Documentation/rl/index.html"));

        } catch(IOException e) {

            text = new JEditorPane("<b>An error occurred:</b> " + e.toString(), "text/html");

        }

        text.setEditable(false);
        text.addHyperlinkListener(this);
        text.setPreferredSize(new Dimension(550, 340));

        f.addWindowListener(this);

        contentPane.add(new JScrollPane(text));
            
        f.pack();

        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = new Dimension(550, 340);
                
        f.setLocation((d.width / 2) - (w.width / 2), 
                      (d.height / 2) - (w.height / 2));

	f.show();
        
    }
    
    public void show() {

        if(f != null) {

            f.setVisible(true);
            f.toFront();
            return;
            
        }
        
    }


    /**
     * Following methods implement WindowListener.
     */
    public void windowActivated(WindowEvent e) {}

    public void windowDeactivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        
        f.setVisible(false);

    }

    public void windowIconified(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

    /**
     * Following methods implements HyperlinkListener.
     */
    public void hyperlinkUpdate(final HyperlinkEvent e) {

        if(e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            
            try {

                if(e.getURL() == null) {

                    DebuggerOutput.debug(e.getDescription());

                    final String location;

                    if(e.getDescription().startsWith("#")) {
                                             
                        location = new URL(text.getPage().toString() + e.getDescription()).toString();
                        DebuggerOutput.debug("newURL = " + location);

                    } else {
                    
                        location = "text/manual/" + e.getDescription();

                    }
                    
                    SwingUtilities.invokeLater(new Runnable() {
                            
                            public void run() {
                                
                                try {
                                    
                                    text.setPage(getClass().getResource(location));
                                    
                                } catch(IOException e) {
                                    
                                    DebuggerOutput.stackTrace(e);
                                    
                                }
                                
                            }
                            
                        });

                } else {
                    
                    if(e.getURL().toString().startsWith("jar")) {

                        SwingUtilities.invokeLater(new Runnable() {
                                
                                public void run() {
                                    
                                    try {
                                        
                                        text.setPage(e.getURL());
                                        
                                    } catch(IOException e) {
                                        
                                        DebuggerOutput.stackTrace(e);
                                        
                                    }
                                    
                                }
                                
                            });
                        
                    } else {

                        String app = Main.rlo.getHelperApp(e.getURL());
                        
                        if(app != null) {
                            
                            String[] args = { app, e.getURL().toString() };
                            Runtime.getRuntime().exec(args);
                            
                        }

                    }
                        
                }

            } catch(IOException _e) {

                DebuggerOutput.stackTrace(_e);

            }
            
        }

    }

}

