/**
 * $Id: PostInterface.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import redlight.hotline.*;
import redlight.utils.*;

/**
 * The flat news post interface.
 */
public class PostInterface implements ActionListener, 
                                          WindowListener {
    Machine rlm;
    JTextArea message;
    JButton post, cancel;
    JFrame f;
    Container contentPane;
	
    public PostInterface(Machine machine) {
	rlm = machine;

	Font guiFont = (Font) Main.rlo.getProperty("Font.gui");

	f = new JFrame("Post news (" + machine.getServerName() + ")");
	contentPane = f.getContentPane();
	GridBagConstraints gbc = new GridBagConstraints();
	message = new JTextArea("", 10, 30);
	JPanel messagePane = new JPanel();
        JPanel buttonPanel = new JPanel();
	JScrollPane scrollPane = new JScrollPane(message);
	post = new JButton("Post");
	cancel = new JButton("Cancel");

        Border emptyBorder = 
            new EmptyBorder((Insets) Main.rlo.getProperty("BorderInsets"));
        Border lineBorder = 
            BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Post news");
        Border postBorder = 
            BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        JTextArea postHelpText = new JTextArea("Enter a message and hit 'Post' to it add to the news:");

        postHelpText.setLineWrap(true);
        postHelpText.setWrapStyleWord(true);
        postHelpText.setOpaque(false);
        postHelpText.setEditable(false);
        message.setLineWrap(true);
        message.setWrapStyleWord(true);
	contentPane.setLayout(new GridBagLayout());
        messagePane.setLayout(new GridBagLayout());
        messagePane.setBorder(postBorder);
        buttonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));

	message.setBackground(rlm.getSchemeColor("background"));
	message.setForeground(rlm.getSchemeColor("foreground"));

        post.setMnemonic('P');
        cancel.setMnemonic('C');

        cancel.registerKeyboardAction(this, "Cancel", KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_IN_FOCUSED_WINDOW);

	post.addActionListener(this);
	cancel.addActionListener(this);

        SwingUtilities.getRootPane(f).setDefaultButton(post);

        gbc.anchor = gbc.NORTHEAST;
	gbc.gridx = 0; 
        gbc.gridy = 0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbc.weightx = 1;
        gbc.fill = gbc.HORIZONTAL;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 8, 0);
        messagePane.add(postHelpText, gbc);
        gbc.insets = oldInsets;
        gbc.gridy = 1;
        gbc.gridx = 0;
	gbc.weightx = 1; 
        gbc.weighty = 1;
	gbc.fill = GridBagConstraints.BOTH;
        messagePane.add(scrollPane, gbc);

	buttonPanel.add(cancel);
	buttonPanel.add(post);
        gbc.insets = (Insets) Main.rlo.getProperty("BorderInsets");

	gbc.weightx = 1; 
        gbc.weighty = 1;
	gbc.gridx = 0; 
        gbc.gridy = 0;
	gbc.fill = GridBagConstraints.BOTH;
	contentPane.add(messagePane, gbc);
        gbc.gridy = 1;
        gbc.weightx = 0;
        gbc.weighty = 0;
        gbc.insets = new Insets(0, 0, 0, 8);
        contentPane.add(buttonPanel, gbc);

	f.pack();

	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension w = f.getSize();
		
	f.setLocation((d.width / 2) - (w.width / 2), 
		      (d.height / 2) - (w.height / 2));

        message.requestFocus();
	message.setCaretPosition(0);

	f.setVisible(true);

    }
	
    public void displayPropertyChanged(final String what, 
                                       final Object property) {

        SwingUtilities.invokeLater(new Runnable() {

                public void run() {

                    if(what.equals("textfont")) {
                        
                        f.setFont((Font) property);
                        
                    } else {
                        
                        f.setBackground(rlm.getSchemeColor("background"));
                        f.setForeground(rlm.getSchemeColor("foreground"));	
                        
                    }
                   
                } 
                    
            });

    }

    public void show() {

	f.setVisible(true);
	f.toFront();

    }

    /**
     * Following methods implement ActionListener.
     */
    public void actionPerformed(ActionEvent e) {

	try {

	    if(e.getActionCommand().equals("Post")) {

		rlm.getHLC().requestNewsPost(TextUtils.findAndReplace(message.getText(), "\n", "\r"));
		f.setVisible(false);
		f.dispose();

	    } else {

		f.setVisible(false);
		f.dispose();

	    }

	} catch(IOException ex) {

            DebuggerOutput.stackTrace(ex);

	}

    }

    /**
     * Following methods implement WindowListener.
     */
    public void windowActivated(WindowEvent e) { }
    public void windowDeactivated(WindowEvent e) { }
    public void windowClosed(WindowEvent e) { }
    public void windowClosing(WindowEvent e) {
	e.getWindow().setVisible(false);
    }
    public void windowIconified(WindowEvent e) { }
    public void windowDeiconified(WindowEvent e) { }
    public void windowOpened(WindowEvent e) {}
	
}
