/**
 * $Id: ResumeInterface.java,v 1.1 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import redlight.utils.TextUtils;

public class ResumeInterface {

    private Thread thread;
    private ResumeActionListener ral;
    private String filename;

    public ResumeInterface(final String filename,
                           final boolean autoResume, 
                           final ResumeActionListener ral) {

        this.filename = filename;
        this.ral = ral;

        thread = new Thread(new Runnable() {

                public void run() {
                    
                    /* -1 cancel, 0 don't resume, 1 resume ok */
                    
                    int action = 0;
                    
                    if(autoResume)
                        action = 1;
                    else if(ral.canResume())
                        action = promptUser();
                    
                    if(action == -1)
                        ral.resumeCancelled();
                    else
                        ral.resumeAnswered(autoResume || (action == 1));
                    
                }
                
            });

        thread.start();

    }

    public void interrupt() {

        thread.interrupt();

    }

    int promptUser() {
        
        int button = JOptionPane.NO_OPTION;
        int action = -1;

        action = JOptionPane.showConfirmDialog(null, TextUtils.wordWrap("Do you want to resume " + filename + ", continuing the transfer where you left off?", 40), "Resume?", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE);

        if(action != JOptionPane.YES_OPTION &&
           action != JOptionPane.NO_OPTION)
            action = JOptionPane.CANCEL_OPTION;
        
        if(action == JOptionPane.CANCEL_OPTION || thread.isInterrupted())
            return -1;

        if(action == JOptionPane.YES_OPTION)
            action = 1;
        else
            action = 0;

        return action;

    }

}
