/**
 * $Id: URLHandler.java,v 1.1 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.io.IOException;
import java.awt.event.*;
import javax.swing.event.*;

import redlight.hotline.HLProtocol;
import redlight.utils.DebuggerOutput;

public class URLHandler implements HyperlinkListener {

    Machine rlm;
    String path;
    HLProtocol.FileListComponent file;

    public URLHandler(Machine rlm, 
                      String path, 
                      HLProtocol.FileListComponent file) {

        this.rlm = rlm;
        this.path = path;
        this.file = file;

    }

    /**
     * Following method implements HyperlinkListener.
     */
    public void hyperlinkUpdate(HyperlinkEvent e) {
        
        if(e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            
            try {

                if(e.getURL() == null) {

                    try {

                        HLProtocol.FileListComponent f = 
                            (HLProtocol.FileListComponent) file.clone();
                        path = path.substring(0, path.indexOf(f.fileName));
                        String pathOnServer = stripDoubleDot(e.getDescription().replace('/', HLProtocol.DIR_SEPARATOR));
                        path = path + HLProtocol.DIR_SEPARATOR + pathOnServer;
                        f.fileName = pathOnServer;
                        new ViewInterface(rlm, path, f, null);
                        
                    } catch(CloneNotSupportedException _e) {
                        
                        DebuggerOutput.stackTrace(_e);
                        
                    }

                } else {
                    
                    String app = Main.rlo.getHelperApp(e.getURL());

                    if(app != null) {

                        String[] args = { app, e.getURL().toString() };
                        Runtime.getRuntime().exec(args);

                    }

                }

            } catch(IOException _e) {

                DebuggerOutput.stackTrace(_e);

            }
            
        }

    }
 
    static private String stripDoubleDot(String hlPath) {

        return hlPath;

    }
   
}
