/**
 * $Id: ViewTextInterface.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

import redlight.hotline.*;
import redlight.utils.TextUtils;
import redlight.utils.DebuggerOutput;

/**
 * This class displays a piece of text as it arrives on a
 * PipedInputStream.
 */
public class ViewTextInterface extends AbstractViewInterface
    implements Runnable {

    JScrollPane scrollPane;
    JTextArea text;

    public ViewTextInterface(Machine machine, 
                                 TransferInterface transferInterface,
                                 String filename,
                                 long total,
                                 PipedInputStream inputPipe) {

	super(machine, transferInterface, "text" ,filename, total, inputPipe);

	text = new JTextArea("", 20, 60);
	scrollPane = new JScrollPane(text);

	text.setBackground(machine.getSchemeColor("background"));
	text.setForeground(machine.getSchemeColor("foreground"));
	text.setFont((Font) Main.rlo.getProperty("Font.text"));
	text.setEditable(false);
	text.setFont((Font) Main.rlo.getProperty("Font.text"));
        text.setWrapStyleWord(false);
        text.setLineWrap(false);
	scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        contentPane.setLayout(new BorderLayout());

        contentPane.add(scrollPane, BorderLayout.CENTER);

        f.pack();
        show();

	new Thread(this).start();

    }

    /**
     * Just try and keep up with the stream ...
     */
    public void run() {
        
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader(inputPipe));
        
        StringBuffer content = new StringBuffer();

        try {
            
            text.setText("");
            text.setCaretPosition(0);

            for(String line = lineReader.readLine(); 
                line != null; 
                line = lineReader.readLine()) {

                content.append(line + "\n");

                /* Refresh every 100 lines. */

                if(lineReader.getLineNumber() % 100 == 0) {

                    text.append(content.toString());
                    content.setLength(0);

                }

            }

        } catch(IOException e) {
            
            DebuggerOutput.stackTrace(e);
            
        } finally {

            text.append(content.toString());
            content.setLength(0);

        }
        
        DebuggerOutput.debug("ViewTextInterface.slurper: exiting");
        
    }
    
}





