package redlight.hotline.iconlib;
/*
                Read the license.txt file for license information!
                If you don't have it, get it at www.MarkusStengel.de.
*/

/**
 *          stores file info data of an object like an ICON or a GIFf, such as its identity, name,
 *          size and offset in the hotline.dat file
 *          @author     Markus Stengel
 *          @see          <a href="http://www.MarkusStengel.de">developer site</a>
 */
public class HLData {
     String     name;
     int          identity;
     int          dataSize;
     int           dataOffset;

     /**
      *          initalizes the class variables
      */
     public HLData() {
          identity      = 0;
          dataSize          = 0;
          dataOffset     = 0;
          name                = null;
     }

     /**
      *          returns the identity of the ICON, GIFf, ...
      *          @return               identity
      */
     public int getIdentity()           {     return identity;     }
     /**
      *          returns the name of the ICON, GIFf, ...
      *          @return               name of the ICON, GIFf...
      */
     public String getName()           {     return name;     }
     /**
      *          returns the size of the ICON, GIFf, ... data block in the file
      *          @return               size of the data block
      */
     public int getDataSize()           {     return dataSize;     }
     /**
      *          returns the offset of the ICON, GIFf, ... data block
      *          @return               offset of the data block
      */
     public int getDataOffset()      {     return dataOffset;     }
}