/**
 * $Id: NativeMacFile.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.*;
import java.util.Calendar;

import redlight.utils.ToArrayConverters;
import redlight.utils.Meter;
import redlight.utils.MeterSource;
import redlight.utils.DebuggerOutput;

/**
 * A NativeMacFile relies on functions that are only available
 * on the Macintosh platform. Therefore, you should only 
 * instantiate this class on the Mac. You can use the
 * {@link redlight.macfiles.MacFile#getSupportedMacFileMethods}
 * method to find out which MacFile methods are supported.
 * @see redlight.macfiles.MacFile
 */
public class NativeMacFile extends MacFile {

    /**
     * Constructs a NativeMacFile from a given File.
     * @param f the file
     */
    public NativeMacFile(File f, Integer perms) throws IOException {

	super(f, perms);

	dataFork = new SplitFork(this, permissions, "data", "");
	resourceFork = new NativeResourceFork(this, permissions);

    }

    /**
     * No function in NativeMacFile.
     */
    public void readHeader() throws IOException {
    }

    /**
     * No function in NativeMacFile.
     */
    public void writeHeader(String name, 
			    String type, 
			    String creator,
			    String comments, 
			    Calendar created, 
			    Calendar modifed, 
			    int finderFlags) throws IOException {
	
    }
   
    /**
     * No function in NativeMacFile.
     */
    public void cleanup() throws IOException {
    }

    /**
     * Closes the data and resource forks.
     */
    public void close() throws IOException {

        if(file.exists() && file.isDirectory())
            return;

        resourceFork.close();
        resourceFork = null;
        dataFork.close();
        dataFork = null;

    }

    /**
     * Determines whether either the data fork or the 
     * resource fork exist.
     * @return true if either the data fork or the
     * resource fork exist.
     */
    public boolean exists() {

        if(file.exists() && file.isDirectory())
            return true;

	return resourceFork.exists() | dataFork.exists();

    }

    /**
     * @return true if the file was deleted.
     */
    public boolean delete() {
        
        boolean s = false;
        
        try {
            
            close();
            s = file.delete();
            
        } catch(IOException e) {}
        
        return s;
        
    }

    public boolean renameTo(File f) {

        boolean s = false;

        try {

            close();
            s = dataFork.renameTo(f);

        } catch(IOException e) {}

        return s;

    }

}
