/**
 * $Id: Listener.java,v 1.1.1.1 2001/07/22 02:44:49 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

package redlight.server;

import java.io.IOException;

import redlight.hotline.HLServer;
import redlight.hotline.HLServerListener;
import redlight.hotline.HLServerDispatcher;
import redlight.hotline.HLProtocol;
import redlight.utils.DebuggerOutput;

/**
 * This class responds to HLServer events in a typical  fashion.
 */
public class Listener extends HLServerListener {

    HLServer hls;

    /**
     * Creates this listener.
     */
    Listener(HLServer hls) {

        this.hls = hls;

    }

    /**
     * Called when the server is ready and listening.
     */
    public void serverReady() {

        Main.console = new Console(hls, Main.initFile);

    }

    /**
     * Called when a single line should be logged.
     * @param line the log line.
     */
    public void logLine(String line) {

        Main.logLine(line);
        DebuggerOutput.debug(line);

    }
    
}
