/**
 * $Id: Meter.java,v 1.3 2001/09/08 01:27:23 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import redlight.utils.MeterSource;

/**
 * A Meter is a class monitoring some operation performed
 * by a {@link redlight.utils.MeterSource}.
 */
public interface Meter {
    /**
     * Invoked when the operation starts.
     * @param ms the {@link redlight.utils.MeterSource} for this Meter.
     * @param key some identifier for the operation
     * @param s a string describing the operation
     * @param size the size of the operation
     */
    public void startMeter(MeterSource ms, int key, String s, long size);
    /**
     * Invoked periodically to signal how much progress has been made.
     * @param key some identifier
     * @param done the amount of the operation done
     */
    public void progressMeter(int key, long done);
    /**
     * Invoked when the operation successfully
     * completes.
     * @param key the identifier of the operation
     */
    public void stopMeter(int key);
    /**
     * Invoked when an error occurs during the operation.
     * Classes implementing the Meter interface should
     * clean up and terminate when this method is invoked.
     * @param key the identifier of the operation
     * @param t the error
     */
    public void stopMeterWithError(int key, Throwable t);
    /**
     * Returns the MeterSource that is being monitored.
     * @return MeterSource
     * @see redlight.utils.MeterSource
     */
    public MeterSource getMeterSource();
}

