import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Simple LRU Hash table implemented on top of LinkedHashMap
 *
 * @author Radim Kolar
 */

public class LRUHashtable <K,V> extends LinkedHashMap <K,V> {
	static final long serialVersionUID = 4808637051277325637L;

	/* maximum number of entries in table */
    private int ourmaxsize;

    /**
      Creates empty hash table with LRU expiration of entries
      by insert time.
    */
    public LRUHashtable(int size)
    {
        super (size,0.7f,false);
        if (size <= 0 )
        	throw new IllegalArgumentException("table size must be positive integer");
        this.ourmaxsize=size;
    }

    /**
     * Signal LinkedHashMap to expire Eldest entry if table is full.
     */
    protected boolean removeEldestEntry(Map.Entry <K,V> eldest) {
        return size() > ourmaxsize;
    }

    /**
     * Get maximum number of entries in hash table.
     * @return	maximum number of entries in table
     */
    public int maxCapacity() {
        return ourmaxsize;
    }
}