/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.sdg.xdman.core.common.Authenticator;
import org.sdg.xdman.core.common.ConnectionManager;
import org.sdg.xdman.core.common.DownloadInfo;
import org.sdg.xdman.core.common.DownloadStateListner;
import org.sdg.xdman.core.common.XDMConfig;
import org.sdg.xdman.gui.AboutDialog;
import org.sdg.xdman.gui.AdvYTDlg;
import org.sdg.xdman.gui.AssembleDialog;
import org.sdg.xdman.gui.BarPanel;
import org.sdg.xdman.gui.BatchDlg;
import org.sdg.xdman.gui.BatchDownloadDlg;
import org.sdg.xdman.gui.BatchDownloadListener;
import org.sdg.xdman.gui.BatchItem;
import org.sdg.xdman.gui.BrowserIntDlg;
import org.sdg.xdman.gui.ConfigDialog;
import org.sdg.xdman.gui.DownloadCompleteDialog;
import org.sdg.xdman.gui.DownloadList;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.DropBox;
import org.sdg.xdman.gui.FileTransferHandler;
import org.sdg.xdman.gui.HelpDialog;
import org.sdg.xdman.gui.IconUtil;
import org.sdg.xdman.gui.MainTableModel;
import org.sdg.xdman.gui.MediaInfo;
import org.sdg.xdman.gui.MediaTableModel;
import org.sdg.xdman.gui.NewDownloadWindow;
import org.sdg.xdman.gui.OSXInstallWindow;
import org.sdg.xdman.gui.PropertiesDialog;
import org.sdg.xdman.gui.RefreshLinkDlg;
import org.sdg.xdman.gui.SidePanel;
import org.sdg.xdman.gui.StaticResource;
import org.sdg.xdman.gui.StringResource;
import org.sdg.xdman.gui.XDMButton;
import org.sdg.xdman.gui.XDMButtonUI;
import org.sdg.xdman.gui.XDMDownloadWindow;
import org.sdg.xdman.gui.XDMFileChooser;
import org.sdg.xdman.gui.XDMFrame;
import org.sdg.xdman.gui.XDMIconMap;
import org.sdg.xdman.gui.XDMListItemRenderer;
import org.sdg.xdman.gui.XDMLookAndFeel;
import org.sdg.xdman.gui.XDMThrottleDlg;
import org.sdg.xdman.gui.XDMToolBarButtonUI;
import org.sdg.xdman.gui.XDMTreeNode;
import org.sdg.xdman.gui.YoutubeGrabberDlg;
import org.sdg.xdman.interceptor.DownloadIntercepterInfo;
import org.sdg.xdman.interceptor.IMediaGrabber;
import org.sdg.xdman.interceptor.XDMServer;
import org.sdg.xdman.util.LinuxUtil;
import org.sdg.xdman.util.Logger;
import org.sdg.xdman.util.OSXUtil;
import org.sdg.xdman.util.XDMUtil;

public class XDMMainWindow
extends XDMFrame
implements TreeSelectionListener,
ActionListener,
DownloadStateListner,
BatchDownloadListener,
IMediaGrabber {
    private static final long serialVersionUID = -5562142092210683635L;
    JComboBox cmb;
    String state;
    String type;
    int windowState;
    JPanel toolbar;
    JButton addurl;
    JButton resume;
    JButton pause;
    JButton delete;
    JButton option;
    JButton youtube;
    JButton media;
    JButton exit;
    JLabel closetree;
    JSplitPane split;
    JTree tree;
    JTable table;
    MainTableModel model = new MainTableModel();
    static DownloadList list = null;
    static String tempdir = null;
    static String destdir = null;
    static String appdir = null;
    static XDMConfig config;
    Toolkit t;
    JPopupMenu pop;
    JSplitPane content;
    XDMToolBarButtonUI toolBtnUI;
    JMenuBar bar;
    XDMButtonUI btnUI;
    ConfigDialog configDlg;
    BatchDlg batchDlg;
    BatchDownloadDlg listDlg;
    MediaTableModel mediaModel = new MediaTableModel();
    YoutubeGrabberDlg ytDlg;
    JPopupMenu ctxPopup;
    BrowserIntDlg biDlg;
    JLabel lbl;
    AboutDialog abtDlg;
    boolean processQueue;
    DownloadListItem qi;
    boolean schedulerActive;
    AssembleDialog asmDlg;
    Clipboard clipboard;
    DropBox w;
    JLabel[] lblCatArr;
    SidePanel sp;
    JLabel btnTablet;
    JButton btnSort;
    JTextField txtSearch;
    JMenuItem[] sortItems;
    JButton[] btnTabArr;
    Thread st;
    int hotcount = 0;
    boolean hot = false;
    static HashMap<String, String> arg;

    static {
        arg = new HashMap();
    }

    public XDMMainWindow() {
        this.setIconImage(XDMIconMap.getIcon("APP_ICON").getImage());
        this.setTitle(this.getString("TITLE"));
        this.t = Toolkit.getDefaultToolkit();
        if (XDMMainWindow.config.mwW <= 0) {
            Dimension d = this.t.getScreenSize();
            int w = 700;
            int h = 400;
            if (d.width < w) {
                w = d.width;
            }
            if (d.height < h) {
                h = d.height;
            }
            this.setSize(w, h);
            this.setLocationRelativeTo(null);
        } else {
            this.setSize(XDMMainWindow.config.mwW, XDMMainWindow.config.mwH);
            this.setLocation(XDMMainWindow.config.mwX, XDMMainWindow.config.mwY);
        }
        JLabel lblTitle = new JLabel("XDM 2015");
        lblTitle.setBorder(new EmptyBorder(20, 20, 0, 0));
        lblTitle.setFont(new Font("Dialog", 0, 24));
        lblTitle.setForeground(StaticResource.whiteColor);
        this.getTitlePanel().add((Component)lblTitle, "West");
        this.bar = new JMenuBar();
        this.bar.setBorderPainted(false);
        this.bar.setForeground(StaticResource.whiteColor);
        this.bar.setMaximumSize(new Dimension(this.bar.getMaximumSize().width, 30));
        this.bar.setBackground(StaticResource.titleColor);
        this.createMenu(this.bar);
        Box menuBox = Box.createHorizontalBox();
        menuBox.add(Box.createHorizontalGlue());
        menuBox.add(this.bar);
        menuBox.add(Box.createHorizontalStrut(30));
        this.getTitlePanel().add(menuBox);
        this.createTabs();
        JPanel pClient = new JPanel(new BorderLayout());
        JPanel panCenter = new JPanel(new BorderLayout());
        panCenter.setBackground(Color.WHITE);
        BarPanel bp = new BarPanel();
        bp.setLayout(new BorderLayout());
        bp.add(Box.createRigidArea(new Dimension(0, 30)));
        bp.add(this.createSearchPane(), "East");
        panCenter.add((Component)bp, "North");
        pClient.add(panCenter);
        this.sp = new SidePanel();
        this.sp.setLayout(null);
        this.sp.setPreferredSize(new Dimension(150, 250));
        this.lblCatArr = new JLabel[6];
        JLabel lblAllCat = new JLabel(this.getString("TREE_ALL"));
        lblAllCat.setName("TREE_ALL");
        lblAllCat.setFont(StaticResource.plainFont);
        lblAllCat.setBorder(new EmptyBorder(5, 20, 5, 5));
        this.lblCatArr[0] = lblAllCat;
        JLabel lblDocCat = new JLabel(this.getString("TREE_DOCUMENTS"));
        lblDocCat.setName("TREE_DOCUMENTS");
        lblDocCat.setFont(StaticResource.plainFont);
        lblDocCat.setBorder(new EmptyBorder(5, 20, 5, 5));
        this.lblCatArr[1] = lblDocCat;
        JLabel lblArcCat = new JLabel(this.getString("TREE_COMPRESSED"));
        lblArcCat.setName("TREE_COMPRESSED");
        lblArcCat.setFont(StaticResource.plainFont);
        lblArcCat.setBorder(new EmptyBorder(5, 20, 5, 5));
        this.lblCatArr[2] = lblArcCat;
        JLabel lblMusCat = new JLabel(this.getString("TREE_MUSIC"));
        lblMusCat.setName("TREE_MUSIC");
        lblMusCat.setFont(StaticResource.plainFont);
        lblMusCat.setBorder(new EmptyBorder(5, 20, 5, 5));
        this.lblCatArr[3] = lblMusCat;
        JLabel lblVidCat = new JLabel(this.getString("TREE_VIDEOS"));
        lblVidCat.setName("TREE_VIDEOS");
        lblVidCat.setFont(StaticResource.plainFont);
        lblVidCat.setBorder(new EmptyBorder(5, 20, 5, 5));
        this.lblCatArr[4] = lblVidCat;
        JLabel lblAppCat = new JLabel(this.getString("TREE_PROGRAMS"));
        lblAppCat.setName("TREE_PROGRAMS");
        lblAppCat.setFont(StaticResource.plainFont);
        lblAppCat.setBorder(new EmptyBorder(5, 20, 5, 5));
        this.lblCatArr[5] = lblAppCat;
        this.lblCatArr[0].setBackground(new Color(242, 242, 242));
        this.lblCatArr[0].setOpaque(true);
        int i = 0;
        while (i < 6) {
            this.lblCatArr[i].setBounds(0, 20 + i * 35, 149, 27);
            final int c = i;
            this.lblCatArr[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    XDMMainWindow.this.actionPerformed(new ActionEvent(XDMMainWindow.this.lblCatArr[c], 0, ""));
                }
            });
            this.sp.add(this.lblCatArr[i]);
            ++i;
        }
        pClient.add((Component)this.sp, "West");
        this.add(pClient);
        Box bb = Box.createHorizontalBox();
        bb.add(Box.createRigidArea(new Dimension(20, 60)));
        bb.setBackground(StaticResource.titleColor);
        bb.setOpaque(true);
        XDMButton btnAdd = new XDMButton(StaticResource.getIcon("tool_add.png"));
        btnAdd.putClientProperty("xdmbutton.grayrollover", "true");
        btnAdd.setBorderPainted(false);
        btnAdd.addActionListener(this);
        btnAdd.setName("ADD_URL");
        btnAdd.setBackground(StaticResource.titleColor);
        btnAdd.setMargin(new Insets(0, 0, 0, 0));
        bb.add(btnAdd);
        bb.add(Box.createRigidArea(new Dimension(10, 10)));
        XDMButton btnDel = new XDMButton(StaticResource.getIcon("tool_del.png"));
        btnDel.putClientProperty("xdmbutton.grayrollover", "true");
        btnDel.setBorderPainted(false);
        btnDel.setBackground(StaticResource.titleColor);
        btnDel.setMargin(new Insets(0, 0, 0, 0));
        btnDel.addActionListener(this);
        btnDel.setName("DELETE");
        bb.add(btnDel);
        bb.add(Box.createRigidArea(new Dimension(10, 10)));
        XDMButton btnPause = new XDMButton(StaticResource.getIcon("tool_pause.png"));
        btnPause.putClientProperty("xdmbutton.grayrollover", "true");
        btnPause.setBorderPainted(false);
        btnPause.setBackground(StaticResource.titleColor);
        btnPause.setMargin(new Insets(0, 0, 0, 0));
        btnPause.addActionListener(this);
        btnPause.setName("PAUSE");
        bb.add(btnPause);
        bb.add(Box.createRigidArea(new Dimension(10, 10)));
        XDMButton btnResume = new XDMButton(StaticResource.getIcon("tool_resume1.png"));
        btnResume.putClientProperty("xdmbutton.grayrollover", "true");
        btnResume.setBorderPainted(false);
        btnResume.setBackground(StaticResource.titleColor);
        btnResume.setMargin(new Insets(0, 0, 0, 0));
        btnResume.addActionListener(this);
        btnResume.setName("RESUME");
        bb.add(btnResume);
        bb.add(Box.createRigidArea(new Dimension(10, 10)));
        XDMButton btnSettings = new XDMButton(StaticResource.getIcon("tool_settings2.png"));
        btnSettings.putClientProperty("xdmbutton.grayrollover", "true");
        btnSettings.setBorderPainted(false);
        btnSettings.setBackground(StaticResource.titleColor);
        btnSettings.setMargin(new Insets(0, 0, 0, 0));
        btnSettings.addActionListener(this);
        btnSettings.setName("OPTIONS");
        bb.add(btnSettings);
        bb.add(Box.createHorizontalGlue());
        this.btnTablet = new JLabel(StaticResource.getIcon("on.png"));
        this.btnTablet.setForeground(Color.WHITE);
        this.btnTablet.setIconTextGap(15);
        this.btnTablet.putClientProperty("xdmbutton.norollover", "true");
        this.btnTablet.setBackground(StaticResource.titleColor);
        this.btnTablet.setName("TABLET");
        this.btnTablet.setText("Tablet mode");
        this.btnTablet.setHorizontalTextPosition(10);
        bb.add(this.btnTablet);
        this.btnTablet.setIcon(XDMMainWindow.config.tabletMode ? StaticResource.getIcon("on.png") : StaticResource.getIcon("off.png"));
        this.btnTablet.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                XDMMainWindow.this.toggleTabletMode();
            }
        });
        this.btnTablet.setToolTipText("Load pages faster as tablet browser (Firefox and Chrome only)");
        bb.add(Box.createRigidArea(new Dimension(20, 10)));
        pClient.add((Component)bb, "South");
        list = new DownloadList(appdir);
        this.model = new MainTableModel();
        this.model.setList(list);
        this.table = new JTable(this.model);
        this.table.setTableHeader(null);
        this.table.setDefaultRenderer(DownloadListItem.class, new XDMListItemRenderer());
        this.table.setRowHeight(70);
        this.table.setShowGrid(false);
        this.table.setFillsViewportHeight(true);
        this.table.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.table.setTransferHandler(new FileTransferHandler(list, this));
        this.table.setDragEnabled(true);
        JScrollPane jsp = new JScrollPane(this.table);
        jsp.setBorder(new EmptyBorder(0, 0, 0, 0));
        panCenter.add(jsp);
        if (XDMMainWindow.config.destdir == null) {
            XDMMainWindow.config.destdir = destdir;
        }
        if (XDMMainWindow.config.tempdir == null) {
            XDMMainWindow.config.tempdir = tempdir;
        }
        this.createTray();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.getButton() == 3) {
                    if (XDMMainWindow.this.ctxPopup == null) {
                        XDMMainWindow.this.createContextMenu();
                    }
                    XDMMainWindow.this.ctxPopup.show(XDMMainWindow.this.table, me.getX(), me.getY());
                }
            }
        });
    }

    void toggleTabletMode() {
        XDMMainWindow.config.tabletMode = !XDMMainWindow.config.tabletMode;
        this.btnTablet.setIcon(XDMMainWindow.config.tabletMode ? StaticResource.getIcon("on.png") : StaticResource.getIcon("off.png"));
        config.save();
    }

    Component createSearchPane() {
        this.btnSort = new XDMButton("Newest on top");
        this.btnSort.setBorderPainted(false);
        this.btnSort.setFocusPainted(false);
        this.btnSort.setContentAreaFilled(false);
        this.txtSearch = new JTextField();
        this.txtSearch.setBorder(null);
        final JButton btnSearch = new JButton();
        btnSearch.setName("BTN_SEARCH");
        btnSearch.addActionListener(this);
        btnSearch.setPreferredSize(new Dimension(20, 20));
        btnSearch.setBackground(Color.WHITE);
        btnSearch.setIcon(StaticResource.getIcon("search16.png"));
        btnSearch.setBorderPainted(false);
        btnSearch.setContentAreaFilled(false);
        this.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    btnSearch.doClick();
                }
            }
        });
        Box b = Box.createHorizontalBox();
        b.setOpaque(true);
        b.setBackground(Color.WHITE);
        b.setPreferredSize(new Dimension(130, 20));
        b.setMaximumSize(new Dimension(130, 20));
        this.txtSearch.setPreferredSize(new Dimension(70, 20));
        this.txtSearch.setMaximumSize(new Dimension(this.txtSearch.getMaximumSize().width, 20));
        b.add(this.txtSearch);
        b.add(btnSearch);
        b.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        Box bp = Box.createHorizontalBox();
        bp.setOpaque(false);
        bp.setBorder(new EmptyBorder(3, 3, 3, 18));
        bp.add(Box.createHorizontalStrut(10));
        bp.add(this.btnSort);
        bp.add(Box.createHorizontalStrut(20));
        bp.add(b);
        this.sortItems = new JMenuItem[]{new JMenuItem("Date"), new JMenuItem("Size"), new JMenuItem("Name"), new JMenuItem("Type"), new JMenuItem("Ascending"), new JMenuItem("Descending")};
        final JPopupMenu popSort = new JPopupMenu();
        int i = 0;
        while (i < this.sortItems.length) {
            popSort.add(this.sortItems[i]);
            if (i >= 0 && i <= 3) {
                this.sortItems[i].setName("COL:" + i);
                if (i == XDMConfig.sortField) {
                    this.sortItems[i].setFont(StaticResource.boldFont);
                } else {
                    this.sortItems[i].setFont(StaticResource.plainFont);
                }
            }
            if (i == 3) {
                popSort.addSeparator();
            }
            if (i == 4) {
                this.sortItems[4].setName("CTX_ASC");
                this.sortItems[4].setFont(XDMConfig.sortAsc ? StaticResource.boldFont : StaticResource.plainFont);
            }
            if (i == 5) {
                this.sortItems[5].setName("CTX_DESC");
                this.sortItems[5].setFont(!XDMConfig.sortAsc ? StaticResource.boldFont : StaticResource.plainFont);
            }
            this.sortItems[i].addActionListener(this);
            ++i;
        }
        popSort.setInvoker(this.btnSort);
        this.btnSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popSort.show(XDMMainWindow.this.btnSort, 0, XDMMainWindow.this.btnSort.getHeight());
            }
        });
        return bp;
    }

    private void createTabs() {
        XDMButton btnAllTab = new XDMButton(this.getString("ALL_DOWNLOADS"));
        XDMButton btnIncompleteTab = new XDMButton(this.getString("ALL_UNFINISHED"));
        XDMButton btnCompletedTab = new XDMButton(this.getString("ALL_FINISHED"));
        this.btnTabArr = new JButton[3];
        this.btnTabArr[0] = btnAllTab;
        this.btnTabArr[0].setName("ALL_DOWNLOADS");
        this.btnTabArr[1] = btnIncompleteTab;
        this.btnTabArr[1].setName("ALL_UNFINISHED");
        this.btnTabArr[2] = btnCompletedTab;
        this.btnTabArr[2].setName("ALL_FINISHED");
        int i = 0;
        while (i < 3) {
            this.btnTabArr[i].setFont(StaticResource.plainFontBig);
            this.btnTabArr[i].setBorderPainted(false);
            this.btnTabArr[i].addActionListener(this);
            ++i;
        }
        btnAllTab.setBackground(new Color(242, 242, 242));
        btnIncompleteTab.setBackground(StaticResource.titleColor);
        btnIncompleteTab.setForeground(StaticResource.whiteColor);
        btnCompletedTab.setBackground(StaticResource.titleColor);
        btnCompletedTab.setForeground(StaticResource.whiteColor);
        JPanel pp = new JPanel(new BorderLayout());
        pp.setOpaque(false);
        JPanel p = new JPanel(new GridLayout(1, 3, 5, 0));
        p.setOpaque(false);
        Dimension d = new Dimension(350, 30);
        p.setPreferredSize(d);
        p.setMaximumSize(d);
        p.setMinimumSize(d);
        p.setBackground(Color.WHITE);
        p.add(btnAllTab);
        p.add(btnIncompleteTab);
        p.add(btnCompletedTab);
        pp.add((Component)p, "East");
        this.getTitlePanel().add((Component)pp, "South");
    }

    int getDupAction(String url) {
        JTextField txt = new JTextField(url, 30);
        String lbl = StringResource.getString("DUP_TXT");
        JComboBox<String> choice = new JComboBox<String>(new String[]{StringResource.getString("DUP_OP1"), StringResource.getString("DUP_OP2"), StringResource.getString("DUP_OP3")});
        JCheckBox chk = new JCheckBox(StringResource.getString("DUP_CHK"));
        int ret = JOptionPane.showOptionDialog(null, new Object[]{txt, lbl, choice, chk}, StringResource.getString("DUP_TITLE"), 2, 3, null, null, null);
        if (ret == 0) {
            int index = choice.getSelectedIndex();
            if (chk.isSelected()) {
                XDMMainWindow.config.duplicateLinkAction = index;
            }
            return index;
        }
        return -1;
    }

    void showMessageBox(String msg, String title, int msgType) {
        JOptionPane.showMessageDialog(this, msg, title, msgType);
    }

    void removeDownloads() {
        DownloadListItem item;
        int[] indexes = this.table.getSelectedRows();
        if (indexes.length < 1) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete selected download" + (indexes.length > 1 ? "s" : "") + "?", "Confirm delete", 0) != 0) {
            return;
        }
        DownloadListItem[] items = new DownloadListItem[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            item = list.get(indexes[i]);
            if (item.mgr != null) {
                this.showMessageBox(this.getString("DWN_ACTIVE"), this.getString("DEFAULT_TITLE"), 0);
                return;
            }
            items[i] = item;
            ++i;
        }
        i = 0;
        while (i < indexes.length) {
            item = items[i];
            String tmpdir = item.tempdir;
            list.remove(item);
            if (!XDMUtil.isNullOrEmpty(tmpdir)) {
                this.delDirRec(tmpdir);
            }
            ++i;
        }
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    void delDirRec(String dir) {
        File fdir = new File(dir);
        File[] files = fdir.listFiles();
        if (files == null) {
            fdir.delete();
        } else {
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
            fdir.delete();
        }
    }

    private void resumeDownload() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        DownloadListItem item = list.get(index);
        if (item == null) {
            return;
        }
        this.resumeDownload(item);
    }

    void resumeDownload(DownloadListItem item) {
        if (item.mgr != null) {
            this.showMessageBox(this.getString("DWN_ACTIVE"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        if (item.state == 50) {
            this.showMessageBox(this.getString("DWN_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        if (item.tempdir == null || item.tempdir.length() < 1) {
            this.startDownload(item.url, item.filename, item.saveto, null, null, item.userAgent, item.referer, item.cookies, item, true);
        } else {
            XDMDownloadWindow dw;
            ConnectionManager mgr = new ConnectionManager(item.id, item.url, item.filename, item.saveto, item.tempdir, item.userAgent, item.referer, item.cookies, config);
            if (!XDMUtil.isNullOrEmpty(item.user) && !XDMUtil.isNullOrEmpty(item.pass)) {
                mgr.setCredential(item.user, item.pass);
            }
            item.mgr = mgr;
            this.model.fireTableDataChanged();
            list.downloadStateChanged();
            item.window = dw = new XDMDownloadWindow(mgr);
            if (XDMMainWindow.config.showDownloadPrgDlg && this.qi != item) {
                dw.showWindow();
            }
            mgr.setProgressListener(dw);
            mgr.dwnListener = this;
            try {
                mgr.resume();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void restartDownload() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        DownloadListItem item = list.get(index);
        if (item == null) {
            return;
        }
        this.restartDownload(item);
    }

    void restartDownload(DownloadListItem item) {
        if (item.mgr != null) {
            this.showMessageBox(this.getString("DWN_ACTIVE"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        this.startDownload(item.url, item.filename, item.saveto, null, null, item.userAgent, item.referer, item.cookies, item, true);
    }

    private void pauseDownload() {
        int[] indexes = this.table.getSelectedRows();
        int i = 0;
        while (i < indexes.length) {
            DownloadListItem item = list.get(indexes[i]);
            if (item.mgr != null) {
                item.mgr.stop();
            }
            ++i;
        }
    }

    void addDownload() {
        NewDownloadWindow fdlg = new NewDownloadWindow(this, config);
        fdlg.setDir(XDMMainWindow.config.destdir);
        fdlg.showDlg();
    }

    synchronized void startDownload(String url, String name, String folder, String user, String pass, String userAgent, String referer, ArrayList<String> cookies, DownloadListItem item, boolean overriteExisting) {
        XDMDownloadWindow dw;
        UUID id = UUID.randomUUID();
        ConnectionManager mgr = new ConnectionManager(id, url, name, folder, XDMMainWindow.config.tempdir, userAgent, referer, cookies, config);
        mgr.overwrite = overriteExisting;
        if (item == null) {
            item = new DownloadListItem();
            list.add(item);
        }
        if (!XDMUtil.isNullOrEmpty(user) && !XDMUtil.isNullOrEmpty(pass)) {
            mgr.setCredential(user, pass);
            item.user = user;
            item.pass = pass;
        }
        item.mgr = mgr;
        item.isDASH = false;
        item.filename = name;
        item.url = url;
        item.q = false;
        item.dateadded = item.lasttry = new SimpleDateFormat("MMM dd").format(new Date());
        item.id = id;
        item.saveto = folder;
        item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
        item.userAgent = userAgent;
        item.referer = referer;
        if (cookies != null) {
            item.cookies = new ArrayList();
            item.cookies.addAll(cookies);
        }
        item.state = 10;
        item.type = XDMUtil.findCategory(name);
        list.sort();
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
        item.window = dw = new XDMDownloadWindow(mgr);
        if (XDMMainWindow.config.showDownloadPrgDlg && this.qi != item) {
            dw.showWindow();
        }
        mgr.setProgressListener(dw);
        mgr.dwnListener = this;
        try {
            mgr.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void add2Queue(String url, String name, String folder, String user, String pass, String referer, ArrayList<String> cookies, String userAgent, boolean q) {
        UUID id = UUID.randomUUID();
        DownloadListItem item = new DownloadListItem();
        item.isDASH = false;
        list.add(item);
        item.user = user;
        item.pass = pass;
        item.filename = name;
        item.url = url;
        item.q = q;
        item.dateadded = item.lasttry = new SimpleDateFormat("MMM dd").format(new Date());
        item.id = id;
        item.saveto = folder;
        item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
        item.userAgent = userAgent;
        item.referer = referer;
        if (cookies != null) {
            item.cookies.addAll(cookies);
        }
        item.state = 40;
        item.status = "Stopped";
        item.type = XDMUtil.findCategory(name);
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    @Override
    public void configChanged() {
        if (XDMMainWindow.config.schedule) {
            if (this.schedulerActive) {
                Logger.log("Scheduler is active");
                return;
            }
            this.st = new Thread(new Runnable(){

                @Override
                public void run() {
                    XDMMainWindow.this.schedulerRun();
                }
            });
            this.st.start();
        }
    }

    @Override
    public void downloadComplete(UUID id) {
        DownloadListItem item = list.getByID(id);
        if (item == null) {
            return;
        }
        item.window = null;
        item.status = "Download Complete " + item.size;
        item.timeleft = "";
        item.state = 50;
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
        if (this.qi == item) {
            this.qi = null;
            if (this.processQueue && this.processNextQueuedDownload()) {
                return;
            }
        }
        if (XDMMainWindow.config.halt) {
            this.executeCommands();
        } else if (XDMMainWindow.config.showDownloadCompleteDlg) {
            DownloadCompleteDialog cdlg = new DownloadCompleteDialog(config);
            cdlg.setData(item.filename, item.saveto);
            cdlg.setLocationRelativeTo(null);
            cdlg.setVisible(true);
        }
    }

    @Override
    public void downloadConfirmed(UUID id, Object data) {
        DownloadListItem item = list.getByID(id);
        ConnectionManager mgr = item.mgr;
        item.tempdir = mgr.getTempdir();
        item.url = mgr.getUrl();
        item.filename = mgr.getFileName();
        item.icon = IconUtil.getIcon(XDMUtil.findCategory(item.filename));
        item.updateData((DownloadInfo)data);
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    @Override
    public void downloadFailed(UUID id) {
        System.out.println("Download failed");
        list.downloadStateChanged();
        DownloadListItem item = list.getByID(id);
        if (item == null) {
            return;
        }
        item.window = null;
        if (this.qi == item) {
            this.qi = null;
            if (this.processQueue) {
                this.processNextQueuedDownload();
            } else {
                System.out.println("Queue stopped");
            }
        } else {
            System.out.println("Not queued");
        }
    }

    @Override
    public void downloadNow(String url, String name, String folder, String user, String pass, String referer, ArrayList<String> cookies, String userAgent) {
        boolean overwrite = false;
        int i = 0;
        while (i < XDMMainWindow.list.list.size()) {
            DownloadListItem item = XDMMainWindow.list.list.get(i);
            if (url.equals(item.url)) {
                int action = XDMMainWindow.config.duplicateLinkAction;
                if (action == 3) {
                    action = this.getDupAction(url);
                }
                if (action == -1) {
                    return;
                }
                if (action == 2) {
                    if (item.state == 50) {
                        File file = new File(item.saveto, item.filename);
                        if (file.exists()) {
                            XDMUtil.open(file.getParentFile());
                        } else if (item.mgr == null) {
                            this.restartDownload(item);
                        } else {
                            this.showMessageBox(this.getString("DWN_ACTIVE"), "Message", 0);
                        }
                    } else if (item.mgr == null) {
                        this.resumeDownload(item);
                    } else {
                        this.showMessageBox(this.getString("DWN_ACTIVE"), "Message", 0);
                    }
                    return;
                }
                overwrite = action == 1;
                break;
            }
            ++i;
        }
        this.startDownload(url, name, folder, user, pass, userAgent, referer, cookies, null, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadPaused(UUID id) {
        XDMMainWindow xDMMainWindow = this;
        synchronized (xDMMainWindow) {
            DownloadListItem item = list.getByID(id);
            if (item == null) {
                return;
            }
            item.window = null;
            item.mgr = null;
            item.status = "Stopped " + item.sprg + "% of " + item.size;
            item.state = 40;
            int index = list.getIndex(item);
            if (index < 0) {
                return;
            }
            this.model.fireTableRowsUpdated(index, index);
            list.downloadStateChanged();
            if (this.qi == item) {
                this.qi = null;
                if (this.processQueue) {
                    if (JOptionPane.showConfirmDialog(this, this.getString("CONTINUE_Q"), this.getString("DEFAULT_TITLE"), 0, 3) == 0) {
                        this.processNextQueuedDownload();
                    } else {
                        this.processQueue = false;
                        this.qi = null;
                    }
                } else {
                    this.qi = null;
                }
            }
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void getCredentials(ConnectionManager mgr, String host) {
    }

    @Override
    public void interceptDownload(DownloadIntercepterInfo info) {
        this.addDownload(info.url, XDMUtil.getFileName(info.url), XDMMainWindow.config.destdir, null, null, info.referer, info.cookies, info.ua);
    }

    @Override
    public void restoreWindow() {
        this.setVisible(true);
    }

    @Override
    public void startQueue() {
        if (this.processQueue) {
            this.showMessageBox(this.getString("Q_STARTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        if (this.qi != null) {
            return;
        }
        this.processQueue = true;
        this.processNextQueuedDownload();
    }

    @Override
    public void stopQueue() {
        this.processQueue = false;
        if (this.qi == null) {
            return;
        }
        if (this.qi.mgr != null) {
            this.qi.mgr.stop();
            this.qi = null;
        } else {
            this.qi = null;
        }
    }

    @Override
    public void updateManager(UUID id, Object data) {
        DownloadListItem item = list.getByID(id);
        if (item == null) {
            return;
        }
        DownloadInfo info = (DownloadInfo)data;
        item.updateData(info);
        int index = list.getIndex(item);
        if (index >= 0) {
            this.model.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public void ytCallback(String yturl) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        String status = null;
        int state = 0;
        Object[] o = e.getPath().getPath();
        int i = 0;
        while (i < o.length) {
            XDMTreeNode node = (XDMTreeNode)o[i];
            if (node.id.equals("TREE_UNFINISHED")) {
                state = 1;
            }
            if (node.id.equals("TREE_FINISHED")) {
                state = 50;
            }
            if (node.id.equals("TREE_DOCUMENTS")) {
                status = "Documents";
            }
            if (node.id.equals("TREE_COMPRESSED")) {
                status = "Compressed";
            }
            if (node.id.equals("TREE_MUSIC")) {
                status = "Music";
            }
            if (node.id.equals("TREE_PROGRAMS")) {
                status = "Programs";
            }
            if (node.id.equals("TREE_VIDEOS")) {
                status = "Video";
            }
            list.setState(state);
            list.setType(status);
            this.model.fireTableDataChanged();
            ++i;
        }
    }

    JMenu createMenu(String title) {
        JMenu menu = new JMenu(title);
        menu.setForeground(StaticResource.whiteColor);
        menu.setFont(new Font("Dialog", 0, 12));
        menu.setBorderPainted(false);
        return menu;
    }

    void createMenu(JMenuBar bar) {
        JMenuItem item;
        JMenu file = this.createMenu(this.getString("FILE"));
        this.addMenuItem("ADD_URL", file);
        this.addMenuItem("BATCH_DOWNLOAD", file);
        this.addMenuItem("YOUTUBE_DOWNLOADER", file);
        this.addMenuItem("ADV_YT", file);
        this.addMenuItem("CLIP_ADD", file);
        this.addMenuItem("DELETE_DWN", file);
        this.addMenuItem("DELETE_COMPLETED", file);
        this.addMenuItem("MAKE_SHORTCUT", file);
        if (System.getProperty("os.name").contains("OS X")) {
            item = new JMenuItem("Install as Application");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OSXInstallWindow osx = new OSXInstallWindow();
                    osx.setLocationRelativeTo(null);
                    osx.setModal(true);
                    osx.setVisible(true);
                }
            });
            file.add(item);
        }
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            item = new JMenuItem("Add to Desktop Menu");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = new File(System.getProperty("user.home"), ".local/share/applications");
                    f.mkdirs();
                    LinuxUtil.createDesktopFile(f.getAbsolutePath(), false);
                    JOptionPane.showMessageDialog(null, "Please log off to view the changes");
                }
            });
            file.add(item);
        }
        this.addMenuItem("EXIT", file);
        JMenu dwn = this.createMenu(this.getString("DOWNLOAD"));
        this.addMenuItem("PAUSE", dwn);
        this.addMenuItem("RESUME", dwn);
        this.addMenuItem("RESTART", dwn);
        this.addMenuItem("START_Q", dwn);
        this.addMenuItem("STOP_Q", dwn);
        JMenu tools = this.createMenu(this.getString("TOOLS"));
        this.addMenuItem("OPTIONS", tools);
        this.addMenuItem("REFRESH_LINK", tools);
        this.addMenuItem("BROWSER_INT", tools);
        this.addMenuItem("CTX_ASM", tools);
        this.addMenuItem("THROTTLE_DLG", tools);
        JMenu view = this.createMenu(this.getString("VIEW"));
        this.addMenuItem("CTX_OPEN", view);
        this.addMenuItem("CTX_OPEN_FOLDER", view);
        this.addMenuItem("CTX_SAVE_AS", view);
        this.addMenuItem("CTX_COPY_URL", view);
        this.addMenuItem("CTX_COPY_FILE", view);
        JMenu help = this.createMenu(this.getString("HELP"));
        this.addMenuItem("CONTENT", help);
        this.addMenuItem("HOME_PAGE", help);
        this.addMenuItem("UPDATE", help);
        this.addMenuItem("ABOUT", help);
        bar.add(file);
        bar.add(dwn);
        bar.add(view);
        bar.add(tools);
        bar.add(help);
    }

    void addMenuItem(String id, JComponent menu) {
        JMenuItem mitem = new JMenuItem(this.getString(id));
        mitem.setName(id);
        mitem.addActionListener(this);
        menu.add(mitem);
    }

    String getString(String id) {
        String str = StringResource.getString(id);
        return str == null ? "" : str;
    }

    static ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(XDMMainWindow.class.getResource("/res/" + name));
        }
        catch (Exception e) {
            return new ImageIcon("res/" + name);
        }
    }

    void tabClicked(ActionEvent e) {
        int i = 0;
        while (i < 3) {
            if (this.btnTabArr[i] == e.getSource()) {
                this.btnTabArr[i].setBackground(new Color(242, 242, 242));
                this.btnTabArr[i].setForeground(Color.BLACK);
            } else {
                this.btnTabArr[i].setBackground(StaticResource.titleColor);
                this.btnTabArr[i].setForeground(StaticResource.whiteColor);
            }
            ++i;
        }
    }

    void updateSortText() {
        String text = "";
        switch (XDMConfig.sortField) {
            case 0: {
                text = XDMConfig.sortAsc ? "Oldest on top" : "Newest on top";
                break;
            }
            case 1: {
                text = XDMConfig.sortAsc ? "Smallest on top" : "Largest on top";
                break;
            }
            case 2: {
                text = XDMConfig.sortAsc ? "Name [A-Z]" : "Name [Z-A]";
                break;
            }
            case 3: {
                text = XDMConfig.sortAsc ? "Type [A-Z]" : "Type [Z-A]";
            }
        }
        this.btnSort.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JLabel) {
            String status = null;
            JLabel lbl = (JLabel)e.getSource();
            if (lbl.getName().equals("TREE_DOCUMENTS")) {
                status = "Documents";
            }
            if (lbl.getName().equals("TREE_COMPRESSED")) {
                status = "Compressed";
            }
            if (lbl.getName().equals("TREE_MUSIC")) {
                status = "Music";
            }
            if (lbl.getName().equals("TREE_PROGRAMS")) {
                status = "Programs";
            }
            if (lbl.getName().equals("TREE_VIDEOS")) {
                status = "Video";
            }
            int i = 0;
            while (i < this.lblCatArr.length) {
                if (lbl == this.lblCatArr[i]) {
                    this.lblCatArr[i].setBackground(new Color(242, 242, 242));
                    this.lblCatArr[i].setOpaque(true);
                } else {
                    this.lblCatArr[i].setOpaque(false);
                }
                ++i;
            }
            this.sp.repaint();
            list.setType(status);
            this.model.fireTableDataChanged();
            return;
        }
        if (e.getSource() instanceof AbstractButton) {
            String name = ((AbstractButton)e.getSource()).getName();
            if (name == null) {
                return;
            }
            if ("ADD_URL".equals(name)) {
                this.addDownload();
            } else if ("ADV_YT".equals(name)) {
                AdvYTDlg aytd = new AdvYTDlg(config);
                aytd.setLocationRelativeTo(null);
                aytd.setVisible(true);
            } else if ("THROTTLE_DLG".equals(name)) {
                XDMThrottleDlg tdlg = new XDMThrottleDlg(config);
                tdlg.setLocationRelativeTo(null);
                tdlg.setVisible(true);
            } else if ("ALL_DOWNLOADS".equals(name)) {
                this.tabClicked(e);
                int state = 0;
                list.setState(state);
                this.model.fireTableDataChanged();
            } else if ("ALL_UNFINISHED".equals(name)) {
                this.tabClicked(e);
                int state = 1;
                list.setState(state);
                this.model.fireTableDataChanged();
            } else if ("ALL_FINISHED".equals(name)) {
                this.tabClicked(e);
                int state = 50;
                list.setState(state);
                this.model.fireTableDataChanged();
            } else if ("PAUSE".equals(name)) {
                this.pauseDownload();
            } else if ("RESUME".equals(name)) {
                this.resumeDownload();
            } else if ("DELETE".equals(name) || "DELETE_DWN".equals(name)) {
                this.removeDownloads();
            } else if ("RESTART".equals(name)) {
                this.restartDownload();
            } else if ("OPTIONS".equals(name)) {
                if (this.configDlg == null) {
                    this.configDlg = new ConfigDialog((Frame)this, config, this);
                }
                this.configDlg.showDialog();
            } else if ("EXIT".equals(name)) {
                this.exitXDM();
            } else if ("BATCH_DOWNLOAD".equals(name)) {
                if (this.batchDlg == null) {
                    this.batchDlg = new BatchDlg(this);
                }
                this.batchDlg.setLocationRelativeTo(this);
                this.batchDlg.setVisible(true);
            } else if ("CLIP_ADD".equals(name)) {
                if (this.listDlg == null) {
                    this.listDlg = new BatchDownloadDlg();
                }
                this.listDlg.setLocationRelativeTo(this);
                this.listDlg.showDialog(XDMMainWindow.config.destdir, this);
            } else if ("MEDIA_GRABBER".equals(name) || "GRABBER".equals(name)) {
                this.showGrabber();
            } else if ("YOUTUBE_DOWNLOADER".equals(name) || "YOUTUBE".equals(name)) {
                if (this.ytDlg == null) {
                    this.ytDlg = new YoutubeGrabberDlg(this);
                }
                this.ytDlg.showDialog(this, config, "");
            } else if ("DELETE_COMPLETED".equals(name)) {
                this.deleteFinished();
            } else if ("REFRESH_LINK".equals(name)) {
                this.refreshLink();
            } else if ("CTX_OPEN".equals(name)) {
                this.openFile();
            } else if ("CTX_OPEN_FOLDER".equals(name)) {
                this.openFolder();
            } else if ("CTX_SAVE_AS".equals(name)) {
                this.renameFile();
            } else if ("BROWSER_INT".equals(name)) {
                this.showBrowserIntegrationDlg();
            } else if ("RESTORE".equals(name)) {
                this.restoreWindow();
            } else if ("ABOUT".equals(name)) {
                this.abtDlg = new AboutDialog();
                this.abtDlg.setLocationRelativeTo(null);
                this.abtDlg.setVisible(true);
            } else if ("PROPERTIES".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                PropertiesDialog.showDetails(item);
            } else if ("HOME_PAGE".equals(name)) {
                XDMUtil.browse("http://www.sourceforge.net/projects/xdman");
            } else if ("UPDATE".equals(name)) {
                XDMUtil.browse("http://xdman.sourceforge.net/update/update.php?v=5047");
            } else if ("CONTENT".equals(name)) {
                try {
                    HelpDialog hlp = HelpDialog.getHelpDialog();
                    hlp.setDocument("BROWSER_INTEGRATION");
                    hlp.setLocationRelativeTo(null);
                    hlp.setVisible(true);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            } else if ("CTX_ASC".equals(name)) {
                XDMConfig.sortAsc = true;
                this.sortItems[4].setFont(StaticResource.boldFont);
                this.sortItems[5].setFont(StaticResource.plainFont);
                this.sort();
            } else if ("CTX_DESC".equals(name)) {
                this.sortItems[5].setFont(StaticResource.boldFont);
                this.sortItems[4].setFont(StaticResource.plainFont);
                XDMConfig.sortAsc = false;
                this.sort();
            } else if (name.startsWith("COL:")) {
                int i = 0;
                while (i < 4) {
                    if (e.getSource() == this.sortItems[i]) {
                        this.sortItems[i].setFont(StaticResource.boldFont);
                    } else {
                        this.sortItems[i].setFont(StaticResource.plainFont);
                    }
                    ++i;
                }
                String num = name.split(":")[1];
                XDMConfig.sortField = Integer.parseInt(num);
                this.sort();
            } else if ("BTN_SEARCH".equals(name)) {
                this.sort();
            } else if ("START_Q".equals(name)) {
                this.startQueue();
            } else if ("STOP_Q".equals(name)) {
                this.stopQueue();
            } else if ("CTX_ADD_Q".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                this.add2Q(item, true);
            } else if ("CTX_DEL_Q".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                this.add2Q(item, false);
            } else if ("CTX_SHOW_PRG".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                if (item.window != null) {
                    item.window.setVisible(true);
                }
            } else if ("MAKE_SHORTCUT".equals(name)) {
                JFileChooser jfc = XDMFileChooser.getFileChooser(1, new File(System.getProperty("user.home")));
                if (jfc.showOpenDialog(this) == 0) {
                    this.createShortcut(jfc.getSelectedFile());
                }
            } else if ("CTX_ASM".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                if (item.mgr != null || item.state == 50) {
                    this.showMessageBox(this.getString("DWN_ACTIVE_OR_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, this.getString("ASM_WRN"), this.getString("DEFAULT_TITLE"), 0, 3) == 0) {
                    if (this.asmDlg == null) {
                        this.asmDlg = new AssembleDialog(this);
                    }
                    this.asmDlg.startAssemble(item.filename, item.saveto, item.tempdir);
                }
            } else if ("CTX_COPY_FILE".equals(name)) {
                int[] index = this.table.getSelectedRows();
                if (index == null || index.length < 1) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem[] items = new DownloadListItem[index.length];
                int i = 0;
                while (i < index.length) {
                    items[i] = list.get(index[i]);
                    ++i;
                }
                try {
                    this.copyFiles(items);
                }
                catch (Exception exx) {
                    exx.printStackTrace();
                }
            } else if ("CTX_COPY_URL".equals(name)) {
                int index = this.table.getSelectedRow();
                if (index < 0) {
                    this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
                    return;
                }
                DownloadListItem item = list.get(index);
                if (item == null) {
                    return;
                }
                this.copyURL(item.url);
            }
        }
    }

    public void renameFile(DownloadListItem item, int row) {
        if (item.state == 50) {
            this.showMessageBox(this.getString("DWN_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
        } else {
            JFileChooser jfc = XDMFileChooser.getFileChooser(0, new File(item.saveto, item.filename));
            if (jfc.showSaveDialog(this) != 0) {
                return;
            }
            String file = jfc.getSelectedFile().getName();
            String folder = jfc.getSelectedFile().getParent();
            if (item.mgr != null) {
                if (item.mgr.state == 60) {
                    this.showMessageBox(this.getString("DWN_ASSEMBLING"), this.getString("DEFAULT_TITLE"), 0);
                } else {
                    item.mgr.setDestdir(folder);
                    item.mgr.setFileName(file);
                }
            }
            item.filename = file;
            item.saveto = folder;
            list.downloadStateChanged();
            this.model.fireTableDataChanged();
        }
    }

    private void renameFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DownloadListItem item = list.get(row);
        if (item == null) {
            return;
        }
        this.renameFile(item, row);
    }

    private void openFolder() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DownloadListItem item = list.get(row);
        if (item == null) {
            return;
        }
        File folder = new File(item.saveto);
        if (!folder.exists()) {
            this.showMessageBox(this.getString("FOLDER_NOT_FOUND"), this.getString("DEFAULT_TITLE"), 0);
        } else {
            XDMUtil.open(folder);
        }
    }

    private void openFile() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        DownloadListItem item = list.get(row);
        if (item == null) {
            return;
        }
        if (item.state == 50) {
            File file = new File(item.saveto, item.filename);
            if (file.exists()) {
                XDMUtil.open(file);
            } else {
                this.showMessageBox(this.getString("FILE_NOT_FOUND"), this.getString("DEFAULT_TITLE"), 0);
            }
        } else {
            this.showMessageBox(this.getString("DWN_INCOMPLETE"), this.getString("DEFAULT_TITLE"), 0);
        }
    }

    void createContextMenu() {
        this.ctxPopup = new JPopupMenu();
        this.addMenuItem("CTX_OPEN", this.ctxPopup);
        this.addMenuItem("CTX_OPEN_FOLDER", this.ctxPopup);
        this.addMenuItem("CTX_SAVE_AS", this.ctxPopup);
        this.addMenuItem("CTX_SHOW_PRG", this.ctxPopup);
        this.addMenuItem("PAUSE", this.ctxPopup);
        this.addMenuItem("RESUME", this.ctxPopup);
        this.addMenuItem("RESTART", this.ctxPopup);
        this.addMenuItem("DELETE", this.ctxPopup);
        this.addMenuItem("REFRESH_LINK", this.ctxPopup);
        this.addMenuItem("CTX_ASM", this.ctxPopup);
        this.addMenuItem("CTX_ADD_Q", this.ctxPopup);
        this.addMenuItem("CTX_DEL_Q", this.ctxPopup);
        this.addMenuItem("CTX_COPY_URL", this.ctxPopup);
        this.addMenuItem("CTX_COPY_FILE", this.ctxPopup);
        this.addMenuItem("PROPERTIES", this.ctxPopup);
        this.ctxPopup.setInvoker(this.table);
    }

    private void refreshLink() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            this.showMessageBox(this.getString("NONE_SELECTED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        DownloadListItem item = list.get(index);
        if (item != null) {
            if (item.state != 50 && item.mgr == null) {
                String url = XDMUtil.isNullOrEmpty(item.referer) ? item.url : item.referer;
                if ((url = RefreshLinkDlg.showDialog(this, url)) != null) {
                    item.url = url;
                    this.model.fireTableRowsUpdated(index, index);
                    list.downloadStateChanged();
                }
            } else {
                this.showMessageBox(this.getString("DWN_ACTIVE_OR_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
            }
        }
    }

    private void exitXDM() {
        XDMMainWindow.config.mwX = this.getX();
        XDMMainWindow.config.mwY = this.getY();
        XDMMainWindow.config.mwW = this.getWidth();
        XDMMainWindow.config.mwH = this.getHeight();
        if (this.w != null) {
            if (!this.w.isVideoMode) {
                XDMMainWindow.config.dbX = this.w.getX();
            } else {
                int x = this.w.getLocationOnScreen().x + 200 - 22;
                if (x > 0) {
                    x = Math.min(x, Toolkit.getDefaultToolkit().getScreenSize().width - 30);
                }
                XDMMainWindow.config.dbX = x;
            }
            XDMMainWindow.config.dbY = this.w.getY();
        }
        list.downloadStateChanged();
        config.save();
        Authenticator.getInstance().save();
        System.exit(0);
    }

    @Override
    public void initBatchDownload(List<String> list, String user, String pass) {
        if (list == null || list.size() < 1) {
            return;
        }
        if (this.listDlg == null) {
            this.listDlg = new BatchDownloadDlg();
        }
        this.listDlg.setLocationRelativeTo(null);
        ArrayList<BatchItem> blist = new ArrayList<BatchItem>();
        int i = 0;
        while (i < list.size()) {
            BatchItem item = new BatchItem();
            item.url = list.get(i);
            item.fileName = XDMUtil.getFileName(item.url);
            item.user = user;
            item.pass = pass;
            item.dir = XDMMainWindow.config.destdir;
            blist.add(item);
            ++i;
        }
        this.listDlg.showDialog(blist, XDMMainWindow.config.destdir, this);
    }

    @Override
    public void mediaCaptured(String name, String url, String type, String size, String referer, String ua, ArrayList<String> cookies) {
        String filename = XDMUtil.isNullOrEmpty(name) ? XDMUtil.getFileName(url) : name;
        MediaInfo info = new MediaInfo();
        info.name = filename;
        info.url = url;
        info.referer = referer;
        info.userAgent = ua;
        info.type = type;
        info.size = size;
        info.cookies = cookies;
        this.mediaModel.add(info);
        this.showNotification();
    }

    @Override
    public void showGrabber() {
    }

    @Override
    public void showNotification() {
        this.w.setVideoPopup(true);
    }

    @Override
    public void showNotificationText(String text, String title) {
        this.showNotification();
    }

    @Override
    public void addDownload(String url, String name, String folder, String user, String pass, String referer, ArrayList<String> cookies, String userAgent) {
        NewDownloadWindow fdlg = new NewDownloadWindow(this, config);
        fdlg.setURL(url);
        fdlg.file.setText(name);
        fdlg.setDir(XDMMainWindow.config.destdir);
        fdlg.referer = referer;
        fdlg.cookies = cookies;
        fdlg.userAgent = userAgent;
        fdlg.showDlg();
    }

    void deleteFinished() {
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete all completed downloads", "Confirm delete", 0) != 0) {
            return;
        }
        ArrayList<DownloadListItem> lists = new ArrayList<DownloadListItem>();
        int i = 0;
        while (i < XDMMainWindow.list.list.size()) {
            DownloadListItem item = XDMMainWindow.list.list.get(i);
            if (item.state == 50) {
                lists.add(item);
            }
            ++i;
        }
        i = 0;
        while (i < lists.size()) {
            XDMMainWindow.list.list.remove(lists.get(i));
            ++i;
        }
        this.model.fireTableDataChanged();
        list.downloadStateChanged();
    }

    void createTray() {
        JMenuItem newDownload = new JMenuItem(StringResource.getString("ADD_URL"));
        newDownload.setName("ADD_URL");
        newDownload.addActionListener(this);
        JMenuItem aboutXDM = new JMenuItem(StringResource.getString("ABOUT"));
        aboutXDM.setName("ABOUT");
        aboutXDM.addActionListener(this);
        JMenuItem restore = new JMenuItem(StringResource.getString("RESTORE"));
        restore.setName("RESTORE");
        restore.addActionListener(this);
        JMenuItem exit2 = new JMenuItem(StringResource.getString("EXIT"));
        exit2.setName("EXIT");
        exit2.addActionListener(this);
        final JPopupMenu trayPop = new JPopupMenu();
        trayPop.add(newDownload);
        trayPop.add(aboutXDM);
        trayPop.add(restore);
        trayPop.add(exit2);
        this.lbl = new JLabel();
        this.lbl.setToolTipText("Xtreme Download Manager");
        this.lbl.setOpaque(true);
        this.lbl.setIcon(XDMMainWindow.getIcon("xdm22.png"));
        this.lbl.setHorizontalAlignment(0);
        this.lbl.setVerticalAlignment(0);
        trayPop.setInvoker(this.lbl);
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    XDMMainWindow.this.restoreWindow();
                }
                if (e.getButton() == 3) {
                    trayPop.show(XDMMainWindow.this.lbl, e.getX(), e.getY());
                }
            }
        };
        this.lbl.addMouseListener(m);
        this.w = new DropBox(this.lbl, this, this.mediaModel, this, config);
        Dimension scrRect = Toolkit.getDefaultToolkit().getScreenSize();
        if (XDMMainWindow.config.dbX <= 0) {
            this.w.setLocation(scrRect.width - 30, scrRect.height - 200);
        } else {
            int x = Math.min(scrRect.width - 30, XDMMainWindow.config.dbX);
            this.w.setLocation(x, XDMMainWindow.config.dbY);
        }
        this.w.setVisible(true);
    }

    HelpDialog getHTMLViwer() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("Browser Integration", this.getClass().getResource("/help/browser_integration.html"));
        map.put("Capturing Videos", this.getClass().getResource("/help/video_download.html"));
        map.put("Refresh Broken Downloads", this.getClass().getResource("/help/refresh_link.html"));
        HelpDialog hlp = new HelpDialog();
        hlp.addPages(map);
        return hlp;
    }

    static void parseArgs(String[] a) {
        String key = "url";
        boolean min = false;
        int i = 0;
        while (i < a.length) {
            if (a[i].equals("-c")) {
                key = "cookie";
            } else if (a[i].equals("-r")) {
                key = "referer";
            } else if (a[i].equals("-m")) {
                min = true;
            } else if (a[i].equals("-u")) {
                key = "url";
            } else {
                arg.put(key, a[i]);
            }
            ++i;
        }
        if (min) {
            arg.put("min", "true");
        }
    }

    void showBrowserIntegrationDlg() {
        if (this.biDlg == null) {
            this.biDlg = new BrowserIntDlg(this, config);
        }
        this.biDlg.setLocationRelativeTo(this);
        this.biDlg.setVisible(true);
    }

    void sort() {
        XDMMainWindow.list.searchStr = this.txtSearch.getText();
        this.updateSortText();
        list.sort();
        list.downloadStateChanged();
        this.model.fireTableDataChanged();
    }

    boolean processNextQueuedDownload() {
        System.out.println("ProcessNextQueue");
        if (!this.processQueue) {
            return false;
        }
        if (this.qi != null) {
            return false;
        }
        int i = 0;
        while (i < XDMMainWindow.list.list.size()) {
            DownloadListItem di = XDMMainWindow.list.list.get(i);
            if (di.mgr == null && di.state != 50 && di.q) {
                this.qi = di;
                this.resumeDownload(di);
                return true;
            }
            ++i;
        }
        this.qi = null;
        this.processQueue = false;
        XDMMainWindow.config.schedule = false;
        this.schedulerActive = false;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void schedulerRun() {
        this.schedulerActive = true;
        Logger.log("SchedulerRun");
        try {
            block17: {
                block16: {
                    if (System.currentTimeMillis() > XDMMainWindow.config.endDate.getTime()) {
                        Logger.log("Scheduler outdated");
                        return;
                    }
                    Logger.log("Starting scheduler");
                    while (true) {
                        if (!XDMMainWindow.config.schedule) {
                            Logger.log("Scheduler killed");
                            return;
                        }
                        if (System.currentTimeMillis() > XDMMainWindow.config.startDate.getTime()) {
                            if (!this.processQueue) {
                                break;
                            }
                            break block16;
                        }
                        Thread.sleep(1000L);
                    }
                    Logger.log("Starting queue scheduler");
                    this.processQueue = true;
                    this.processNextQueuedDownload();
                    break block17;
                }
                Logger.log("Queue already started");
            }
            while (true) {
                if (!this.processQueue) {
                    return;
                }
                if (!XDMMainWindow.config.schedule) {
                    Logger.log("Scheduler killed");
                    if (!this.processQueue) return;
                    this.stopQueue();
                    this.processQueue = false;
                    return;
                }
                if (System.currentTimeMillis() > XDMMainWindow.config.endDate.getTime()) {
                    if (this.processQueue) {
                        this.stopQueue();
                        this.processQueue = false;
                    }
                    Logger.log("Time ended processQ: " + this.processQueue);
                    XDMMainWindow.config.schedule = false;
                    return;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception ex) {
            Logger.log(ex);
            return;
        }
        finally {
            this.schedulerActive = false;
        }
    }

    void add2Q(DownloadListItem item, boolean add) {
        if (item.mgr != null || item.state == 50) {
            this.showMessageBox(this.getString("DWN_ACTIVE_OR_FINISHED"), this.getString("DEFAULT_TITLE"), 0);
            return;
        }
        item.q = add;
        list.downloadStateChanged();
        this.model.fireTableDataChanged();
    }

    void executeCommands() {
        if (XDMMainWindow.config.executeCmd) {
            this.exec(XDMMainWindow.config.cmdTxt);
        }
        if (XDMMainWindow.config.antivir) {
            this.exec(XDMMainWindow.config.antivirTxt);
        }
        if (XDMMainWindow.config.hungUp) {
            this.exec(XDMMainWindow.config.hungUpTxt);
        }
        if (XDMMainWindow.config.halt) {
            this.exec(XDMMainWindow.config.haltTxt);
        }
    }

    void exec(String cmd) {
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void createShortcut(File f) {
        if (System.getProperty("os.name").contains("OS X")) {
            OSXUtil.createAppBundle(f);
        } else {
            LinuxUtil.createDesktopFile(f.getAbsolutePath(), false);
        }
    }

    void copyFiles(DownloadListItem[] items) {
        Object[] values = null;
        if (items != null) {
            values = new Object[items.length];
            int i = 0;
            while (i < items.length) {
                DownloadListItem item = items[i];
                File file = new File(item.saveto, item.filename);
                values[i] = file;
                ++i;
            }
        }
        StringBuffer plainBuf = new StringBuffer();
        StringBuffer htmlBuf = new StringBuffer();
        htmlBuf.append("<html>\n<body>\n<ul>\n");
        int i = 0;
        while (i < values.length) {
            Object obj = values[i];
            String val = obj == null ? "" : obj.toString();
            plainBuf.append(String.valueOf(val) + "\n");
            htmlBuf.append("  <li>" + val + "\n");
            ++i;
        }
        if (this.clipboard == null) {
            this.clipboard = this.t.getSystemClipboard();
        }
        this.clipboard.setContents(new FileTransferHandler.FileTransferable(plainBuf.toString(), htmlBuf.toString(), values), null);
    }

    void copyURL(String url) {
        System.out.println("Copying url " + url);
        if (this.clipboard == null) {
            this.clipboard = this.t.getSystemClipboard();
        }
        this.clipboard.setContents(new StringSelection(url), null);
    }

    public static void main(String[] args) {
        File f;
        System.setProperty("apple.awt.UIElement", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.menu.about.name", "XDM");
        try {
            UIManager.setLookAndFeel(new XDMLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String jarPath = XDMUtil.getJarPath();
        System.out.println(jarPath);
        if (System.getProperty("os.name").contains("OS X") && jarPath != null && jarPath.startsWith("/Volumes/xdm5setup")) {
            OSXInstallWindow osx = new OSXInstallWindow();
            osx.setLocationRelativeTo(null);
            osx.setModal(true);
            osx.setVisible(true);
            System.exit(0);
        }
        boolean firstRun = false;
        File fAppDir = new File(System.getProperty("user.home"), ".xdm");
        File fTmpDir = new File(fAppDir, "temp");
        File configFile = new File(fAppDir, ".xdmconf");
        firstRun = !fAppDir.exists();
        config = XDMConfig.load(configFile);
        XDMMainWindow.parseArgs(args);
        if (firstRun) {
            fAppDir.mkdirs();
            fTmpDir.mkdirs();
        }
        tempdir = fTmpDir.getAbsolutePath();
        destdir = System.getProperty("user.home");
        if (firstRun && (f = new File(System.getProperty("user.home"), "Downloads")).exists()) {
            destdir = f.getAbsolutePath();
            System.out.println(destdir);
        }
        appdir = fAppDir.getAbsolutePath();
        try {
            StringResource.loadResource("en");
            XDMIconMap.setIcon("DOC", XDMMainWindow.getIcon("document.png"));
            XDMIconMap.setIcon("MUSIC", XDMMainWindow.getIcon("music.png"));
            XDMIconMap.setIcon("OTHER", XDMMainWindow.getIcon("other.png"));
            XDMIconMap.setIcon("APP", XDMMainWindow.getIcon("exe.png"));
            XDMIconMap.setIcon("VID", XDMMainWindow.getIcon("video.png"));
            XDMIconMap.setIcon("ZIP", XDMMainWindow.getIcon("arc.png"));
            XDMIconMap.setIcon("FOLDER", XDMMainWindow.getIcon("folder.png"));
            XDMIconMap.setIcon("RIGHT_ARROW", XDMMainWindow.getIcon("left_arrow.png"));
            XDMIconMap.setIcon("LEFT_ARROW", XDMMainWindow.getIcon("right_arrow.png"));
            XDMIconMap.setIcon("UP_ARROW", XDMMainWindow.getIcon("up_arrow.png"));
            XDMIconMap.setIcon("DOWN_ARROW", XDMMainWindow.getIcon("down_arrow.png"));
            XDMIconMap.setIcon("EXPAND_ICON", XDMMainWindow.getIcon("expand.png"));
            XDMIconMap.setIcon("COLLAPSE_ICON", XDMMainWindow.getIcon("collapse.png"));
            XDMIconMap.setIcon("APP_ICON", XDMMainWindow.getIcon("icon.png"));
            XDMIconMap.setIcon("Q_ICON", XDMMainWindow.getIcon("q.png"));
            XDMIconMap.setIcon("YT_ICON", XDMMainWindow.getIcon("youtube72.png"));
            XDMIconMap.setIcon("RF_ICON", XDMMainWindow.getIcon("restart.png"));
            XDMIconMap.setIcon("COLD_ICON", XDMMainWindow.getIcon("xdm22.png"));
            XDMIconMap.setIcon("HOT_ICON", XDMMainWindow.getIcon("xdm22_hot.png"));
            XDMIconMap.setIcon("BACK_ICON", XDMMainWindow.getIcon("back.png"));
            XDMIconMap.setIcon("BACK_R_ICON", XDMMainWindow.getIcon("back_r.png"));
            XDMIconMap.setIcon("NEXT_ICON", XDMMainWindow.getIcon("next.png"));
            XDMIconMap.setIcon("NEXT_R_ICON", XDMMainWindow.getIcon("next_r.png"));
            XDMIconMap.setIcon("FF_ICON", XDMMainWindow.getIcon("firefox.png"));
            XDMIconMap.setIcon("CR_ICON", XDMMainWindow.getIcon("chrome.png"));
            XDMIconMap.setIcon("OP_ICON", XDMMainWindow.getIcon("opera.png"));
            XDMIconMap.setIcon("OT_ICON", XDMMainWindow.getIcon("browser.png"));
            XDMIconMap.setIcon("CI_ICON", XDMMainWindow.getIcon("chrome-inst.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XDMMainWindow mw = new XDMMainWindow();
        XDMServer server = new XDMServer(config, mw, mw);
        if (!server.start()) {
            server.sendParams(arg);
            System.exit(0);
        }
        if (arg.get("min") == null) {
            mw.setVisible(true);
        }
        Authenticator.getInstance().load(new File(fAppDir, ".xdmauth"));
        mw.configChanged();
        if (firstRun) {
            try {
                if (System.getProperty("os.name").contains("OS X")) {
                    OSXUtil.createAppBundle(new File(System.getProperty("user.home"), "Desktop"));
                    OSXUtil.enableAutoStart();
                    XDMMainWindow.config.autostart = true;
                } else {
                    mw.createShortcut(new File(XDMUtil.getJarPath()));
                    mw.createShortcut(new File(System.getProperty("user.home"), "Desktop"));
                    LinuxUtil.enableAutoStartLinux();
                    XDMMainWindow.config.autostart = true;
                    File appDir = new File(System.getProperty("user.home"), ".local/share/applications");
                    appDir.mkdirs();
                    LinuxUtil.createDesktopFile(appDir.getAbsolutePath(), false);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
            mw.showBrowserIntegrationDlg();
        }
    }
}

