/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.sdg.xdman.core.common.IXDMConstants;
import org.sdg.xdman.util.Java6Util;
import org.sdg.xdman.util.LinuxUtil;

public class XDMUtil
implements IXDMConstants {
    public static final int OS_X = 10;
    public static final int LINUX = 20;
    public static final int WINDOWS = 30;
    public static final int OS_UNKNOWN = 50;
    private static String jarPath = null;
    static final int MB = 0x100000;
    static final int KB = 1024;
    static String[] doc = new String[]{".doc", ".docx", ".txt", ".pdf", ".rtf", ".xml", ".c", ".cpp", ".java", ".cs", ".vb", ".html", ".htm", ".chm", ".xls", ".xlsx", ".ppt", ".pptx"};
    static String[] cmp = new String[]{".7z", ".zip", ".rar", ".gz", ".tgz", ".tbz2", ".bz2", ".lzh", ".sit", ".z"};
    static String[] music = new String[]{".mp3", ".wma", ".ogg", ".aiff", ".au", ".mid", ".midi", ".mp2", ".mpa", ".wav", ".aac"};
    static String[] vid = new String[]{".mpg", ".mpeg", ".avi", ".flv", ".asf", ".mov", ".mpe", ".wmv", ".mkv", ".mp4", ".3gp", ".divx", ".vob", ".webm"};
    static String[] prog = new String[]{".exe", ".msi", ".bin", ".sh", ".deb", ".cab", ".cpio", ".dll", ".jar"};
    static char[] invalid_chars = new char[]{'/', '\\', '\"', '?', '*', '<', '>', ':'};
    static long counter = 1L;

    public static void browse(String url) {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                LinuxUtil.browse(new URI(url));
            } else {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getJarPath() {
        if (jarPath == null) {
            try {
                String rawPath = XDMUtil.class.getResource("/res/icon.png").toString();
                rawPath = rawPath.replace("jar:", "");
                int index = rawPath.lastIndexOf("!");
                if (index > 0) {
                    rawPath = rawPath.substring(0, index);
                }
                String path = new URI(rawPath).getPath();
                jarPath = new File(path).getParent();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    jarPath = new File(XDMUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent();
                }
                catch (Exception exx) {
                    e.printStackTrace();
                }
            }
        }
        return jarPath;
    }

    public static int getOS() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (os.contains("OS X") || os.contains("Mac") || os.contains("Darwin") || os.contains("os X") || os.contains("os x")) {
            return 10;
        }
        if (os.contains("Linux") || os.contains("LINUX") || os.contains("linux")) {
            return 20;
        }
        if (os.contains("WINDOWS") || os.contains("Windows") || os.contains("windows")) {
            return 30;
        }
        return 50;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() < 1;
    }

    public static String getFormattedLength(double length) {
        if (length < 0.0) {
            return "---";
        }
        if (length > 1048576.0) {
            return String.format("%.1f MB", Float.valueOf((float)length / 1048576.0f));
        }
        if (length > 1024.0) {
            return String.format("%.1f KB", Float.valueOf((float)length / 1024.0f));
        }
        return String.format("%d B", (int)length);
    }

    public static String getETA(double length, float rate) {
        if (length == 0.0) {
            return "0 second.";
        }
        if (length < 1.0 || rate <= 0.0f) {
            return "---";
        }
        int sec = (int)(length / (double)rate);
        return XDMUtil.hms(sec);
    }

    static String hms(int sec) {
        int hrs = 0;
        int min = 0;
        hrs = sec / 3600;
        min = sec % 3600 / 60;
        sec %= 60;
        String str = "";
        if (hrs > 0) {
            str = String.valueOf(str) + hrs + " hour ";
        }
        str = String.valueOf(str) + min + " min ";
        str = String.valueOf(str) + sec + " seconds ";
        return str;
    }

    public static boolean validateURL(String url) {
        try {
            new URL(url);
            return url.startsWith("http") || url.startsWith("ftp://");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String findCategory(String filename) {
        String file = filename.toLowerCase();
        int i = 0;
        while (i < doc.length) {
            if (file.endsWith(doc[i])) {
                return "Documents";
            }
            ++i;
        }
        i = 0;
        while (i < cmp.length) {
            if (file.endsWith(cmp[i])) {
                return "Compressed";
            }
            ++i;
        }
        i = 0;
        while (i < music.length) {
            if (file.endsWith(music[i])) {
                return "Music";
            }
            ++i;
        }
        i = 0;
        while (i < prog.length) {
            if (file.endsWith(prog[i])) {
                return "Programs";
            }
            ++i;
        }
        i = 0;
        while (i < vid.length) {
            if (file.endsWith(vid[i])) {
                return "Video";
            }
            ++i;
        }
        return "Other";
    }

    public static String getFileName2(String url) {
        String file = null;
        try {
            file = new File(new URI(url).getPath()).getName();
            System.out.println("File name: " + file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || file.length() < 1) {
            file = "FILE";
        }
        return file;
    }

    public static void open(File f) {
        char ch = File.separatorChar;
        if (ch == '\\') {
            XDMUtil.openWindows(f);
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            LinuxUtil.open(f);
        } else {
            Java6Util.desktop$open(f);
        }
    }

    private static void openWindows(File f) {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            ArrayList<String> lst = new ArrayList<String>();
            lst.add("rundll32");
            lst.add("url.dll,FileProtocolHandler");
            lst.add(f.getAbsolutePath());
            builder.command(lst);
            builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFileName(String uri) {
        String path;
        block11: {
            block10: {
                int qindex;
                block9: {
                    block8: {
                        try {
                            if (uri != null) break block8;
                            return "FILE";
                        }
                        catch (Exception e) {
                            return "FILE";
                        }
                    }
                    if (!uri.equals("/") && uri.length() >= 1) break block9;
                    return "FILE";
                }
                int x = uri.lastIndexOf("/");
                path = uri;
                if (x > -1) {
                    path = uri.substring(x);
                }
                if ((qindex = path.indexOf("?")) > -1) {
                    path = path.substring(0, qindex);
                }
                if ((path = XDMUtil.decode(path)).length() >= 1) break block10;
                return "FILE";
            }
            if (!path.equals("/")) break block11;
            return "FILE";
        }
        return path;
    }

    public static String createSafeFileName(String str) {
        String safe_name = str;
        int i = 0;
        while (i < invalid_chars.length) {
            if (safe_name.indexOf(invalid_chars[i]) != -1) {
                safe_name = safe_name.replace(invalid_chars[i], '_');
            }
            ++i;
        }
        return safe_name;
    }

    static String getWithoutExt(String file) {
        int index = file.lastIndexOf(".");
        if (index < 0) {
            return file;
        }
        return file.substring(0, index);
    }

    static String getExt(String file) {
        int index;
        block3: {
            try {
                index = file.lastIndexOf(".");
                if (index >= 0) break block3;
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        return file.substring(index);
    }

    public static String getUniqueFileName(String dir, String f) {
        File target = new File(dir, f);
        while (target.exists()) {
            String name = XDMUtil.getWithoutExt(target.getName());
            int index = name.lastIndexOf(95);
            String prefix = name;
            int count = 0;
            if (index > 0 && index < name.length() - 1) {
                try {
                    count = Integer.parseInt(name.substring(index + 1));
                    prefix = name.substring(0, index);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String ext = XDMUtil.getExt(target.getName());
            f = String.valueOf(prefix) + "_" + ++count + ext;
            target = new File(dir, f);
        }
        return f;
    }

    public static String decode(String str) {
        char[] ch = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ch.length) {
            if (ch[i] != '/' && ch[i] != '\\' && ch[i] != '\"' && ch[i] != '?' && ch[i] != '*' && ch[i] != '<' && ch[i] != '>' && ch[i] != ':') {
                if (ch[i] == '%' && i + 2 < ch.length) {
                    int c = Integer.parseInt(String.valueOf(ch[i + 1]) + ch[i + 2], 16);
                    buf.append((char)c);
                    i += 2;
                } else {
                    buf.append(ch[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getType(String url) {
        try {
            int index = url.indexOf("?");
            if (index > 0) {
                String substr = url.substring(index + 1);
                String[] arr = substr.split("&");
                int i = 0;
                while (i < arr.length) {
                    if (arr[i].toLowerCase().startsWith("itag=")) {
                        return arr[i].split("=")[1];
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String nvl(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String createURL(String str) {
        try {
            new URL(str);
        }
        catch (MalformedURLException e) {
            return "http://" + str;
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println(XDMUtil.hms(13547));
        String str = "http://sound27.mp3pk.com/indian/race2/[Songs.PK]%20Race%202%20-%2003%20-%20Lat%20Lag%20Gayee.mp3";
        System.out.println(str);
        System.out.println(String.valueOf(XDMUtil.decode(str)) + "\n" + XDMUtil.getFileName(str));
        System.out.println(XDMUtil.getFileName(str));
    }

    public static synchronized File getTempFile(String tmpdir) {
        String name = String.valueOf(System.currentTimeMillis() + ++counter);
        return new File(tmpdir, name);
    }

    public static void copyStream(InputStream in, OutputStream out) throws Exception {
        int x;
        byte[] b = new byte[512];
        while ((x = in.read(b)) != -1) {
            out.write(b, 0, x);
        }
        in.close();
        out.close();
    }
}

