/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.helpgui.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.sourceforge.helpgui.page.Page;
import net.sourceforge.helpgui.parser.DocSet;
import nik777.streams.XmlStreamParser;

public class JavaHelpParser
extends DocSet.Parser {
    protected static final Page[] PAGEARRAY = new Page[0];

    /*
     * Enabled aggressive block sorting
     */
    public Page[] parse(String path, ClassLoader loader, Locale local, HashMap params) throws IOException {
        System.out.println("JavaHelpParser.parse: path=" + path);
        if (!path.endsWith(".hs") && !path.endsWith(".HS")) {
            return null;
        }
        URL resource = this.getResource(path, loader, local);
        if (resource == null) {
            return null;
        }
        String dir = "";
        int cut = path.lastIndexOf(47);
        if (cut > 0) {
            dir = path.substring(0, cut + 1);
        }
        System.out.println("JavaHelp: dir=" + dir);
        XmlStreamParser xml = new XmlStreamParser();
        xml.open(resource.openStream(), "UTF-8");
        if (!xml.next(2) || !xml.value().equals("helpset")) {
            return null;
        }
        System.out.println("JavaHelpParser.parse: loading " + path);
        HashMap map = null;
        String home = null;
        Page[] result = null;
        while (true) {
            String eng;
            String data;
            String type;
            String label;
            String name;
            String tag;
            if (xml.next(2)) {
                tag = xml.value();
                if (tag.equals("title")) {
                    if (params == null || params.containsKey("title")) continue;
                    if (!xml.next(6)) continue;
                    params.put("title", xml.value().trim());
                    continue;
                }
                if (tag.equals("maps")) {
                    String mode = tag;
                    continue;
                }
                if (tag.equals("homeID")) {
                    if (params != null && !params.containsKey("homepage")) {
                        if (xml.next(6)) {
                            home = xml.value().trim();
                        }
                    }
                    System.out.println("JavaHelp.parse: setting home=" + home);
                    if (home == null || home.length() <= 0) continue;
                    params.put("homepage", home);
                    continue;
                }
                if (tag.equals("mapref")) {
                    if (xml.next() == 4 && xml.value().equals("location")) {
                        if (map == null) {
                            map = new HashMap(0x400000);
                        }
                        this.parseResource(dir + xml.nextValue(), loader, local, map);
                        continue;
                    }
                    System.out.println("HelpSet.mapref: no location: ");
                    continue;
                }
                if (!tag.equals("view")) continue;
                name = null;
                label = null;
                type = null;
                data = null;
                eng = null;
                xml.next(0);
            } else {
                String value;
                if (home != null && (value = (String)map.get(home)) != null) {
                    params.put(home, value);
                    System.out.println("JavaHelp.parser: set home target=" + value);
                }
                return result;
            }
            while (xml.next() == 2) {
                tag = xml.value();
                if (xml.next() == 4 && xml.value().equals("engine")) {
                    eng = xml.nextValue();
                }
                if (xml.next(6)) {
                    if (tag.equals("name")) {
                        name = xml.value().trim();
                    } else if (tag.equals("label")) {
                        label = xml.value().trim();
                    } else if (tag.equals("type")) {
                        type = xml.value().trim();
                    } else if (tag.equals("data")) {
                        data = xml.value().trim();
                    }
                }
                if (xml.next(0)) continue;
                System.out.println("HelpSet.view: no CLOSE");
            }
            if (params != null) {
                params.put("view." + name, label);
                params.put("type." + name, type);
            }
            if (data != null && data.endsWith(".xml")) {
                Object obj = this.parseResource(dir + data, loader, local, map);
                if (!name.equals("TOC")) continue;
                result = ((ArrayList)obj).toArray(PAGEARRAY);
                continue;
            }
            System.out.println("JavaHelpParser.parse: null data: " + tag);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parseResource(String path, ClassLoader loader, Locale local, HashMap map) throws IOException {
        URL resource = this.getResource(path, loader, local);
        if (resource == null) {
            System.out.println("couldn't find resource: " + path);
            return null;
        }
        Object result = null;
        System.out.println("parseResource: parsing " + path);
        String dir = resource.toString();
        int cut = dir.lastIndexOf(47);
        if (cut > 0) {
            dir = dir.substring(0, cut + 1);
        }
        XmlStreamParser xml = new XmlStreamParser();
        xml.open(resource.openStream(), "UTF-8");
        Page page = null;
        Page parent = null;
        ArrayList<Page> stack = new ArrayList<Page>(16);
        ArrayList<Page> pages = null;
        String tag = null;
        while (xml.next() != -1) {
            try {
                if (xml.type() == 3) {
                    if (stack.size() > 0) {
                        parent = (Page)stack.remove(stack.size() - 1);
                        System.out.println("popping stack... parent=" + parent);
                    } else {
                        parent = null;
                    }
                }
                if (xml.type() != 2) continue;
                tag = xml.value();
                if (tag.equals("mapID")) {
                    String target = null;
                    String url = null;
                    while (xml.next() == 4) {
                        if (xml.value().equals("target")) {
                            target = xml.nextValue().trim();
                            continue;
                        }
                        if (!xml.value().equals("url")) continue;
                        url = xml.nextValue().trim();
                    }
                    if (!map.containsKey(target)) {
                        map.put(target, dir + url);
                    } else {
                        System.out.println("JavaHelp.parseResource: duplicate mapID found, ignored:" + target);
                    }
                }
                if (!tag.equals("tocitem")) continue;
                String text = null;
                String target = null;
                while (xml.next() == 4) {
                    if (xml.value().equals("text")) {
                        text = xml.nextValue();
                        continue;
                    }
                    if (!xml.value().equals("target")) continue;
                    target = xml.nextValue();
                }
                String value = (String)map.get(target);
                if (value == null || value.length() == 0) {
                    System.out.println("JavaHelp.parseresource: no mapping for: " + target);
                    continue;
                }
                page = new Page(text, "", map.get(target).toString(), false, parent);
                if (parent != null) {
                    page.setParent(parent);
                }
                if (parent == null) {
                    if (pages == null) {
                        pages = new ArrayList<Page>(128);
                    }
                    pages.add(page);
                }
                if (xml.type() != 3) {
                    if (parent != null) {
                        stack.add(parent);
                    }
                    parent = page;
                    continue;
                }
                if (xml.next() == 0) continue;
                System.out.println("JavaHelp.tocitem: no CLOSE");
            }
            catch (Exception e) {
                System.out.println("parseResource: " + e);
                e.printStackTrace(System.out);
                continue;
            }
            break;
        }
        return pages;
    }
}

