/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raster;

import artofillusion.Camera;
import artofillusion.material.MaterialSpec;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raster.ObjectMaterialInfo;
import artofillusion.texture.TextureSpec;
import java.util.ArrayList;

public class CompositingContext {
    public Vec3[] tempVec;
    public TextureSpec surfSpec;
    public MaterialSpec matSpec;
    public Camera camera;
    public RGBColor addColor;
    public RGBColor multColor;
    public RGBColor subpixelMult;
    public RGBColor subpixelColor;
    public RGBColor totalColor;
    public RGBColor totalTransparency;
    public ArrayList<ObjectMaterialInfo> materialStack;

    public CompositingContext(Camera camera) {
        this.camera = camera == null ? null : camera.duplicate();
        this.surfSpec = new TextureSpec();
        this.matSpec = new MaterialSpec();
        this.tempVec = new Vec3[4];
        for (int i = 0; i < this.tempVec.length; ++i) {
            this.tempVec[i] = new Vec3();
        }
        this.addColor = new RGBColor();
        this.multColor = new RGBColor();
        this.subpixelMult = new RGBColor();
        this.subpixelColor = new RGBColor();
        this.totalColor = new RGBColor();
        this.totalTransparency = new RGBColor();
        this.materialStack = new ArrayList();
    }

    public void cleanup() {
        this.tempVec = null;
        this.surfSpec = null;
        this.matSpec = null;
        this.camera = null;
        this.addColor = null;
        this.multColor = null;
        this.subpixelMult = null;
        this.subpixelColor = null;
        this.totalColor = null;
        this.totalTransparency = null;
        this.materialStack = null;
    }
}

