/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.FastMath;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public class RTDisplacedTriangle
extends RTObject {
    RenderingTriangle tri;
    Vec3 trueNorm;
    double minheight;
    double maxheight;
    private double tol;
    private boolean bumpMapped;
    private BoundingBox bounds;
    private Mat4 toLocal;
    private Mat4 fromLocal;
    private volatile ExtraInfo extraInfo;

    public RTDisplacedTriangle(RenderingMesh mesh, int which, Mat4 fromLocal, Mat4 toLocal, double tol, double time) {
        this.tri = mesh.triangle[which];
        Vec3 vert1 = mesh.vert[this.tri.v1];
        Vec3 vert2 = mesh.vert[this.tri.v2];
        Vec3 vert3 = mesh.vert[this.tri.v3];
        this.trueNorm = mesh.faceNorm[which];
        this.fromLocal = fromLocal;
        this.toLocal = toLocal;
        this.tol = tol;
        Vec3 norm1 = mesh.norm[this.tri.n1];
        Vec3 norm2 = mesh.norm[this.tri.n2];
        Vec3 norm3 = mesh.norm[this.tri.n3];
        int i = 0;
        if (this.trueNorm.dot(norm1) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(norm2) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(norm3) < 0.0) {
            ++i;
        }
        if (i > 1) {
            this.trueNorm.scale(-1.0);
        }
        this.minheight = Double.MAX_VALUE;
        this.maxheight = -1.7976931348623157E308;
        this.bounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.bounds.minz = Double.MAX_VALUE;
        this.bounds.miny = Double.MAX_VALUE;
        this.bounds.minx = Double.MAX_VALUE;
        this.bounds.maxz = -1.7976931348623157E308;
        this.bounds.maxy = -1.7976931348623157E308;
        this.bounds.maxx = -1.7976931348623157E308;
        double d = 2.0 * Math.max(Math.max(vert1.minus(vert2).length2(), vert1.minus(vert3).length2()), vert2.minus(vert3).length2());
        int divisions = FastMath.ceil((double)(Math.sqrt(d) / tol));
        if (divisions > 499) {
            divisions = 499;
        }
        Vec3 temp = new Vec3();
        d = 1.0 / (double)divisions;
        for (i = 0; i <= divisions; ++i) {
            for (int j = 0; j <= divisions - i; ++j) {
                double u = (double)i * d;
                double v = (double)j * d;
                double w = (double)(divisions - i - j) * d;
                double disp = this.tri.getDisplacement(u, v, w, tol, time);
                temp.set(u * norm1.x + v * norm2.x + w * norm3.x, u * norm1.y + v * norm2.y + w * norm3.y, u * norm1.z + v * norm2.z + w * norm3.z);
                temp.normalize();
                double h = disp * temp.dot(this.trueNorm);
                if (h < this.minheight) {
                    this.minheight = h;
                }
                if (h > this.maxheight) {
                    this.maxheight = h;
                }
                temp.set(u * vert1.x + v * vert2.x + w * vert3.x + disp * temp.x, u * vert1.y + v * vert2.y + w * vert3.y + disp * temp.y, u * vert1.z + v * vert2.z + w * vert3.z + disp * temp.z);
                if (temp.x < this.bounds.minx) {
                    this.bounds.minx = temp.x;
                }
                if (temp.x > this.bounds.maxx) {
                    this.bounds.maxx = temp.x;
                }
                if (temp.y < this.bounds.miny) {
                    this.bounds.miny = temp.y;
                }
                if (temp.y > this.bounds.maxy) {
                    this.bounds.maxy = temp.y;
                }
                if (temp.z < this.bounds.minz) {
                    this.bounds.minz = temp.z;
                }
                if (!(temp.z > this.bounds.maxz)) continue;
                this.bounds.maxz = temp.z;
            }
        }
        this.bounds.outset(0.5 * tol);
        this.bumpMapped = this.tri.theMesh.mapping.getTexture().hasComponent(5);
    }

    public boolean isReallyDisplaced() {
        return this.minheight != 0.0 || this.maxheight != 0.0;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    private synchronized void init() {
        double scale3;
        double scale2;
        if (this.extraInfo != null) {
            return;
        }
        ExtraInfo ex = new ExtraInfo();
        Vec3[] vert = this.tri.theMesh.vert;
        Vec3 vert1 = vert[this.tri.v1];
        Vec3 vert2 = vert[this.tri.v2];
        Vec3 vert3 = vert[this.tri.v3];
        ex.trans = Mat4.viewTransform((Vec3)vert3, (Vec3)this.trueNorm, (Vec3)vert2.minus(vert3));
        Vec3 v1 = ex.trans.times(vert1);
        Vec3 v2 = ex.trans.times(vert2);
        ex.v1x = v1.x;
        ex.v1y = v1.y;
        ex.v2y = v2.y;
        Vec3[] norm = this.tri.theMesh.norm;
        Vec3 n1 = ex.trans.timesDirection(norm[this.tri.n1]);
        Vec3 n2 = ex.trans.timesDirection(norm[this.tri.n2]);
        Vec3 n3 = ex.trans.timesDirection(norm[this.tri.n3]);
        ex.n1x = n1.x;
        ex.n1y = n1.y;
        ex.n1z = n1.z;
        ex.n2x = n2.x;
        ex.n2y = n2.y;
        ex.n2z = n2.z;
        ex.n3x = n3.x;
        ex.n3y = n3.y;
        ex.n3z = n3.z;
        Vec3[] pos = new Vec3[6];
        double scale1 = 1.0 / norm[this.tri.n1].dot(this.trueNorm);
        if (Double.isInfinite(scale1)) {
            scale1 = 0.0;
        }
        if (Double.isInfinite(scale2 = 1.0 / norm[this.tri.n2].dot(this.trueNorm))) {
            scale2 = 0.0;
        }
        if (Double.isInfinite(scale3 = 1.0 / norm[this.tri.n3].dot(this.trueNorm))) {
            scale3 = 0.0;
        }
        pos[0] = new Vec3(v1.x + n1.x * this.minheight * scale1, v1.y + n1.y * this.minheight * scale1, n1.z * this.minheight * scale1);
        pos[1] = new Vec3(v1.x + n1.x * this.maxheight * scale1, v1.y + n1.y * this.maxheight * scale1, n1.z * this.maxheight * scale1);
        pos[2] = new Vec3(n2.x * this.minheight * scale2, v2.y + n2.y * this.minheight * scale2, n2.z * this.minheight * scale2);
        pos[3] = new Vec3(n2.x * this.maxheight * scale2, v2.y + n2.y * this.maxheight * scale2, n2.z * this.maxheight * scale2);
        pos[4] = new Vec3(n3.x * this.minheight * scale3, n3.y * this.minheight * scale3, n3.z * this.minheight * scale3);
        pos[5] = new Vec3(n3.x * this.maxheight * scale3, n3.y * this.maxheight * scale3, n3.z * this.maxheight * scale3);
        BoundingBox bounds2 = new BoundingBox(pos[0].x, pos[0].x, pos[0].y, pos[0].y, pos[0].z, pos[0].z);
        for (int i = 1; i < 6; ++i) {
            if (pos[i].x < bounds2.minx) {
                bounds2.minx = pos[i].x;
            }
            if (pos[i].x > bounds2.maxx) {
                bounds2.maxx = pos[i].x;
            }
            if (pos[i].y < bounds2.miny) {
                bounds2.miny = pos[i].y;
            }
            if (pos[i].y > bounds2.maxy) {
                bounds2.maxy = pos[i].y;
            }
            if (pos[i].z < bounds2.minz) {
                bounds2.minz = pos[i].z;
            }
            if (!(pos[i].z > bounds2.maxz)) continue;
            bounds2.maxz = pos[i].z;
        }
        bounds2.outset(0.5 * this.tol);
        ex.bounds2 = bounds2;
        ex.dn1x = n1.x - n3.x;
        ex.dn1y = n1.y - n3.y;
        ex.dn2x = n2.x - n3.x;
        ex.dn2y = n2.y - n3.y;
        ex.minscale = 1.0 / Math.max(Math.max(n1.z, n2.z), n3.z);
        ex.maxscale = 1.0 / Math.min(Math.min(n1.z, n2.z), n3.z);
        this.extraInfo = ex;
    }

    @Override
    public final TextureMapping getTextureMapping() {
        return this.tri.getTextureMapping();
    }

    @Override
    public final MaterialMapping getMaterialMapping() {
        return this.tri.theMesh.matMapping;
    }

    @Override
    public SurfaceIntersection checkIntersection(Ray r) {
        double t;
        DisplacedTriangleIntersection dti = (DisplacedTriangleIntersection)r.rt.rtDispTriPool.getObject();
        dti.init(this, r);
        if (!RTDisplacedTriangle.rayIntersectsBounds(r.origin, r.direction, this.bounds, dti)) {
            return SurfaceIntersection.NO_INTERSECTION;
        }
        double mint = dti.mint;
        double maxt = dti.maxt;
        if (this.extraInfo == null) {
            this.init();
        }
        ExtraInfo extra = this.extraInfo;
        Vec3 orig = dti.orig;
        Vec3 dir = dti.dir;
        extra.trans.transform(orig);
        extra.trans.transformDirection(dir);
        if (!RTDisplacedTriangle.rayIntersectsBounds(orig, dir, extra.bounds2, dti)) {
            return SurfaceIntersection.NO_INTERSECTION;
        }
        if (mint < dti.mint) {
            mint = dti.mint;
        }
        if (maxt > dti.maxt) {
            maxt = dti.maxt;
        }
        if (mint < 0.0) {
            mint = 0.0;
        }
        double x = orig.x + maxt * dir.x;
        double y = orig.y + maxt * dir.y;
        double z = orig.z + maxt * dir.z;
        this.calcCoords(dti, x, y, z);
        double lastu = dti.u;
        double lastv = dti.v;
        double lastw = dti.w;
        x = orig.x + mint * dir.x;
        y = orig.y + mint * dir.y;
        z = orig.z + mint * dir.z;
        this.calcCoords(dti, x, y, z);
        double u = dti.u;
        double v = dti.v;
        double w = dti.w;
        if (u < 0.0 && lastu < 0.0 || u > 1.0 && lastu > 1.0 || v < 0.0 && lastv < 0.0 || v > 1.0 && lastv > 1.0 || w < 0.0 && lastw < 0.0 || w > 1.0 && lastw > 1.0) {
            return SurfaceIntersection.NO_INTERSECTION;
        }
        Vec3 temp1 = r.tempVec1;
        temp1.set(u * extra.n1x + v * extra.n2x + w * extra.n3x, u * extra.n1y + v * extra.n2y + w * extra.n3y, u * extra.n1z + v * extra.n2z + w * extra.n3z);
        double time = r.rt.rt.getTime();
        double disp = this.tri.getDisplacement(u, v, w, this.tol, time);
        double height = disp * temp1.z / temp1.length();
        double prevDelta = z - height;
        boolean above = z > height;
        boolean wasOutsideU = u < 0.0 || u > 1.0;
        boolean wasOutsideV = v < 0.0 || v > 1.0;
        boolean wasOutsideW = w < 0.0 || w > 1.0;
        double prevt = t = mint;
        dti.numIntersections = (short)-1;
        dti.tint[0] = Double.MAX_VALUE;
        while (t < maxt) {
            boolean outsideW;
            if ((t += this.tol) >= maxt) {
                t = maxt;
                x = orig.x + t * dir.x;
                y = orig.y + t * dir.y;
                z = orig.z + t * dir.z;
                u = lastu;
                v = lastv;
                w = lastw;
            } else {
                x = orig.x + t * dir.x;
                y = orig.y + t * dir.y;
                z = orig.z + t * dir.z;
                this.calcCoords(dti, x, y, z);
                u = dti.u;
                v = dti.v;
                w = dti.w;
            }
            disp = this.tri.getDisplacement(u, v, w, this.tol, time);
            temp1.set(u * extra.n1x + v * extra.n2x + w * extra.n3x, u * extra.n1y + v * extra.n2y + w * extra.n3y, u * extra.n1z + v * extra.n2z + w * extra.n3z);
            height = disp * temp1.z / temp1.length();
            boolean outsideU = u < 0.0 || u > 1.0;
            boolean outsideV = v < 0.0 || v > 1.0;
            boolean bl = outsideW = w < 0.0 || w > 1.0;
            if (outsideU && wasOutsideU || outsideV && wasOutsideV || outsideW && wasOutsideW) {
                above = z > height;
                prevDelta = z - height;
                prevt = t;
                wasOutsideU = outsideU;
                wasOutsideV = outsideV;
                wasOutsideW = outsideW;
                continue;
            }
            if (above && z <= height || !above && z >= height) {
                double truet = t - (t - prevt) * (z - height) / (z - height - prevDelta);
                if (truet <= this.tol) {
                    above = z > height;
                    prevDelta = z - height;
                    prevt = t;
                    wasOutsideU = outsideU;
                    wasOutsideV = outsideV;
                    wasOutsideW = outsideW;
                    continue;
                }
                x = orig.x + truet * dir.x;
                y = orig.y + truet * dir.y;
                z = orig.z + truet * dir.z;
                this.calcCoords(dti, x, y, z);
                u = dti.u;
                v = dti.v;
                w = dti.w;
                dti.tint[0] = truet;
                dti.uint[0] = u;
                dti.vint[0] = v;
                break;
            }
            prevDelta = z - height;
            above = z > height;
            prevt = t;
            wasOutsideU = outsideU;
            wasOutsideV = outsideV;
            wasOutsideW = outsideW;
        }
        if (dti.tint[0] == Double.MAX_VALUE) {
            return SurfaceIntersection.NO_INTERSECTION;
        }
        disp = this.tri.getDisplacement(u, v, w, this.tol, time);
        dti.rint[0].set(r.origin.x + dti.tint[0] * r.direction.x, r.origin.y + dti.tint[0] * r.direction.y, r.origin.z + dti.tint[0] * r.direction.z);
        double dhdu = (this.tri.getDisplacement(u + 1.0E-5, v, w - 1.0E-5, this.tol, time) - disp) * 100000.0;
        double dhdv = (this.tri.getDisplacement(u, v + 1.0E-5, w - 1.0E-5, this.tol, time) - disp) * 100000.0;
        Vec3[] norm = this.tri.theMesh.norm;
        Vec3 norm1 = norm[this.tri.n1];
        Vec3 norm2 = norm[this.tri.n2];
        Vec3 norm3 = norm[this.tri.n3];
        Vec3 interp = dti.interp;
        interp.set(u * norm1.x + v * norm2.x + w * norm3.x, u * norm1.y + v * norm2.y + w * norm3.y, u * norm1.z + v * norm2.z + w * norm3.z);
        interp.normalize();
        Vec3[] vert = this.tri.theMesh.vert;
        Vec3 vert1 = vert[this.tri.v1];
        Vec3 vert2 = vert[this.tri.v2];
        Vec3 vert3 = vert[this.tri.v3];
        Vec3 temp2 = r.tempVec2;
        Vec3 temp3 = r.tempVec3;
        Vec3 temp4 = r.tempVec4;
        temp1.set(vert1.x + disp * norm1.x, vert1.y + disp * norm1.y, vert1.z + disp * norm1.z);
        temp2.set(vert2.x + disp * norm2.x, vert2.y + disp * norm2.y, vert2.z + disp * norm2.z);
        temp3.set(vert3.x + disp * norm3.x, vert3.y + disp * norm3.y, vert3.z + disp * norm3.z);
        temp1.set(temp1.x - temp3.x, temp1.y - temp3.y, temp1.z - temp3.z);
        temp2.set(temp3.x - temp2.x, temp3.y - temp2.y, temp3.z - temp2.z);
        temp3.set(temp1.y * interp.z - temp1.z * interp.y, temp1.z * interp.x - temp1.x * interp.z, temp1.x * interp.y - temp1.y * interp.x);
        temp4.set(temp2.y * interp.z - temp2.z * interp.y, temp2.z * interp.x - temp2.x * interp.z, temp2.x * interp.y - temp2.y * interp.x);
        temp3.scale(-1.0 / temp3.dot(temp2));
        temp4.scale(1.0 / temp4.dot(temp1));
        temp1.set(dhdu * temp4.x + dhdv * temp3.x, dhdu * temp4.y + dhdv * temp3.y, dhdu * temp4.z + dhdv * temp3.z);
        interp.scale(temp1.dot(interp) + 1.0);
        interp.subtract(temp1);
        interp.normalize();
        return dti;
    }

    private void calcCoords(DisplacedTriangleIntersection dti, double x, double y, double z) {
        ExtraInfo extra = this.extraInfo;
        double dmax = z * extra.maxscale;
        double dmin = z * extra.minscale;
        this.guessCoords(dti, x, y, dmax);
        double ua = dti.u;
        double va = dti.v;
        double wa = dti.w;
        double zmax = dmax * (dti.u * extra.n1z + dti.v * extra.n2z + dti.w * extra.n3z);
        this.guessCoords(dti, x, y, dmin);
        double zmin = dmin * (dti.u * extra.n1z + dti.v * extra.n2z + dti.w * extra.n3z);
        if (zmax == zmin) {
            return;
        }
        double fract = (z - zmin) / (zmax - zmin);
        double fract2 = 1.0 - fract;
        dti.u = fract * ua + fract2 * dti.u;
        dti.v = fract * va + fract2 * dti.v;
        dti.w = fract * wa + fract2 * dti.w;
    }

    private void guessCoords(DisplacedTriangleIntersection dti, double x, double y, double disp) {
        ExtraInfo extra = this.extraInfo;
        double a = extra.v1x + disp * extra.dn1x;
        double b = disp * extra.dn2x;
        double c = x - disp * extra.n3x;
        double e = extra.v1y + disp * extra.dn1y;
        double f = extra.v2y + disp * extra.dn2y;
        double g = y - disp * extra.n3y;
        double m = 1.0 / (a * f - b * e);
        dti.u = (c * f - b * g) * m;
        dti.v = (a * g - c * e) * m;
        dti.w = 1.0 - dti.u - dti.v;
    }

    @Override
    public BoundingBox getBounds() {
        return this.bounds;
    }

    @Override
    public boolean intersectsNode(OctreeNode node) {
        if (!node.intersects(this.bounds)) {
            return false;
        }
        double dot = this.tri.theMesh.vert[this.tri.v1].dot(this.trueNorm);
        double mindot = dot + this.minheight;
        double maxdot = dot + this.maxheight;
        boolean anyBelow = false;
        boolean anyAbove = false;
        dot = this.trueNorm.x * (double)node.minx + this.trueNorm.y * (double)node.miny + this.trueNorm.z * (double)node.minz;
        if (dot < mindot) {
            anyBelow = true;
        } else if (dot > maxdot) {
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * (double)node.minx + this.trueNorm.y * (double)node.miny + this.trueNorm.z * (double)node.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * (double)node.minx + this.trueNorm.y * (double)node.maxy + this.trueNorm.z * (double)node.minz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * (double)node.minx + this.trueNorm.y * (double)node.maxy + this.trueNorm.z * (double)node.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * (double)node.maxx + this.trueNorm.y * (double)node.miny + this.trueNorm.z * (double)node.minz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * (double)node.maxx + this.trueNorm.y * (double)node.miny + this.trueNorm.z * (double)node.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * (double)node.maxx + this.trueNorm.y * (double)node.maxy + this.trueNorm.z * (double)node.minz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * (double)node.maxx + this.trueNorm.y * (double)node.maxy + this.trueNorm.z * (double)node.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static boolean rayIntersectsBounds(Vec3 origin, Vec3 direction, BoundingBox bb, DisplacedTriangleIntersection dti) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < bb.minx || origin.x > bb.maxx) {
                return false;
            }
        } else {
            t1 = (bb.minx - origin.x) / direction.x;
            t2 = (bb.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return false;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < bb.miny || origin.y > bb.maxy) {
                return false;
            }
        } else {
            t1 = (bb.miny - origin.y) / direction.y;
            t2 = (bb.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return false;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < bb.minz || origin.z > bb.maxz) {
                return false;
            }
        } else {
            t1 = (bb.minz - origin.z) / direction.z;
            t2 = (bb.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 0.0) {
                return false;
            }
        }
        dti.mint = mint;
        dti.maxt = maxt;
        return true;
    }

    @Override
    public Mat4 toLocal() {
        return this.toLocal;
    }

    @Override
    public Object getObject() {
        return this.tri.theMesh;
    }

    public static class DisplacedTriangleIntersection
    implements SurfaceIntersection {
        public RTDisplacedTriangle rtTri;
        public double t;
        public double u;
        public double v;
        public double w;
        public double mint;
        public double maxt;
        public double[] tint = new double[1];
        public double[] uint = new double[1];
        public double[] vint = new double[1];
        public Vec3 orig;
        public Vec3 dir;
        public Vec3 interp;
        public Vec3[] rint = new Vec3[]{new Vec3()};
        public short numIntersections;
        public Ray ray;

        @Override
        public RTObject getObject() {
            return this.rtTri;
        }

        public DisplacedTriangleIntersection() {
            this.orig = new Vec3();
            this.dir = new Vec3();
            this.interp = new Vec3();
        }

        public void init(RTDisplacedTriangle tri, Ray r) {
            this.rtTri = tri;
            this.ray = r;
            this.orig.set(r.origin);
            this.dir.set(r.direction);
        }

        @Override
        public int numIntersections() {
            if (this.numIntersections == -1) {
                this.findAllIntersections();
            }
            return this.numIntersections;
        }

        @Override
        public void intersectionPoint(int n, Vec3 p) {
            p.set(this.rint[n]);
        }

        @Override
        public double intersectionDist(int n) {
            return this.tint[n];
        }

        @Override
        public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size, double time) {
            n.set(this.interp);
            this.rtTri.tri.getTextureSpec(spec, -n.dot(viewDir), this.uint[0], this.vint[0], 1.0 - this.uint[0] - this.vint[0], size, time);
            if (this.rtTri.bumpMapped) {
                this.rtTri.fromLocal.transformDirection(spec.bumpGrad);
                n.scale(spec.bumpGrad.dot(n) + 1.0);
                n.subtract(spec.bumpGrad);
                n.normalize();
            }
        }

        @Override
        public void intersectionTransparency(int n, RGBColor trans, double angle, double size, double time) {
            this.rtTri.tri.getTransparency(trans, angle, this.uint[n], this.vint[n], 1.0 - this.uint[0] - this.vint[0], size, time);
        }

        @Override
        public void trueNormal(Vec3 n) {
            n.set(this.interp);
        }

        private void findAllIntersections() {
            ExtraInfo extra = this.rtTri.extraInfo;
            double x = this.orig.x + this.t * this.dir.x;
            double y = this.orig.y + this.t * this.dir.y;
            double z = this.orig.z + this.t * this.dir.z;
            Vec3 temp1 = this.ray.tempVec1;
            temp1.set(this.u * extra.n1x + this.v * extra.n2x + this.w * extra.n3x, this.u * extra.n1y + this.v * extra.n2y + this.w * extra.n3y, this.u * extra.n1z + this.v * extra.n2z + this.w * extra.n3z);
            double time = this.ray.rt.rt.getTime();
            double disp = this.rtTri.tri.getDisplacement(this.u, this.v, this.w, this.rtTri.tol, time);
            double height = disp * temp1.z / temp1.length();
            double prevDelta = z - height;
            double prevt = this.t;
            boolean above = z > height;
            boolean wasOutsideU = this.u < 0.0 || this.u > 1.0;
            boolean wasOutsideV = this.v < 0.0 || this.v > 1.0;
            boolean wasOutsideW = this.w < 0.0 || this.w > 1.0;
            this.numIntersections = 1;
            while (this.t < this.maxt) {
                boolean outsideW;
                this.t += this.rtTri.tol;
                if (this.t >= this.maxt) {
                    this.t = this.maxt;
                }
                x = this.orig.x + this.t * this.dir.x;
                y = this.orig.y + this.t * this.dir.y;
                z = this.orig.z + this.t * this.dir.z;
                this.rtTri.calcCoords(this, x, y, z);
                disp = this.rtTri.tri.getDisplacement(this.u, this.v, this.w, this.rtTri.tol, time);
                temp1.set(this.u * extra.n1x + this.v * extra.n2x + this.w * extra.n3x, this.u * extra.n1y + this.v * extra.n2y + this.w * extra.n3y, this.u * extra.n1z + this.v * extra.n2z + this.w * extra.n3z);
                height = disp * temp1.z / temp1.length();
                boolean outsideU = this.u < 0.0 || this.u > 1.0;
                boolean outsideV = this.v < 0.0 || this.v > 1.0;
                boolean bl = outsideW = this.w < 0.0 || this.w > 1.0;
                if (outsideU && wasOutsideU || outsideV && wasOutsideV || outsideW && wasOutsideW) {
                    above = z > height;
                    prevDelta = z - height;
                    prevt = this.t;
                    wasOutsideU = outsideU;
                    wasOutsideV = outsideV;
                    wasOutsideW = outsideW;
                    continue;
                }
                if (above && z <= height || !above && z >= height) {
                    if (this.numIntersections == this.tint.length) {
                        int j;
                        double[] newt = new double[this.numIntersections * 2];
                        double[] newu = new double[this.numIntersections * 2];
                        double[] newv = new double[this.numIntersections * 2];
                        Vec3[] newr = new Vec3[this.numIntersections * 2];
                        for (j = 0; j < this.tint.length; ++j) {
                            newt[j] = this.tint[j];
                            newu[j] = this.uint[j];
                            newv[j] = this.vint[j];
                            newr[j] = this.rint[j];
                        }
                        for (j = this.tint.length; j < newt.length; ++j) {
                            newr[j] = new Vec3();
                        }
                        this.tint = newt;
                        this.uint = newu;
                        this.vint = newv;
                        this.rint = newr;
                    }
                    double oldz = z;
                    double truet = this.t - (this.t - prevt) * (z - height) / (z - height - prevDelta);
                    x = this.orig.x + truet * this.dir.x;
                    y = this.orig.y + truet * this.dir.y;
                    z = this.orig.z + truet * this.dir.z;
                    this.rtTri.calcCoords(this, x, y, z);
                    this.tint[this.numIntersections] = truet;
                    this.uint[this.numIntersections] = this.u;
                    this.vint[this.numIntersections] = this.v;
                    this.rint[this.numIntersections].set(this.ray.origin.x + truet * this.ray.direction.x, this.ray.origin.y + truet * this.ray.direction.y, this.ray.origin.z + truet * this.ray.direction.z);
                    this.numIntersections = (short)(this.numIntersections + 1);
                    z = oldz;
                }
                prevDelta = z - height;
                above = z > height;
                prevt = this.t;
                wasOutsideU = outsideU;
                wasOutsideV = outsideV;
                wasOutsideW = outsideW;
            }
        }
    }

    private static class ExtraInfo {
        Mat4 trans;
        BoundingBox bounds2;
        double v1x;
        double v1y;
        double v2y;
        double n1x;
        double n1y;
        double n1z;
        double n2x;
        double n2y;
        double n2z;
        double n3x;
        double n3y;
        double n3z;
        double dn1x;
        double dn1y;
        double dn2x;
        double dn2y;
        double minscale;
        double maxscale;

        private ExtraInfo() {
        }
    }
}

