/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class CompositeTransferable
implements Transferable {
    private HashMap transferables = new HashMap();
    private LinkedList flavors = new LinkedList();

    public void add(Transferable t) {
        DataFlavor[] f = t.getTransferDataFlavors();
        for (int i = 0; i < f.length; ++i) {
            if (!this.transferables.containsKey(f[i])) {
                this.flavors.add(f[i]);
            }
            this.transferables.put(f[i], t);
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Transferable t = (Transferable)this.transferables.get(flavor);
        if (t == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return t.getTransferData(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.transferables.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.transferables.containsKey(flavor);
    }
}

