/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.RepaintEvent;
import buoy.event.WindowResizedEvent;
import buoy.widget.BMenuBar;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JRootPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFrame
extends WindowWidget {
    private BMenuBar menubar;
    private ImageIcon icon;
    private static WeakHashMap<Frame, WeakReference<BFrame>> frameMap = new WeakHashMap();

    public BFrame() {
        this.component = this.createComponent();
        this.getComponent().getContentPane().setLayout(null);
        this.getComponent().setDefaultCloseOperation(0);
        frameMap.put(this.getComponent(), new WeakReference<BFrame>(this));
    }

    public BFrame(String title) {
        this();
        this.getComponent().setTitle(title);
    }

    protected JFrame createComponent() {
        return new BFrameComponent();
    }

    @Override
    public JFrame getComponent() {
        return (JFrame)this.component;
    }

    @Override
    public int getChildCount() {
        return (this.menubar == null ? 0 : 1) + (this.content == null ? 0 : 1);
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> ls = new ArrayList<Widget>(3);
        if (this.menubar != null) {
            ls.add(this.menubar);
        }
        if (this.content != null) {
            ls.add(this.content);
        }
        return ls;
    }

    public BMenuBar getMenuBar() {
        return this.menubar;
    }

    public void setMenuBar(BMenuBar menus) {
        if (this.menubar != null) {
            this.remove(this.menubar);
        }
        if (menus == null) {
            return;
        }
        if (menus.getParent() != null) {
            menus.getParent().remove(menus);
        }
        this.menubar = menus;
        this.getComponent().setJMenuBar(this.menubar.getComponent());
        this.setAsParent(this.menubar);
    }

    @Override
    public void remove(Widget widget) {
        if (this.menubar == widget) {
            this.getComponent().setJMenuBar(null);
            this.removeAsParent(this.menubar);
            this.menubar = null;
        } else if (this.content == widget) {
            this.getComponent().getContentPane().remove(widget.getComponent());
            this.removeAsParent(this.content);
            this.content = null;
        }
    }

    @Override
    public void removeAll() {
        if (this.menubar != null) {
            this.remove(this.menubar);
        }
        if (this.content != null) {
            this.remove(this.content);
        }
    }

    public String getTitle() {
        return this.getComponent().getTitle();
    }

    public void setTitle(String title) {
        this.getComponent().setTitle(title);
    }

    public boolean isResizable() {
        return this.getComponent().isResizable();
    }

    public void setResizable(boolean resizable) {
        this.getComponent().setResizable(resizable);
    }

    public boolean isIconified() {
        return (this.getComponent().getExtendedState() & 1) != 0;
    }

    public void setIconified(boolean iconified) {
        JFrame jf = this.getComponent();
        int state = jf.getExtendedState();
        if (iconified) {
            jf.setExtendedState(state | 1);
        } else {
            jf.setExtendedState(state - state & 1);
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.getComponent().setIconImage(icon.getImage());
    }

    public boolean isMaximized() {
        return (this.getComponent().getExtendedState() & 6) != 0;
    }

    public void setMaximized(boolean maximized) {
        JFrame jf = this.getComponent();
        int state = jf.getExtendedState();
        if (maximized) {
            jf.setExtendedState(state | 6);
        } else {
            jf.setExtendedState(state - state & 6);
        }
        this.lastSize = jf.getSize();
    }

    @Override
    protected JRootPane getRootPane() {
        return this.getComponent().getRootPane();
    }

    public static List<BFrame> getFrames() {
        ArrayList<BFrame> list = new ArrayList<BFrame>();
        for (Frame frame : Frame.getFrames()) {
            BFrame bf;
            WeakReference<BFrame> ref = frameMap.get(frame);
            if (ref == null || (bf = (BFrame)ref.get()) == null) continue;
            list.add(bf);
        }
        return list;
    }

    private class BFrameComponent
    extends JFrame {
        public void paintComponent(Graphics g) {
            BFrame.this.dispatchEvent(new RepaintEvent(BFrame.this, (Graphics2D)g));
        }

        public void validate() {
            super.validate();
            BFrame.this.layoutChildren();
            if (!BFrame.this.getComponent().getSize().equals(BFrame.this.lastSize)) {
                BFrame.this.lastSize = BFrame.this.getComponent().getSize();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BFrame.this.dispatchEvent(new WindowResizedEvent(BFrame.this));
                    }
                });
            }
        }
    }
}

