/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.widget.BScrollBar;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BListDelegate;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BList
extends Widget {
    protected DefaultListModel defaultModel = new DefaultListModel();

    public BList() {
        this.component = this.createComponent();
        this.getComponent().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                BList.this.dispatchEvent(new SelectionChangedEvent(BList.this, ev.getValueIsAdjusting()));
            }
        });
    }

    public BList(Object[] contents) {
        this();
        this.setContents(contents);
    }

    public BList(Collection contents) {
        this();
        this.setContents(contents);
    }

    public BList(ListModel model) {
        this();
        this.getComponent().setModel(model);
    }

    protected JList createComponent() {
        return new JList(this.defaultModel);
    }

    public JList getComponent() {
        return (JList)this.component;
    }

    public void setContents(Object[] o) {
        this.defaultModel.clear();
        for (int i = 0; i < o.length; ++i) {
            this.defaultModel.addElement(o[i]);
        }
        this.updateScrollPane();
    }

    public void setContents(Collection c) {
        this.defaultModel.clear();
        for (Object obj : c) {
            this.defaultModel.addElement(obj);
        }
        this.updateScrollPane();
    }

    public void add(Object o) {
        this.defaultModel.addElement(o);
        this.updateScrollPane();
    }

    public void add(int index, Object o) {
        this.defaultModel.add(index, o);
        this.updateScrollPane();
    }

    public void replace(int index, Object o) {
        this.defaultModel.set(index, o);
        this.updateScrollPane();
    }

    public void remove(int index) {
        this.defaultModel.remove(index);
        this.updateScrollPane();
    }

    public void removeAll() {
        this.defaultModel.clear();
        this.updateScrollPane();
    }

    public ListModel getModel() {
        return this.getComponent().getModel();
    }

    public void setModel(ListModel model) {
        this.getComponent().setModel(model);
    }

    private void updateScrollPane() {
        this.invalidateSize();
        if (!(this.getParent() instanceof BScrollPane)) {
            return;
        }
        BScrollPane sp = (BScrollPane)this.getParent();
        BScrollBar sb = sp.getVerticalScrollBar();
        if (sb != null) {
            sb.setMaximum(this.getComponent().getHeight());
        }
        if ((sb = sp.getHorizontalScrollBar()) != null) {
            sb.setMaximum(this.getComponent().getWidth());
        }
    }

    public int getItemCount() {
        return this.getComponent().getModel().getSize();
    }

    public Object getItem(int index) {
        return this.getComponent().getModel().getElementAt(index);
    }

    public boolean isMultipleSelectionEnabled() {
        return this.getComponent().getSelectionMode() != 0;
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        this.getComponent().setSelectionMode(multiple ? 2 : 0);
    }

    public int getPreferredVisibleRows() {
        return this.getComponent().getVisibleRowCount();
    }

    public void setPreferredVisibleRows(int rows) {
        this.getComponent().setVisibleRowCount(rows);
        this.invalidateSize();
    }

    public boolean isSelected(int index) {
        return this.getComponent().isSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return this.getComponent().getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.getComponent().getSelectedIndices();
    }

    public Object getSelectedValue() {
        return this.getComponent().getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.getComponent().getSelectedValues();
    }

    public void clearSelection() {
        this.getComponent().clearSelection();
    }

    public void setSelected(int index, boolean selected) {
        if (selected) {
            this.getComponent().addSelectionInterval(index, index);
        } else {
            this.getComponent().removeSelectionInterval(index, index);
        }
    }

    public void scrollToItem(int index) {
        this.getComponent().ensureIndexIsVisible(index);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BList.class, new BListDelegate());
    }
}

