/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BTree
extends Widget {
    private TreeModelListener modelListener;
    private int suppressEvents;
    private boolean selectionEnabled;

    public BTree() {
        this(new DefaultTreeModel(new DefaultMutableTreeNode("Tree")));
    }

    public BTree(TreeNode root) {
        this(new DefaultTreeModel(root));
    }

    public BTree(TreeModel model) {
        this.component = this.createComponent(model);
        this.getComponent().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                if (BTree.this.suppressEvents == 0) {
                    BTree.this.dispatchEvent(new SelectionChangedEvent(BTree.this, false));
                }
            }
        });
        final Runnable scrollPaneUpdater = new Runnable(){

            public void run() {
                BTree.this.updateScrollPane();
            }
        };
        this.getComponent().addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                SwingUtilities.invokeLater(scrollPaneUpdater);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                SwingUtilities.invokeLater(scrollPaneUpdater);
            }
        });
        this.modelListener = new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent ev) {
                if (BTree.this.suppressEvents == 0) {
                    BTree.this.dispatchEvent(new ValueChangedEvent(BTree.this));
                }
            }

            public void treeNodesInserted(TreeModelEvent ev) {
            }

            public void treeNodesRemoved(TreeModelEvent ev) {
            }

            public void treeStructureChanged(TreeModelEvent ev) {
            }
        };
        model.addTreeModelListener(this.modelListener);
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).setAsksAllowsChildren(true);
        }
        this.getComponent().setSelectionModel(new BTreeSelectionModel());
        this.selectionEnabled = true;
        this.getComponent().setShowsRootHandles(true);
    }

    protected JTree createComponent(TreeModel model) {
        return new JTree(model);
    }

    public JTree getComponent() {
        return (JTree)this.component;
    }

    public TreeModel getModel() {
        return this.getComponent().getModel();
    }

    public void setModel(TreeModel model) {
        this.getComponent().getModel().removeTreeModelListener(this.modelListener);
        this.getComponent().setModel(model);
        model.addTreeModelListener(this.modelListener);
        this.invalidateSize();
    }

    public TreePath getRootNode() {
        Object root = this.getModel().getRoot();
        if (root == null) {
            return null;
        }
        return new TreePath(root);
    }

    public int getChildNodeCount(TreePath path) {
        return this.getModel().getChildCount(path.getLastPathComponent());
    }

    public TreePath getChildNode(TreePath path, int index) {
        Object child = this.getModel().getChild(path.getLastPathComponent(), index);
        return path.pathByAddingChild(child);
    }

    public TreePath getParentNode(TreePath path) {
        return path.getParentPath();
    }

    public boolean isLeafNode(TreePath path) {
        return this.getModel().isLeaf(path.getLastPathComponent());
    }

    public TreePath addNode(TreePath parent, MutableTreeNode node) {
        return this.addNode(parent, node, this.getChildNodeCount(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreePath addNode(TreePath parent, MutableTreeNode node, int index) {
        MutableTreeNode parentNode = (MutableTreeNode)parent.getLastPathComponent();
        try {
            ++this.suppressEvents;
            parentNode.insert(node, index);
            TreeModel model = this.getModel();
            if (model instanceof DefaultTreeModel) {
                ((DefaultTreeModel)model).nodesWereInserted(parentNode, new int[]{index});
            }
        }
        finally {
            --this.suppressEvents;
        }
        this.updateScrollPane();
        return parent.pathByAddingChild(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(TreePath path) {
        try {
            ++this.suppressEvents;
            MutableTreeNode node = (MutableTreeNode)path.getLastPathComponent();
            TreeNode parentNode = node.getParent();
            int index = parentNode.getIndex(node);
            node.removeFromParent();
            TreeModel model = this.getModel();
            if (model instanceof DefaultTreeModel) {
                ((DefaultTreeModel)model).nodesWereRemoved(parentNode, new int[]{index}, new Object[]{node});
            }
        }
        finally {
            --this.suppressEvents;
        }
        this.updateScrollPane();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.selectionEnabled = enabled;
        if (!enabled) {
            this.clearSelection();
        }
    }

    public boolean isMultipleSelectionEnabled() {
        return this.getComponent().getSelectionModel().getSelectionMode() != 1;
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        this.getComponent().getSelectionModel().setSelectionMode(multiple ? 4 : 1);
    }

    public int getSelectionCount() {
        return this.getComponent().getSelectionCount();
    }

    public TreePath getSelectedNode() {
        return this.getComponent().getSelectionPath();
    }

    public TreePath[] getSelectedNodes() {
        return this.getComponent().getSelectionPaths();
    }

    public boolean isNodeSelected(TreePath path) {
        return this.getComponent().isPathSelected(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeSelected(TreePath path, boolean selected) {
        try {
            ++this.suppressEvents;
            if (selected) {
                this.getComponent().addSelectionPath(path);
            } else {
                this.getComponent().removeSelectionPath(path);
            }
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        try {
            ++this.suppressEvents;
            this.getComponent().clearSelection();
        }
        finally {
            --this.suppressEvents;
        }
    }

    public boolean isEditable() {
        return this.getComponent().isEditable();
    }

    public void setEditable(boolean editable) {
        this.getComponent().setEditable(editable);
    }

    public void editNode(TreePath path) {
        this.getComponent().startEditingAtPath(path);
    }

    public TreePath findNode(Point pos) {
        return this.getComponent().getPathForLocation(pos.x, pos.y);
    }

    public boolean isNodeExpanded(TreePath path) {
        return this.getComponent().isExpanded(path);
    }

    public void setNodeExpanded(TreePath path, boolean expanded) {
        if (expanded) {
            this.getComponent().expandPath(path);
        } else {
            this.getComponent().collapsePath(path);
        }
        this.updateScrollPane();
    }

    public boolean isNodeVisible(TreePath path) {
        return this.getComponent().isVisible(path);
    }

    public void makeNodeVisible(TreePath path) {
        this.getComponent().makeVisible(path);
    }

    public void scrollToNode(TreePath path) {
        Rectangle bounds = this.getComponent().getPathBounds(path);
        if (bounds != null) {
            this.getComponent().scrollRectToVisible(bounds);
        }
    }

    public boolean isRootNodeShown() {
        return this.getComponent().isRootVisible();
    }

    public void setRootNodeShown(boolean shown) {
        this.getComponent().setRootVisible(shown);
    }

    public int getPreferredVisibleRows() {
        return this.getComponent().getVisibleRowCount();
    }

    public void setPreferredVisibleRows(int rows) {
        this.getComponent().setVisibleRowCount(rows);
        this.invalidateSize();
    }

    public TreeCellRenderer getCellRenderer() {
        return this.getComponent().getCellRenderer();
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.getComponent().setCellRenderer(renderer);
    }

    private void updateScrollPane() {
        this.invalidateSize();
        if (this.getParent() instanceof BScrollPane) {
            this.getParent().layoutChildren();
        }
    }

    private class BTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private BTreeSelectionModel() {
        }

        public void setSelectionPaths(TreePath[] path) {
            if (BTree.this.selectionEnabled) {
                super.setSelectionPaths(path);
            }
        }

        public void addSelectionPaths(TreePath[] path) {
            if (BTree.this.selectionEnabled) {
                super.addSelectionPaths(path);
            }
        }

        public void removeSelectionPaths(TreePath[] path) {
            if (BTree.this.selectionEnabled) {
                super.removeSelectionPaths(path);
            }
        }
    }
}

