/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnContainer
extends WidgetContainer {
    private ArrayList<Widget> child;
    private ArrayList<LayoutInfo> childLayout;
    private LayoutInfo defaultLayout;

    public ColumnContainer() {
        this.component = new WidgetContainerPanel(this);
        this.child = new ArrayList();
        this.childLayout = new ArrayList();
        this.defaultLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
    }

    @Override
    public JPanel getComponent() {
        return (JPanel)this.component;
    }

    @Override
    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return this.child.get(i);
    }

    @Override
    public Collection<Widget> getChildren() {
        return new ArrayList<Widget>(this.child);
    }

    @Override
    public void layoutChildren() {
        Dimension size = this.getComponent().getSize();
        Rectangle cell = new Rectangle(0, 0, size.width, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Widget w = this.child.get(i);
            LayoutInfo layout = this.childLayout.get(i);
            if (layout == null) {
                layout = this.defaultLayout;
            }
            Dimension prefSize = layout.getPreferredSize(w);
            cell.height = prefSize.height;
            w.getComponent().setBounds(layout.getWidgetLayout(w, cell));
            if (w instanceof WidgetContainer) {
                ((WidgetContainer)w).layoutChildren();
            }
            cell.y += prefSize.height;
        }
    }

    public void add(Widget widget) {
        this.add(widget, null);
    }

    public void add(Widget widget, LayoutInfo layout) {
        this.add(widget, widget.getParent() == this ? this.getChildCount() - 1 : this.getChildCount(), layout);
    }

    public void add(Widget widget, int index, LayoutInfo layout) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(index, widget);
        this.childLayout.add(index, layout);
        this.getComponent().add(widget.getComponent(), index);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(int index) {
        return this.childLayout.get(index);
    }

    public void setChildLayout(int index, LayoutInfo layout) {
        this.childLayout.set(index, layout);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        int index = this.child.indexOf(widget);
        if (index == -1) {
            return null;
        }
        return this.childLayout.get(index);
    }

    public void setChildLayout(Widget widget, LayoutInfo layout) {
        int index = this.child.indexOf(widget);
        if (index == -1) {
            return;
        }
        this.childLayout.set(index, layout);
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layout) {
        this.defaultLayout = layout;
        this.invalidateSize();
    }

    @Override
    public void remove(Widget widget) {
        int index = this.child.indexOf(widget);
        if (index > -1) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        Widget w = this.child.get(index);
        this.getComponent().remove(w.getComponent());
        this.child.remove(index);
        this.childLayout.remove(index);
        this.removeAsParent(w);
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
        for (int i = 0; i < this.child.size(); ++i) {
            this.removeAsParent(this.child.get(i));
        }
        this.child.clear();
        this.childLayout.clear();
        this.invalidateSize();
    }

    public int getChildIndex(Widget widget) {
        return this.child.indexOf(widget);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minSize = new Dimension(0, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Dimension dim = this.child.get(i).getMinimumSize();
            minSize.height += dim.height;
            if (minSize.width >= dim.width) continue;
            minSize.width = dim.width;
        }
        return minSize;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(0, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Widget w = this.child.get(i);
            LayoutInfo layout = this.childLayout.get(i);
            if (layout == null) {
                layout = this.defaultLayout;
            }
            Dimension dim = layout.getPreferredSize(w);
            prefSize.height += dim.height;
            if (prefSize.width >= dim.width) continue;
            prefSize.width = dim.width;
        }
        return prefSize;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(ColumnContainer.class, new IndexedContainerDelegate(new String[]{"getChild", "getChildLayout"}));
    }
}

