/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.RepaintEvent;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class CustomWidget
extends Widget {
    private boolean opaque;

    public CustomWidget() {
        this.component = new CustomWidgetComponent();
        this.opaque = true;
    }

    public void setMinimumSize(Dimension size) {
        this.getComponent().setMinimumSize(size);
        this.invalidateSize();
    }

    public void setMaximumSize(Dimension size) {
        this.getComponent().setMaximumSize(size);
        this.invalidateSize();
    }

    public void setPreferredSize(Dimension size) {
        this.getComponent().setPreferredSize(size);
        this.invalidateSize();
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    private class CustomWidgetComponent
    extends JComponent {
        private CustomWidgetComponent() {
        }

        public void paintComponent(Graphics g) {
            if (CustomWidget.this.opaque) {
                Dimension size = this.getSize();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, size.width, size.height);
                g.setColor(this.getForeground());
            }
            CustomWidget.this.dispatchEvent(new RepaintEvent(CustomWidget.this, (Graphics2D)g));
        }

        public boolean isOpaque() {
            return CustomWidget.this.opaque;
        }
    }
}

