/*
 * Decompiled with CFR 0.152.
 */
package buoy.xml;

import buoy.event.EventSource;
import buoy.widget.WindowWidget;
import buoy.xml.WidgetLocalization;
import buoy.xml.delegate.EventSourceDelegate;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;

public class WidgetEncoder {
    private static HashMap delegateTable;
    private static EventSourceDelegate defaultDelegate;

    private WidgetEncoder() {
    }

    public static void writeObject(Object obj, OutputStream out) {
        WidgetEncoder.writeObject(obj, out, null);
    }

    public static void writeObject(Object obj, OutputStream out, ExceptionListener listener) {
        ThreadLocal encodingInProgress = null;
        try {
            Field f = WindowWidget.class.getDeclaredField("encodingInProgress");
            f.setAccessible(true);
            encodingInProgress = (ThreadLocal)f.get(null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (encodingInProgress != null) {
            encodingInProgress.set(Boolean.TRUE);
        }
        WidgetXMLEncoder encoder = new WidgetXMLEncoder(out);
        if (listener != null) {
            encoder.setExceptionListener(listener);
        }
        encoder.writeExpression(new Expression(Class.class, "forName", new Object[]{"buoy.xml.WidgetLocalization"}));
        String[] localized = WidgetLocalization.getAllLocalizedStrings();
        for (int i = 0; i < localized.length; ++i) {
            encoder.writeExpression(new Expression(localized[i], WidgetLocalization.class, "getLocalizedString", new Object[]{new String(localized[i])}));
        }
        encoder.writeObject(obj);
        encoder.close();
        if (encodingInProgress != null) {
            encodingInProgress.set(Boolean.FALSE);
        }
    }

    public static void setPersistenceDelegate(Class cls, PersistenceDelegate delegate) {
        delegateTable.put(cls, delegate);
    }

    static {
        defaultDelegate = new EventSourceDelegate();
        delegateTable = new HashMap();
    }

    private static class WidgetXMLEncoder
    extends XMLEncoder {
        public WidgetXMLEncoder(OutputStream out) {
            super(out);
        }

        public PersistenceDelegate getPersistenceDelegate(Class cls) {
            if (cls != null) {
                PersistenceDelegate delegate = (PersistenceDelegate)delegateTable.get(cls);
                if (delegate != null) {
                    return delegate;
                }
                if (EventSource.class.isAssignableFrom(cls)) {
                    return defaultDelegate;
                }
            }
            return super.getPersistenceDelegate(cls);
        }
    }
}

