/*
 * Decompiled with CFR 0.152.
 */
package nik777.xlate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class StringEditor {
    protected Pattern pattern;
    protected String value;
    protected char op;
    protected boolean global;
    protected StringEditor next = null;
    public static final StringEditor EMPTY = new StringEditor(){

        public String edit(String str) {
            return str;
        }

        public void compile() {
            this.next = null;
        }
    };

    public StringEditor() {
    }

    public StringEditor(String cmd) {
        this.compile(cmd);
    }

    public int size() {
        int result = this.pattern != null ? 1 : 0;
        StringEditor nx = this.next;
        while (nx != null) {
            ++result;
            nx = nx.next;
        }
        return result;
    }

    public String edit(String str) {
        if (this.pattern == null) {
            return str;
        }
        String result = "";
        int pos = 0;
        int group = 0;
        Matcher matcher = this.pattern.matcher(str);
        switch (this.op) {
            case 'D': 
            case 'S': 
            case 'd': 
            case 's': {
                if (this.global) {
                    result = matcher.replaceAll(this.value);
                    break;
                }
                result = matcher.replaceFirst(this.value);
                break;
            }
            case 'A': 
            case 'I': 
            case 'a': 
            case 'i': {
                StringBuffer sb = new StringBuffer(str.length() * 2);
                while (matcher.find()) {
                    matcher.appendReplacement(sb, this.value);
                    if (this.global) continue;
                }
                matcher.appendTail(sb);
                result = sb.toString();
                break;
            }
            case 'P': 
            case 'p': {
                StringBuffer sb = this.global ? new StringBuffer(str.length()) : null;
                int max = this.value.length();
                while (pos < max && Character.isDigit(this.value.charAt(pos++))) {
                    group = group * 10 + Character.digit(this.value.charAt(pos), 10);
                }
                while (matcher.find()) {
                    result = matcher.group(group);
                    if (!this.global) break;
                    sb.append(result);
                }
                if (!this.global) break;
                result = sb.toString();
            }
        }
        return this.next != null ? this.next.edit(result) : result;
    }

    public void add(StringEditor editor) {
        if (this.next != null) {
            this.next.add(editor);
        } else {
            this.next = editor;
        }
    }

    public void add(String cmd) {
        if (this.pattern == null) {
            this.compile(cmd);
        } else {
            this.add(new StringEditor(cmd));
        }
    }

    public void compile(String cmd) throws PatternSyntaxException {
        int len = (cmd = cmd.trim()) != null ? cmd.length() : 0;
        char qual = cmd.charAt(0);
        if (qual == 'g' || qual == 'G') {
            this.global = true;
            cmd = cmd.substring(1);
            --len;
        }
        if (len == 2) {
            return;
        }
        this.op = cmd.charAt(0);
        char delim = cmd.charAt(1);
        int cut = cmd.indexOf(delim, 2);
        this.pattern = cut < 0 ? Pattern.compile(cmd.substring(2)) : Pattern.compile(cmd.substring(2, cut));
        switch (this.op) {
            case 'A': 
            case 'I': 
            case 'P': 
            case 'S': 
            case 'a': 
            case 'i': 
            case 'p': 
            case 's': {
                if (cut > 0) {
                    int cut2;
                    this.value = (cut2 = cmd.indexOf(delim, ++cut)) > cut ? cmd.substring(cut, cut2) : cmd.substring(cut);
                    if (this.value.length() == 1 && this.value.charAt(0) == delim) {
                        this.value = "";
                    }
                    cut = cut2;
                } else {
                    this.value = "";
                }
                switch ("aAiI".indexOf(this.op)) {
                    case 0: 
                    case 1: {
                        this.value = "$0" + this.value;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.value = this.value + "$0";
                    }
                }
                break;
            }
            case 'D': 
            case 'd': {
                this.value = "";
                break;
            }
            default: {
                throw new PatternSyntaxException("Unrecognised cmd: " + this.op, cmd, 0);
            }
        }
        this.next = cut > 0 && cut + 2 < len ? new StringEditor(cmd.substring(cut + 1)) : null;
    }
}

