/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Sphere;
import artofillusion.ui.EditingTool;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;

public class CreateSphereTool
extends EditingTool {
    static int counter = 1;
    private boolean shiftDown;
    private Point clickPoint;
    private ObjectInfo objInfo;

    public CreateSphereTool(LayoutWindow fr) {
        super(fr);
        this.initButton("sphere");
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("createSphereTool.helpText"));
    }

    @Override
    public int whichClicks() {
        return 1;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("createSphereTool.tipText");
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        this.clickPoint = e.getPoint();
        this.shiftDown = e.isShiftDown();
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (this.objInfo == null) {
            Scene theScene = ((LayoutWindow)this.theWindow).getScene();
            this.objInfo = new ObjectInfo(new Sphere(1.0, 1.0, 1.0), new CoordinateSystem(), "Sphere " + counter++);
            this.objInfo.addTrack(new PositionTrack(this.objInfo), 0);
            this.objInfo.addTrack(new RotationTrack(this.objInfo), 1);
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            int[] sel = ((LayoutWindow)this.theWindow).getSelectedIndices();
            ((LayoutWindow)this.theWindow).addObject(this.objInfo, undo);
            undo.addCommand(16, new Object[]{sel});
            this.theWindow.setUndoRecord(undo);
            ((LayoutWindow)this.theWindow).setSelection(theScene.getNumObjects() - 1);
        }
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.shiftDown) {
            if (Math.abs(dragPoint.x - this.clickPoint.x) > Math.abs(dragPoint.y - this.clickPoint.y)) {
                dragPoint.y = dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(dragPoint.x - this.clickPoint.x);
            } else {
                dragPoint.x = dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(dragPoint.y - this.clickPoint.y);
            }
        }
        Vec3 v1 = cam.convertScreenToWorld(this.clickPoint, view.getDistToPlane());
        Vec3 v2 = cam.convertScreenToWorld(new Point(dragPoint.x, this.clickPoint.y), view.getDistToPlane());
        Vec3 v3 = cam.convertScreenToWorld(dragPoint, view.getDistToPlane());
        Vec3 orig = v1.plus(v3).times(0.5);
        Vec3 xdir = dragPoint.x < this.clickPoint.x ? v1.minus(v2) : v2.minus(v1);
        Vec3 ydir = dragPoint.y < this.clickPoint.y ? v3.minus(v2) : v2.minus(v3);
        double xsize = xdir.length();
        double ysize = ydir.length();
        xdir = xdir.times(1.0 / xsize);
        ydir = ydir.times(1.0 / ysize);
        Vec3 zdir = xdir.cross(ydir);
        double zsize = Math.min(xsize, ysize);
        ((Sphere)this.objInfo.getObject()).setSize(xsize, ysize, zsize);
        this.objInfo.getCoords().setOrigin(orig);
        this.objInfo.getCoords().setOrientation(zdir, ydir);
        this.objInfo.clearCachedMeshes();
        this.theWindow.setModified();
        this.theWindow.updateImage();
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.objInfo = null;
    }
}

