/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.MaterialPreviewer;
import artofillusion.PluginRegistry;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.object.Object3D;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.ValueChangedEvent;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

public class MaterialMappingDialog
extends BDialog {
    private Object3D obj;
    private Vector<Class> mappings;
    private BComboBox mapChoice;
    private MaterialPreviewer preview;
    private MaterialMapping map;
    private MaterialMapping oldMapping;
    private Widget editingPanel;

    public MaterialMappingDialog(BFrame parent, Object3D obj) {
        super(parent, "Material Mapping", true);
        this.obj = obj;
        this.map = obj.getMaterialMapping();
        this.oldMapping = this.map.duplicate();
        this.mappings = new Vector();
        Material mat = obj.getMaterial();
        for (MaterialMapping mapping : PluginRegistry.getPlugins(MaterialMapping.class)) {
            try {
                Method legalMappingMethod = mapping.getClass().getMethod("legalMapping", Object3D.class, Material.class);
                Boolean result = (Boolean)legalMappingMethod.invoke(null, obj, mat);
                if (!result.booleanValue()) continue;
                this.mappings.add(mapping.getClass());
            }
            catch (Exception legalMappingMethod) {}
        }
        FormContainer content = new FormContainer(new double[]{1.0}, new double[]{1.0, 0.0, 0.0, 0.0});
        this.setContent(BOutline.createEmptyBorder(content, UIUtilities.getStandardDialogInsets()));
        this.preview = new MaterialPreviewer(obj.getTexture(), obj.getMaterial(), obj.duplicate(), 160, 160);
        content.add(this.preview, 0, 0, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(0, 50, 0, 50), null));
        this.preview.setMaterial(obj.getMaterial(), obj.getMaterialMapping());
        RowContainer choiceRow = new RowContainer();
        content.add(choiceRow, 0, 1);
        choiceRow.add(new BLabel(Translate.text("Mapping") + ":"));
        this.mapChoice = new BComboBox();
        choiceRow.add(this.mapChoice);
        for (int i = 0; i < this.mappings.size(); ++i) {
            try {
                Method mtd = this.mappings.get(i).getMethod("getName", new Class[0]);
                this.mapChoice.add((String)mtd.invoke(null, null));
                if (this.mappings.get(i) != this.map.getClass()) continue;
                this.mapChoice.setSelectedIndex(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.mapChoice.addEventLink(ValueChangedEvent.class, (Object)this, "mappingChanged");
        this.editingPanel = this.map.getEditingPanel(obj, this.preview);
        content.add(this.editingPanel, 0, 2);
        RowContainer row = new RowContainer();
        content.add(row, 0, 3);
        row.add(Translate.button("ok", this, "dispose"));
        row.add(Translate.button("cancel", this, "doCancel"));
        this.pack();
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    private void doCancel() {
        this.setMapping(this.oldMapping);
        this.dispose();
    }

    private void mappingChanged() {
        try {
            Class cls = this.mappings.get(this.mapChoice.getSelectedIndex());
            if (cls == this.map.getClass()) {
                return;
            }
            Constructor con = cls.getConstructor(Material.class);
            Material mat = this.obj.getMaterial();
            this.setMapping((MaterialMapping)con.newInstance(mat));
            FormContainer content = (FormContainer)this.getContent();
            content.remove(this.editingPanel);
            this.editingPanel = this.map.getEditingPanel(this.obj, this.preview);
            content.add(this.editingPanel, 0, 2, 2, 1);
            this.pack();
            this.preview.render();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setMapping(MaterialMapping newmap) {
        this.map = newmap;
        this.obj.setMaterial(this.obj.getMaterial(), newmap);
        this.preview.setMaterial(this.obj.getMaterial(), newmap);
        this.preview.render();
    }
}

