/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BCheckBox;
import buoy.widget.Widget;
import java.awt.Point;
import java.util.Vector;

public class MoveObjectTool
extends EditingTool {
    Point clickPoint;
    Vec3[] objectPos;
    Vector<ObjectInfo> toMove;
    ObjectInfo clickedObject;
    boolean dragged;
    boolean applyToChildren = true;

    public MoveObjectTool(EditingWindow fr) {
        super(fr);
        this.initButton("move");
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("moveObjectTool.helpText"));
    }

    @Override
    public int whichClicks() {
        return 2;
    }

    @Override
    public boolean allowSelectionChanges() {
        return true;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("moveObjectTool.tipText");
    }

    @Override
    public void mousePressedOnObject(WidgetMouseEvent e, ViewerCanvas view, int obj) {
        int i;
        Scene theScene = this.theWindow.getScene();
        this.toMove = new Vector();
        this.clickedObject = theScene.getObject(obj);
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        for (i = 0; i < sel.length; ++i) {
            this.toMove.addElement(theScene.getObject(sel[i]));
        }
        this.objectPos = new Vec3[this.toMove.size()];
        for (i = 0; i < this.objectPos.length; ++i) {
            ObjectInfo info = this.toMove.elementAt(i);
            this.objectPos[i] = info.getCoords().getOrigin();
        }
        this.clickPoint = e.getPoint();
        this.dragged = false;
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        CoordinateSystem c;
        int i;
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (!this.dragged) {
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            this.theWindow.setUndoRecord(undo);
            for (i = 0; i < this.toMove.size(); ++i) {
                ObjectInfo info = this.toMove.elementAt(i);
                c = info.getCoords();
                undo.addCommand(1, new Object[]{c, c.duplicate()});
            }
            this.dragged = true;
        }
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (e.isShiftDown() && !e.isControlDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
        }
        Vec3 v = e.isControlDown() ? cam.getCameraCoordinates().getZDirection().times((double)(-dy) * 0.01) : cam.findDragVector(this.clickedObject.getCoords().getOrigin(), dx, dy);
        for (i = 0; i < this.toMove.size(); ++i) {
            ObjectInfo info = this.toMove.elementAt(i);
            c = info.getCoords();
            c.setOrigin(this.objectPos[i].plus(v));
        }
        this.theWindow.setModified();
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("moveObjectTool.dragText", (Object)((double)Math.round(v.x * 100000.0) / 100000.0 + ", " + (double)Math.round(v.y * 100000.0) / 100000.0 + ", " + (double)Math.round(v.z * 100000.0) / 100000.0)));
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.theWindow.getScene().applyTracksAfterModification(this.toMove);
        this.theWindow.setHelpText(Translate.text("moveObjectTool.helpText"));
        this.toMove = null;
        this.objectPos = null;
        this.theWindow.updateImage();
    }

    @Override
    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
        int i;
        Vec3 v;
        double dy;
        double dx;
        Scene theScene = this.theWindow.getScene();
        Camera cam = view.getCamera();
        int key = e.getKeyCode();
        if (key == 38) {
            dx = 0.0;
            dy = -1.0;
        } else if (key == 40) {
            dx = 0.0;
            dy = 1.0;
        } else if (key == 37) {
            dx = -1.0;
            dy = 0.0;
        } else if (key == 39) {
            dx = 1.0;
            dy = 0.0;
        } else {
            return;
        }
        e.consume();
        int[] sel = this.applyToChildren ? theScene.getSelectionWithChildren() : theScene.getSelection();
        if (sel.length == 0) {
            return;
        }
        if (view.getSnapToGrid()) {
            double scale = view.getGridSpacing() * view.getScale();
            if (!e.isAltDown()) {
                scale /= (double)view.getSnapToSubdivisions();
            }
            dx *= scale;
            dy *= scale;
        } else if (e.isAltDown()) {
            dx *= 10.0;
            dy *= 10.0;
        }
        CoordinateSystem cameraCoords = cam.getCameraCoordinates();
        if (e.isControlDown()) {
            v = cameraCoords.getZDirection().times(-dy * 0.01);
        } else {
            Vec3 origin = theScene.getObject(sel[0]).getCoords().getOrigin();
            if (Math.abs(origin.minus(cameraCoords.getOrigin()).dot(cameraCoords.getZDirection())) < 1.0E-10) {
                origin = origin.plus(cameraCoords.getZDirection().times(cam.getClipDistance()));
            }
            v = cam.findDragVector(origin, dx, dy);
        }
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        this.theWindow.setUndoRecord(undo);
        this.toMove = new Vector();
        for (i = 0; i < sel.length; ++i) {
            this.toMove.addElement(theScene.getObject(sel[i]));
        }
        for (i = 0; i < this.toMove.size(); ++i) {
            CoordinateSystem c = this.toMove.elementAt(i).getCoords();
            undo.addCommand(1, new Object[]{c, c.duplicate()});
            c.setOrigin(c.getOrigin().plus(v));
        }
        this.theWindow.getScene().applyTracksAfterModification(this.toMove);
        this.theWindow.updateImage();
    }

    @Override
    public void iconDoubleClicked() {
        BCheckBox childrenBox = new BCheckBox(Translate.text("applyToUnselectedChildren"), this.applyToChildren);
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("moveToolTitle"), new Widget[]{childrenBox}, new String[]{null});
        if (!dlg.clickedOk()) {
            return;
        }
        this.applyToChildren = childrenBox.getState();
    }
}

