/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.MeshEditingTool;
import artofillusion.ui.NinePointManipulator;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;

public class RotateMeshTool
extends MeshEditingTool {
    private boolean dragInProgress;
    private boolean selectionCanChange;
    private Point clickPoint;
    private Vec3 rotCenter;
    private Vec3[] baseVertPos;
    private int hdirection;
    private int vdirection;
    private int whichAxis;
    private UndoRecord undo;
    private final NinePointManipulator manipulator;
    private int[] lastSelectionDistance;
    public static final int HANDLE_SIZE = 5;
    private static final double DRAG_SCALE = Math.PI / 360;
    private static final int XAXIS = 0;
    private static final int YAXIS = 1;
    private static final int ZAXIS = 2;

    public RotateMeshTool(EditingWindow fr, MeshEditController controller, boolean only2D) {
        super(fr, controller);
        this.initButton("rotatePoints");
        this.manipulator = only2D ? new NinePointManipulator(new Image[]{NinePointManipulator.ROTATE_TOPLEFT, null, NinePointManipulator.ROTATE_TOPRIGHT, null, null, null, NinePointManipulator.ROTATE_BOTTOMLEFT, null, NinePointManipulator.ROTATE_BOTTOMRIGHT}) : new NinePointManipulator(new Image[]{NinePointManipulator.ROTATE_TOPLEFT, NinePointManipulator.ROTATE_TOP, NinePointManipulator.ROTATE_TOPRIGHT, NinePointManipulator.ROTATE_LEFT, null, NinePointManipulator.ROTATE_RIGHT, NinePointManipulator.ROTATE_BOTTOMLEFT, NinePointManipulator.ROTATE_BOTTOM, NinePointManipulator.ROTATE_BOTTOMRIGHT});
        this.manipulator.addEventLink(NinePointManipulator.HandlePressedEvent.class, (Object)this, "handlePressed");
        this.manipulator.addEventLink(NinePointManipulator.HandleDraggedEvent.class, (Object)this, "handleDragged");
        this.manipulator.addEventLink(NinePointManipulator.HandleReleasedEvent.class, (Object)this, "handleReleased");
    }

    @Override
    public void activate() {
        super.activate();
        this.lastSelectionDistance = null;
        this.checkForSelectionChanged();
    }

    @Override
    public int whichClicks() {
        return 1;
    }

    @Override
    public boolean allowSelectionChanges() {
        return this.selectionCanChange;
    }

    private void checkForSelectionChanged() {
        int[] selected = this.controller.getSelectionDistance();
        boolean changed = this.lastSelectionDistance == null || this.lastSelectionDistance.length != selected.length;
        for (int i = 0; !changed && i < selected.length; ++i) {
            changed = this.lastSelectionDistance[i] != selected[i];
        }
        this.lastSelectionDistance = selected;
        if (!changed) {
            return;
        }
        Camera cam = this.theWindow.getView().getCamera();
        BoundingBox bounds = this.findSelectionBounds(cam);
        if (bounds != null) {
            this.rotCenter = new Vec3((bounds.minx + bounds.maxx) / 2.0, (bounds.miny + bounds.maxy) / 2.0, (bounds.minz + bounds.maxz) / 2.0);
            this.rotCenter = cam.getViewToWorld().times(this.rotCenter);
        }
    }

    @Override
    public String getToolTipText() {
        return Translate.text("rotateMeshTool.tipText");
    }

    @Override
    public void drawOverlay(ViewerCanvas view) {
        this.checkForSelectionChanged();
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        if (!this.dragInProgress) {
            if (selectionBounds != null) {
                this.manipulator.draw(view, selectionBounds);
                this.theWindow.setHelpText(Translate.text("rotateMeshTool.helpText"));
            } else {
                this.theWindow.setHelpText(Translate.text("rotateMeshTool.errorText"));
            }
        }
        if (selectionBounds != null) {
            Vec2 p = view.getCamera().getWorldToScreen().timesXY(this.rotCenter);
            int px = (int)p.x;
            int py = (int)p.y;
            view.drawLine(new Point(px - 5, py - 5), new Point(px + 5, py + 5), ViewerCanvas.handleColor);
            view.drawLine(new Point(px - 5, py + 5), new Point(px + 5, py - 5), ViewerCanvas.handleColor);
        }
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        if (e.isControlDown()) {
            double depth = view.getCamera().getWorldToView().times((Vec3)this.rotCenter).z;
            this.rotCenter = view.getCamera().convertScreenToWorld(e.getPoint(), depth);
            this.selectionCanChange = false;
            view.repaint();
            return;
        }
        BoundingBox selectionBounds = this.findSelectionBounds(view.getCamera());
        this.dragInProgress = false;
        if (selectionBounds != null) {
            this.dragInProgress = this.manipulator.mousePressed(e, view, selectionBounds);
        }
        this.selectionCanChange = !this.dragInProgress;
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseDragged(e, view);
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.manipulator.mouseReleased(e, view);
    }

    protected void handlePressed(NinePointManipulator.HandlePressedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        this.clickPoint = ev.getMouseEvent().getPoint();
        NinePointManipulator.HandlePosition handle = ev.getHandle();
        if (!handle.isEast() && !handle.isWest()) {
            this.whichAxis = 0;
            this.hdirection = 0;
            this.vdirection = -1;
        } else if (!handle.isNorth() && !handle.isSouth()) {
            this.whichAxis = 1;
            this.vdirection = 0;
            this.hdirection = 1;
        } else {
            this.whichAxis = 2;
            this.vdirection = handle.isWest() ? -1 : 1;
            this.hdirection = handle.isNorth() ? 1 : -1;
        }
        this.baseVertPos = mesh.getVertexPositions();
    }

    protected void handleDragged(NinePointManipulator.HandleDraggedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = ev.getMouseEvent().getPoint();
        if (this.undo == null) {
            this.undo = new UndoRecord(this.theWindow, false, 13, new Object[]{mesh, mesh.getVertexPositions()});
        }
        double angle = Math.PI / 360 * (double)((dragPoint.x - this.clickPoint.x) * this.hdirection + (dragPoint.y - this.clickPoint.y) * this.vdirection);
        Vec3[] v = this.findRotatedPositions(this.baseVertPos, angle, (MeshViewer)ev.getView());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
        this.theWindow.setHelpText(Translate.text("rotateMeshTool.dragText", (Object)Double.toString((double)Math.round(angle * 100000.0 * 180.0 / Math.PI) / 100000.0)));
    }

    protected void handleReleased(NinePointManipulator.HandleReleasedEvent ev) {
        Mesh mesh = (Mesh)((Object)this.controller.getObject().getObject());
        Point dragPoint = ev.getMouseEvent().getPoint();
        double angle = Math.PI / 360 * (double)((dragPoint.x - this.clickPoint.x) * this.hdirection + (dragPoint.y - this.clickPoint.y) * this.vdirection);
        if (this.undo != null) {
            this.theWindow.setUndoRecord(this.undo);
        }
        Vec3[] v = this.findRotatedPositions(this.baseVertPos, angle, (MeshViewer)ev.getView());
        mesh.setVertexPositions(v);
        this.controller.objectChanged();
        this.theWindow.updateImage();
        this.undo = null;
        this.baseVertPos = null;
        this.dragInProgress = false;
    }

    private Vec3[] findRotatedPositions(Vec3[] vert, double angle, MeshViewer view) {
        int i;
        Vec3[] v = new Vec3[vert.length];
        int[] selected = this.controller.getSelectionDistance();
        Camera cam = view.getCamera();
        CoordinateSystem coords = view.getDisplayCoordinates();
        Vec3 xdir = cam.getWorldToView().timesDirection(Vec3.vx());
        Vec3 ydir = cam.getWorldToView().timesDirection(Vec3.vy());
        Vec3 zdir = cam.getWorldToView().timesDirection(Vec3.vz());
        if (xdir.cross(ydir).dot(zdir) < 0.0) {
            angle = -angle;
        }
        Mat4 m = coords.fromLocal();
        m = Mat4.translation(-this.rotCenter.x, -this.rotCenter.y, -this.rotCenter.z).times(m);
        Vec3 axis = this.whichAxis == 0 ? cam.getViewToWorld().timesDirection(Vec3.vx()) : (this.whichAxis == 1 ? cam.getViewToWorld().timesDirection(Vec3.vy()) : cam.getViewToWorld().timesDirection(Vec3.vz()));
        m = Mat4.axisRotation(axis, angle).times(m);
        m = Mat4.translation(this.rotCenter.x, this.rotCenter.y, this.rotCenter.z).times(m);
        m = coords.toLocal().times(m);
        for (i = 0; i < vert.length; ++i) {
            v[i] = selected[i] == 0 ? m.times(vert[i]).minus(vert[i]) : new Vec3();
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        for (i = 0; i < vert.length; ++i) {
            v[i].add(vert[i]);
        }
        return v;
    }
}

