/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.WidgetMouseEvent;
import java.awt.Point;

public class RotateViewTool
extends EditingTool {
    private static final double DRAG_SCALE = 0.01;
    private Point clickPoint;
    private Mat4 viewToWorld;
    private boolean controlDown;
    private CoordinateSystem oldCoords;
    private Vec3 rotationCenter;
    private double angle;
    private double distToRot;
    private double xAngle;
    private double yAngle;
    private double r;
    private double fwMax;
    private double fwMin;
    private Camera camera;
    private int selectedNavigation;
    private Point viewCenter;
    private Point p0;
    private Point p1;

    public RotateViewTool(EditingWindow fr) {
        super(fr);
        this.initButton("rotateView");
    }

    @Override
    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("rotateViewTool.helpText"));
    }

    @Override
    public int whichClicks() {
        return 1;
    }

    @Override
    public boolean hilightSelection() {
        return true;
    }

    @Override
    public String getToolTipText() {
        return Translate.text("rotateViewTool.tipText");
    }

    @Override
    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        this.camera = view.getCamera();
        this.selectedNavigation = view.getNavigationMode();
        this.oldCoords = this.camera.getCameraCoordinates().duplicate();
        view.setRotationCenter(this.oldCoords.getOrigin().plus(this.oldCoords.getZDirection().times(view.getDistToPlane())));
        this.controlDown = e.isControlDown();
        this.clickPoint = e.getPoint();
        this.viewToWorld = this.camera.getViewToWorld();
        this.rotationCenter = view.getRotationCenter();
        this.distToRot = this.oldCoords.getOrigin().minus(this.rotationCenter).length();
        if (this.theWindow != null && this.theWindow.getToolPalette().getSelectedTool() == this && UIUtilities.mouseButtonOne(e)) {
            if (view.getNavigationMode() > 3) {
                view.setNavigationMode(0);
            } else if (view.getNavigationMode() > 1) {
                view.setNavigationMode(view.getNavigationMode() - 2, true);
            }
        }
        view.mouseDown = true;
        view.rotating = true;
    }

    @Override
    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        if (e.getPoint() != this.clickPoint && view.getBoundCamera() == null) {
            view.setOrientation(Integer.MAX_VALUE);
        }
        if (this.theWindow != null && this.theWindow.getToolPalette().getSelectedTool() == this && UIUtilities.mouseButtonOne(e)) {
            if (view.getNavigationMode() == 0) {
                this.dragRotateSpace(e, view);
            } else {
                Vec3 zD = this.oldCoords.getZDirection();
                this.fwMax = 1.5707963267948966 + Math.asin(zD.y);
                this.fwMin = -1.5707963267948966 + Math.asin(zD.y);
                this.dragRotateLandscape(e, view);
            }
        } else {
            switch (view.getNavigationMode()) {
                case 0: {
                    this.dragRotateSpace(e, view);
                    break;
                }
                case 1: {
                    Vec3 zD = this.oldCoords.getZDirection();
                    this.fwMax = 1.5707963267948966 + Math.asin(zD.y);
                    this.fwMin = -1.5707963267948966 + Math.asin(zD.y);
                    this.dragRotateLandscape(e, view);
                    break;
                }
                case 2: {
                    this.dragRotateTravelSpace(e, view);
                    break;
                }
                case 3: {
                    this.dragRotateTravelLandscape(e, view);
                    break;
                }
            }
        }
        if (view.getBoundCamera() != null) {
            view.getBoundCamera().getCoords().copyCoords(view.getCamera().getCameraCoordinates());
        }
        view.frustumShape.update();
        if (ArtOfIllusion.getPreferences().getDrawActiveFrustum() || ArtOfIllusion.getPreferences().getDrawCameraFrustum() && view.getBoundCamera() != null) {
            this.theWindow.updateImage();
        } else {
            view.repaint();
        }
        view.viewChanged(false);
    }

    private void dragRotateTravelSpace(WidgetMouseEvent e, ViewerCanvas view) {
        Vec3 axis;
        Point dragPoint = e.getPoint();
        CoordinateSystem c = this.oldCoords.duplicate();
        Vec3 location = c.getOrigin();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            if (e.isShiftDown()) {
                this.rotateSpace(e, view, this.clickPoint);
                return;
            }
            view.tilting = true;
            this.tilt(e, view, this.clickPoint);
            return;
        }
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                axis = this.viewToWorld.timesDirection(Vec3.vy());
                this.angle = (double)dx * 0.01 / view.getCamera().getDistToScreen();
            } else {
                axis = this.viewToWorld.timesDirection(Vec3.vx());
                this.angle = (double)(-dy) * 0.01 / view.getCamera().getDistToScreen();
            }
        } else {
            axis = new Vec3((double)(-dy) * 0.01, (double)dx * 0.01, 0.0);
            this.angle = axis.length() / view.getCamera().getDistToScreen();
            axis.normalize();
            axis = this.viewToWorld.timesDirection(axis);
        }
        if (this.angle != 0.0) {
            c.transformCoordinates(Mat4.translation(-location.x, -location.y, -location.z));
            c.transformCoordinates(Mat4.axisRotation(axis, this.angle));
            c.transformCoordinates(Mat4.translation(location.x, location.y, location.z));
            view.getCamera().setCameraCoordinates(c);
            Vec3 cc = c.getOrigin();
            view.setRotationCenter(cc.plus(c.getZDirection().times(view.getDistToPlane())));
        }
    }

    private void dragRotateSpace(WidgetMouseEvent e, ViewerCanvas view) {
        Vec3 axis;
        Point dragPoint = e.getPoint();
        CoordinateSystem c = this.oldCoords.duplicate();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            if (e.isShiftDown()) {
                this.panSpace(e, view, this.clickPoint);
                return;
            }
            view.tilting = true;
            this.tilt(e, view, this.clickPoint);
            return;
        }
        if (e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                axis = this.viewToWorld.timesDirection(Vec3.vy());
                this.angle = (double)dx * 0.01;
            } else {
                axis = this.viewToWorld.timesDirection(Vec3.vx());
                this.angle = (double)(-dy) * 0.01;
            }
        } else {
            axis = new Vec3((double)(-dy) * 0.01, (double)dx * 0.01, 0.0);
            this.angle = axis.length();
            axis = axis.times(1.0 / this.angle);
            axis = this.viewToWorld.timesDirection(axis);
        }
        if (this.angle != 0.0) {
            c.transformCoordinates(Mat4.translation(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z));
            c.transformCoordinates(Mat4.axisRotation(axis, -this.angle));
            c.transformCoordinates(Mat4.translation(this.rotationCenter.x, this.rotationCenter.y, this.rotationCenter.z));
            view.getCamera().setCameraCoordinates(c);
        }
    }

    private void dragRotateLandscape(WidgetMouseEvent e, ViewerCanvas view) {
        double dragAngleFw;
        Mat4 rotation;
        Vec3 vertical = new Vec3(0.0, 1.0, 0.0);
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (!this.controlDown && e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                rotation = Mat4.axisRotation(vertical, (double)(-dx) * 0.01);
            } else {
                dragAngleFw = (double)dy * 0.01;
                if (dragAngleFw > this.fwMax) {
                    dragAngleFw = this.fwMax;
                }
                if (dragAngleFw < this.fwMin) {
                    dragAngleFw = this.fwMin;
                }
                rotation = Mat4.axisRotation(this.viewToWorld.timesDirection(Vec3.vx()), dragAngleFw);
            }
        } else {
            if (this.controlDown && e.isShiftDown()) {
                this.panLandscape(e, view, this.clickPoint, vertical);
                return;
            }
            dragAngleFw = (double)dy * 0.01;
            if (dragAngleFw > this.fwMax) {
                dragAngleFw = this.fwMax;
            }
            if (dragAngleFw < this.fwMin) {
                dragAngleFw = this.fwMin;
            }
            rotation = Mat4.axisRotation(this.viewToWorld.timesDirection(Vec3.vx()), dragAngleFw);
            rotation = Mat4.axisRotation(vertical, (double)(-dx) * 0.01).times(rotation);
        }
        if (!rotation.equals(Mat4.identity())) {
            CoordinateSystem c = this.oldCoords.duplicate();
            c.transformCoordinates(Mat4.translation(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z));
            c.transformCoordinates(rotation);
            c.transformCoordinates(Mat4.translation(this.rotationCenter.x, this.rotationCenter.y, this.rotationCenter.z));
            view.getCamera().setCameraCoordinates(c);
        }
    }

    private void dragRotateTravelLandscape(WidgetMouseEvent e, ViewerCanvas view) {
        Mat4 rotation;
        Vec3 vertical = new Vec3(0.0, 1.0, 0.0);
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        double dts = view.getCamera().getDistToScreen();
        if (!this.controlDown && e.isShiftDown()) {
            if (Math.abs(dx) > Math.abs(dy)) {
                rotation = Mat4.axisRotation(vertical, (double)dx * 0.01 / this.distToRot);
            } else {
                double dragAngleFw = (double)(-dy) * 0.01 / this.distToRot;
                if (dragAngleFw > Math.PI) {
                    dragAngleFw = Math.PI;
                }
                if (dragAngleFw < -Math.PI) {
                    dragAngleFw = -Math.PI;
                }
                rotation = Mat4.axisRotation(this.viewToWorld.timesDirection(Vec3.vx()), dragAngleFw);
            }
        } else {
            if (this.controlDown && e.isShiftDown()) {
                this.rotateLandscape(e, view, this.clickPoint, vertical);
                return;
            }
            if (view.getBoundCamera() != null && view.getBoundCamera().getObject() instanceof SceneCamera) {
                int yp = view.getBounds().height / 2;
                double fa = 1.5707963267948966 - ((SceneCamera)view.getBoundCamera().getObject()).getFieldOfView() / 2.0 / 180.0 * Math.PI;
                dts = Math.tan(fa) * (double)yp / 100.0;
            }
            rotation = Mat4.axisRotation(this.viewToWorld.timesDirection(Vec3.vx()), (double)(-dy) * 0.01 / dts);
            rotation = Mat4.axisRotation(vertical, (double)dx * 0.01 / dts).times(rotation);
        }
        if (!rotation.equals(Mat4.identity())) {
            CoordinateSystem c = this.oldCoords.duplicate();
            Vec3 cc = c.getOrigin();
            c.transformCoordinates(Mat4.translation(-cc.x, -cc.y, -cc.z));
            c.transformCoordinates(rotation);
            if (c.getUpDirection().y < 0.0) {
                Vec3 upD = new Vec3(c.getUpDirection().x, 0.0, c.getUpDirection().z);
                upD.normalize();
                Vec3 zD = new Vec3();
                zD.y = c.getZDirection().y < 0.0 ? -1.0 : 1.0;
                c.setOrientation(zD, upD);
            } else {
                c.transformCoordinates(Mat4.translation(cc.x, cc.y, cc.z));
            }
            view.getCamera().setCameraCoordinates(c);
            view.setRotationCenter(cc.plus(c.getZDirection().times(view.getDistToPlane())));
        }
    }

    @Override
    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        view.mouseDown = false;
        view.tilting = false;
        view.rotating = false;
        view.setNavigationMode(this.selectedNavigation);
        Point dragPoint = e.getPoint();
        if (this.theWindow != null) {
            ObjectInfo bound = view.getBoundCamera();
            if (bound != null) {
                bound.getCoords().copyCoords(view.getCamera().getCameraCoordinates());
                UndoRecord undo = new UndoRecord(this.theWindow, false, 1, new Object[]{bound.getCoords(), this.oldCoords});
                this.moveChildren(bound, bound.getCoords().fromLocal().times(this.oldCoords.toLocal()), undo);
                this.theWindow.setUndoRecord(undo);
            }
            this.theWindow.updateImage();
        }
        if (dragPoint.x == this.clickPoint.x && dragPoint.y == this.clickPoint.y) {
            view.centerToPoint(dragPoint);
        }
        view.viewChanged(false);
    }

    private void moveChildren(ObjectInfo parent, Mat4 transform, UndoRecord undo) {
        for (int i = 0; i < parent.getChildren().length; ++i) {
            CoordinateSystem coords = parent.getChildren()[i].getCoords();
            CoordinateSystem oldCoords = coords.duplicate();
            coords.transformCoordinates(transform);
            undo.addCommand(1, new Object[]{coords, oldCoords});
            this.moveChildren(parent.getChildren()[i], transform, undo);
        }
    }

    private void tilt(WidgetMouseEvent e, ViewerCanvas view, Point clickPoint) {
        int d = Math.min(view.getBounds().width, view.getBounds().height);
        int cx = view.getBounds().width / 2;
        int cy = view.getBounds().height / 2;
        this.viewCenter = new Point(cx, cy);
        double aClick = Math.atan2(clickPoint.y - cy, clickPoint.x - cx);
        Point dragPoint = e.getPoint();
        double aDrag = Math.atan2(dragPoint.y - cy, dragPoint.x - cx);
        Vec3 axis = this.viewToWorld.timesDirection(Vec3.vz());
        this.angle = aDrag - aClick;
        CoordinateSystem c = this.oldCoords.duplicate();
        c.transformCoordinates(Mat4.translation(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z));
        c.transformCoordinates(Mat4.axisRotation(axis, -this.angle));
        c.transformCoordinates(Mat4.translation(this.rotationCenter.x, this.rotationCenter.y, this.rotationCenter.z));
        view.getCamera().setCameraCoordinates(c);
    }

    private void panSpace(WidgetMouseEvent e, ViewerCanvas view, Point clickPoint) {
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - clickPoint.x;
        int dy = dragPoint.y - clickPoint.y;
        Vec3 axis = new Vec3((double)(-dy) * 0.01, (double)dx * 0.01, 0.0);
        double angle = axis.length() / view.getCamera().getDistToScreen();
        axis.normalize();
        axis = this.viewToWorld.timesDirection(axis);
        CoordinateSystem c = this.oldCoords.duplicate();
        Vec3 cc = c.getOrigin();
        c.transformCoordinates(Mat4.translation(-cc.x, -cc.y, -cc.z));
        c.transformCoordinates(Mat4.axisRotation(axis, angle));
        c.transformCoordinates(Mat4.translation(cc.x, cc.y, cc.z));
        view.getCamera().setCameraCoordinates(c);
        view.setRotationCenter(cc.plus(c.getZDirection().times(view.getDistToPlane())));
    }

    private void panLandscape(WidgetMouseEvent e, ViewerCanvas view, Point clickPoint, Vec3 vertical) {
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - clickPoint.x;
        int dy = dragPoint.y - clickPoint.y;
        double dts = this.camera.getDistToScreen();
        if (view.getBoundCamera() != null && view.getBoundCamera().getObject() instanceof SceneCamera) {
            int yp = view.getBounds().height / 2;
            double fa = 1.5707963267948966 - ((SceneCamera)view.getBoundCamera().getObject()).getFieldOfView() / 2.0 / 180.0 * Math.PI;
            dts = Math.tan(fa) * (double)yp / 100.0;
        }
        Mat4 rotation = Mat4.axisRotation(this.viewToWorld.timesDirection(Vec3.vx()), (double)(-dy) * 0.01 / dts);
        rotation = Mat4.axisRotation(vertical, (double)dx * 0.01 / dts).times(rotation);
        if (!rotation.equals(Mat4.identity())) {
            CoordinateSystem c = this.oldCoords.duplicate();
            Vec3 cc = c.getOrigin();
            c.transformCoordinates(Mat4.translation(-cc.x, -cc.y, -cc.z));
            c.transformCoordinates(rotation);
            if (c.getUpDirection().y < 0.0) {
                Vec3 upD = new Vec3(c.getUpDirection().x, 0.0, c.getUpDirection().z);
                upD.normalize();
                Vec3 zD = new Vec3();
                zD.y = c.getZDirection().y < 0.0 ? -1.0 : 1.0;
                Vec3 cp = cc.plus(zD.times(-this.distToRot));
                c.setOrientation(zD, upD);
                c.setOrigin(cp);
            } else {
                c.transformCoordinates(Mat4.translation(cc.x, cc.y, cc.z));
            }
            this.camera.setCameraCoordinates(c);
            view.setRotationCenter(cc.plus(c.getZDirection().times(view.getDistToPlane())));
        }
    }

    private void rotateSpace(WidgetMouseEvent e, ViewerCanvas view, Point clickPoint) {
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - clickPoint.x;
        int dy = dragPoint.y - clickPoint.y;
        Vec3 axis = new Vec3((double)(-dy) * 0.01, (double)dx * 0.01, 0.0);
        double angle = -axis.length();
        axis.normalize();
        axis = this.viewToWorld.timesDirection(axis);
        CoordinateSystem c = this.oldCoords.duplicate();
        c.transformCoordinates(Mat4.translation(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z));
        c.transformCoordinates(Mat4.axisRotation(axis, angle));
        c.transformCoordinates(Mat4.translation(this.rotationCenter.x, this.rotationCenter.y, this.rotationCenter.z));
        view.getCamera().setCameraCoordinates(c);
    }

    private void rotateLandscape(WidgetMouseEvent e, ViewerCanvas view, Point clickPoint, Vec3 vertical) {
        Point dragPoint = e.getPoint();
        int dx = dragPoint.x - clickPoint.x;
        int dy = dragPoint.y - clickPoint.y;
        Mat4 rotation = Mat4.axisRotation(this.viewToWorld.timesDirection(Vec3.vx()), (double)dy * 0.01);
        rotation = Mat4.axisRotation(vertical, (double)(-dx) * 0.01).times(rotation);
        if (!rotation.equals(Mat4.identity())) {
            CoordinateSystem c = this.oldCoords.duplicate();
            c.transformCoordinates(Mat4.translation(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z));
            c.transformCoordinates(rotation);
            if (c.getUpDirection().y < 0.0) {
                Vec3 upD = new Vec3(c.getUpDirection().x, 0.0, c.getUpDirection().z);
                upD.normalize();
                Vec3 zD = new Vec3();
                zD.y = c.getZDirection().y < 0.0 ? -1.0 : 1.0;
                Vec3 cp = this.rotationCenter.plus(zD.times(-this.distToRot));
                c.setOrientation(zD, upD);
                c.setOrigin(cp);
            } else {
                c.transformCoordinates(Mat4.translation(this.rotationCenter.x, this.rotationCenter.y, this.rotationCenter.z));
            }
            view.getCamera().setCameraCoordinates(c);
        }
    }

    @Override
    public void drawOverlay(ViewerCanvas view) {
        if (this.theWindow != null && view.tilting && ArtOfIllusion.getPreferences().getShowTiltDial()) {
            int i;
            this.r = 0.45 * (double)Math.min(view.getBounds().width, view.getBounds().height);
            for (i = 0; i < 4; ++i) {
                view.drawLine(this.viewCenter, 1.5707963267948966 * (double)i + this.angle, 0.0, this.r, ViewerCanvas.cueIdle);
            }
            view.drawLine(this.viewCenter, -1.5707963267948966, this.r, this.r * 1.1, ViewerCanvas.red);
            view.drawLine(this.viewCenter, 1.5707963267948966, this.r, this.r * 1.1, ViewerCanvas.red);
            view.drawLine(this.viewCenter, Math.PI, this.r, this.r * 1.1, ViewerCanvas.blue);
            view.drawLine(this.viewCenter, 0.0, this.r, this.r * 1.1, ViewerCanvas.blue);
            for (i = 0; i < 24; ++i) {
                view.drawLine(this.viewCenter, 0.2617993877991494 * (double)i + this.angle, this.r * 0.95, this.r, ViewerCanvas.cueActive);
            }
            view.drawCircle(this.viewCenter, this.r, 48, ViewerCanvas.cueActive);
        }
    }
}

