/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.LayoutWindow;
import artofillusion.ListChangeListener;
import artofillusion.PluginRegistry;
import artofillusion.SafeFileOutputStream;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ConstraintTrack;
import artofillusion.animation.IKTrack;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.ProceduralPositionTrack;
import artofillusion.animation.ProceduralRotationTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.animation.Track;
import artofillusion.image.ExternalImage;
import artofillusion.image.ImageMap;
import artofillusion.image.MIPMappedImage;
import artofillusion.material.Material;
import artofillusion.material.UniformMaterial;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.UniformTexture;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.util.SearchlistClassLoader;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Scene {
    private Vector<ObjectInfo> objects;
    private Vector<Material> materials;
    private Vector<Texture> textures;
    private Vector<ImageMap> images;
    private Vector<Integer> selection;
    private Vector<ListChangeListener> textureListeners;
    private Vector<ListChangeListener> materialListeners;
    private HashMap<String, Object> metadataMap;
    private HashMap<ObjectInfo, Integer> objectIndexMap;
    private RGBColor ambientColor;
    private RGBColor environColor;
    private RGBColor fogColor;
    private Texture environTexture;
    private TextureMapping environMapping;
    private int gridSubdivisions;
    private int environMode;
    private int framesPerSecond;
    private int nextID;
    private double fogDist;
    private double gridSpacing;
    private double time;
    private boolean fog;
    private boolean showGrid;
    private boolean snapToGrid;
    private boolean errorsLoading;
    private String name;
    private String directory;
    private ParameterValue[] environParamValue;
    private StringBuffer loadingErrors;
    public static final int HANDLE_SIZE = 4;
    public static final int ENVIRON_SOLID = 0;
    public static final int ENVIRON_DIFFUSE = 1;
    public static final int ENVIRON_EMISSIVE = 2;
    private static final byte[] FILE_PREFIX = new byte[]{65, 111, 73, 83, 99, 101, 110, 101};

    public Scene() {
        UniformTexture defTex = new UniformTexture();
        this.objects = new Vector();
        this.materials = new Vector();
        this.textures = new Vector();
        this.images = new Vector();
        this.selection = new Vector();
        this.metadataMap = new HashMap();
        this.textureListeners = new Vector();
        this.materialListeners = new Vector();
        defTex.setName("Default Texture");
        this.textures.addElement(defTex);
        this.ambientColor = new RGBColor(0.3f, 0.3f, 0.3f);
        this.environColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.environTexture = defTex;
        this.environMapping = defTex.getDefaultMapping(new Sphere(1.0, 1.0, 1.0));
        this.environParamValue = new ParameterValue[0];
        this.environMode = 0;
        this.fogColor = new RGBColor(0.3f, 0.3f, 0.3f);
        this.fogDist = 20.0;
        this.fog = false;
        this.framesPerSecond = 30;
        this.nextID = 1;
        this.snapToGrid = false;
        this.showGrid = false;
        this.gridSpacing = 1.0;
        this.gridSubdivisions = 10;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String newDir) {
        this.directory = newDir;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double t) {
        this.time = t;
        boolean[] processed = new boolean[this.objects.size()];
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = this.objects.elementAt(i);
            this.applyTracksToObject(info, processed, null, i);
        }
        for (ObjectInfo obj : this.objects) {
            obj.getObject().sceneChanged(obj, this);
        }
    }

    public void applyTracksToObject(ObjectInfo info) {
        this.applyTracksToObject(info, new boolean[this.objects.size()], null, 0);
        for (ObjectInfo obj : this.objects) {
            obj.getObject().sceneChanged(obj, this);
        }
    }

    public void applyTracksAfterModification(Collection<ObjectInfo> changedObjects) {
        boolean[] changed = new boolean[this.objects.size()];
        boolean[] processed = new boolean[this.objects.size()];
        for (ObjectInfo info : changedObjects) {
            int index = this.indexOf(info);
            processed[index] = true;
            changed[index] = true;
            for (int i = 0; i < info.getTracks().length && (info.getTracks()[i] instanceof ConstraintTrack || info.getTracks()[i] instanceof IKTrack || info.getTracks()[i].isNullTrack()); ++i) {
            }
            for (int j = i - 1; j >= 0; --j) {
                if (!info.getTracks()[j].isEnabled()) continue;
                info.getTracks()[j].apply(this.time);
            }
            if (info.getPose() == null) continue;
            info.getObject().applyPoseKeyframe(info.getPose());
        }
        for (ObjectInfo info : this.objects) {
            this.applyTracksToObject(info, processed, changed, this.indexOf(info));
        }
        for (ObjectInfo info : this.objects) {
            info.getObject().sceneChanged(info, this);
        }
    }

    private void applyTracksToObject(ObjectInfo info, boolean[] processed, boolean[] changed, int index) {
        if (processed[index]) {
            info.getObject().sceneChanged(info, this);
            return;
        }
        processed[index] = true;
        boolean hasPos = false;
        boolean hasRot = false;
        boolean hasPose = false;
        for (Track track : info.getTracks()) {
            if (track.isNullTrack() || !track.isEnabled()) continue;
            ObjectInfo[] depends = track.getDependencies();
            for (int i = 0; i < depends.length; ++i) {
                int k = this.indexOf(depends[i]);
                if (k > -1 && !processed[k]) {
                    this.applyTracksToObject(depends[i], processed, changed, k);
                }
                if (k <= -1 || changed == null || !changed[k]) continue;
                changed[index] = true;
            }
            if (track instanceof PositionTrack || track instanceof ProceduralPositionTrack) {
                hasPos = true;
                continue;
            }
            if (track instanceof RotationTrack || track instanceof ProceduralRotationTrack) {
                hasRot = true;
                continue;
            }
            if (!(track instanceof PoseTrack) && !(track instanceof IKTrack)) continue;
            hasPose = true;
        }
        if (changed != null && !changed[index]) {
            return;
        }
        if (hasPos) {
            Vec3 orig = info.getCoords().getOrigin();
            orig.set(0.0, 0.0, 0.0);
            info.getCoords().setOrigin(orig);
        }
        if (hasRot) {
            info.getCoords().setOrientation(0.0, 0.0, 0.0);
        }
        if (hasPose) {
            info.clearCachedMeshes();
        }
        info.setPose(null);
        info.clearDistortion();
        for (int j = info.getTracks().length - 1; j >= 0; --j) {
            if (!info.getTracks()[j].isEnabled()) continue;
            info.getTracks()[j].apply(this.time);
        }
        if (info.getPose() != null) {
            info.getObject().applyPoseKeyframe(info.getPose());
        }
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public void setFramesPerSecond(int n) {
        this.framesPerSecond = n;
    }

    public RGBColor getAmbientColor() {
        return this.ambientColor;
    }

    public void setAmbientColor(RGBColor color) {
        this.ambientColor = color;
    }

    public int getEnvironmentMode() {
        return this.environMode;
    }

    public void setEnvironmentMode(int mode) {
        this.environMode = mode;
    }

    public Texture getEnvironmentTexture() {
        return this.environTexture;
    }

    public void setEnvironmentTexture(Texture tex) {
        this.environTexture = tex;
    }

    public TextureMapping getEnvironmentMapping() {
        return this.environMapping;
    }

    public void setEnvironmentMapping(TextureMapping map) {
        this.environMapping = map;
    }

    public ParameterValue[] getEnvironmentParameterValues() {
        return this.environParamValue;
    }

    public void setEnvironmentParameterValues(ParameterValue[] value) {
        this.environParamValue = value;
    }

    public RGBColor getEnvironmentColor() {
        return this.environColor;
    }

    public void setEnvironmentColor(RGBColor color) {
        this.environColor = color;
    }

    public RGBColor getFogColor() {
        return this.fogColor;
    }

    public void setFogColor(RGBColor color) {
        this.fogColor = color;
    }

    public boolean getFogState() {
        return this.fog;
    }

    public double getFogDistance() {
        return this.fogDist;
    }

    public void setFog(boolean state, double dist) {
        this.fog = state;
        this.fogDist = dist;
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean show) {
        this.showGrid = show;
    }

    public boolean getSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snap) {
        this.snapToGrid = snap;
    }

    public double getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacing(double spacing) {
        this.gridSpacing = spacing;
    }

    public int getGridSubdivisions() {
        return this.gridSubdivisions;
    }

    public void setGridSubdivisions(int subdivisions) {
        this.gridSubdivisions = subdivisions;
    }

    public void addObject(Object3D obj, CoordinateSystem coords, String name, UndoRecord undo) {
        this.addObject(new ObjectInfo(obj, coords, name), undo);
    }

    public void addObject(ObjectInfo info, UndoRecord undo) {
        this.addObject(info, this.objects.size(), undo);
    }

    public void addObject(ObjectInfo info, int index, UndoRecord undo) {
        info.setId(this.nextID++);
        if (info.getTracks() == null) {
            info.addTrack(new PositionTrack(info), 0);
            info.addTrack(new RotationTrack(info), 1);
        }
        if (info.getObject().canSetTexture() && info.getObject().getTextureMapping() == null) {
            info.setTexture(this.getDefaultTexture(), this.getDefaultTexture().getDefaultMapping(info.getObject()));
        }
        info.getObject().sceneChanged(info, this);
        this.objects.insertElementAt(info, index);
        this.objectIndexMap = null;
        if (undo != null) {
            undo.addCommandAtBeginning(5, new Object[]{index});
        }
        this.updateSelectionInfo();
    }

    public void removeObject(int which, UndoRecord undo) {
        ObjectInfo info = this.objects.elementAt(which);
        this.objects.removeElementAt(which);
        this.objectIndexMap = null;
        if (undo != null) {
            undo.addCommandAtBeginning(4, new Object[]{info, which});
        }
        if (info.getParent() != null) {
            int j = 0;
            while (info.getParent().getChildren()[j] != info) {
                ++j;
            }
            if (undo != null) {
                undo.addCommandAtBeginning(7, new Object[]{info.getParent(), info, j});
            }
            info.getParent().removeChild(j);
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = this.objects.elementAt(i);
            for (int j = 0; j < obj.getTracks().length; ++j) {
                Track tr = obj.getTracks()[j];
                ObjectInfo[] depends = tr.getDependencies();
                for (int k = 0; k < depends.length; ++k) {
                    if (depends[k] != info) continue;
                    if (undo != null) {
                        undo.addCommandAtBeginning(12, new Object[]{tr, tr.duplicate(tr.getParent())});
                    }
                    obj.getTracks()[j].deleteDependencies(info);
                }
            }
        }
        this.clearSelection();
    }

    public void addMaterial(Material mat) {
        this.addMaterial(mat, this.materials.size());
    }

    public void addMaterial(Material mat, int index) {
        this.materials.add(index, mat);
        for (int i = 0; i < this.materialListeners.size(); ++i) {
            this.materialListeners.elementAt(i).itemAdded(this.materials.size() - 1, mat);
        }
    }

    public void removeMaterial(int which) {
        int i;
        Material mat = this.materials.elementAt(which);
        this.materials.removeElementAt(which);
        for (i = 0; i < this.materialListeners.size(); ++i) {
            this.materialListeners.elementAt(i).itemRemoved(which, mat);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = this.objects.elementAt(i);
            if (obj.getObject().getMaterial() != mat) continue;
            obj.setMaterial(null, null);
        }
    }

    public void reorderMaterial(int oldIndex, int newIndex) {
        if (newIndex < 0 || newIndex >= this.materials.size()) {
            throw new IllegalArgumentException("Illegal value for newIndex: " + newIndex);
        }
        Material mat = this.materials.remove(oldIndex);
        this.materials.add(newIndex, mat);
    }

    public void addTexture(Texture tex) {
        this.addTexture(tex, this.textures.size());
    }

    public void addTexture(Texture tex, int index) {
        this.textures.add(index, tex);
        for (int i = 0; i < this.textureListeners.size(); ++i) {
            this.textureListeners.elementAt(i).itemAdded(this.textures.size() - 1, tex);
        }
    }

    public void removeTexture(int which) {
        int i;
        Texture tex = this.textures.elementAt(which);
        this.textures.removeElementAt(which);
        for (int i2 = 0; i2 < this.textureListeners.size(); ++i2) {
            this.textureListeners.elementAt(i2).itemRemoved(which, tex);
        }
        if (this.textures.isEmpty()) {
            UniformTexture defTex = new UniformTexture();
            defTex.setName("Default Texture");
            this.textures.addElement(defTex);
            for (i = 0; i < this.textureListeners.size(); ++i) {
                this.textureListeners.elementAt(i).itemAdded(0, defTex);
            }
        }
        Texture def = this.textures.elementAt(0);
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = this.objects.elementAt(i);
            if (obj.getObject().getTexture() == tex) {
                obj.setTexture(def, def.getDefaultMapping(obj.getObject()));
            }
            if (!(obj.getObject().getTextureMapping() instanceof LayeredMapping)) continue;
            LayeredMapping map = (LayeredMapping)obj.getObject().getTextureMapping();
            for (int j = map.getNumLayers() - 1; j >= 0; --j) {
                if (map.getLayer(j) != tex) continue;
                map.deleteLayer(j);
            }
            obj.setTexture(obj.getObject().getTexture(), map);
        }
        if (this.environTexture == tex) {
            this.environTexture = def;
            this.environMapping = def.getDefaultMapping(new Sphere(1.0, 1.0, 1.0));
        }
        if (this.environMapping instanceof LayeredMapping) {
            Sphere tempObject = new Sphere(1.0, 1.0, 1.0);
            tempObject.setTexture(this.environTexture, this.environMapping);
            tempObject.setParameterValues(this.environParamValue);
            LayeredMapping map = (LayeredMapping)this.environMapping;
            for (int j = map.getNumLayers() - 1; j >= 0; --j) {
                if (map.getLayer(j) != tex) continue;
                map.deleteLayer(j);
            }
            tempObject.setTexture(this.environTexture, this.environMapping);
            this.environParamValue = tempObject.getParameterValues();
        }
    }

    public void reorderTexture(int oldIndex, int newIndex) {
        if (newIndex < 0 || newIndex >= this.textures.size()) {
            throw new IllegalArgumentException("Illegal value for newIndex: " + newIndex);
        }
        Texture tex = this.textures.remove(oldIndex);
        this.textures.add(newIndex, tex);
    }

    public void changeMaterial(int which) {
        int i;
        Material mat = this.materials.elementAt(which);
        for (i = 0; i < this.objects.size(); ++i) {
            Object3D obj = this.objects.elementAt(i).getObject();
            if (obj.getMaterial() != mat) continue;
            obj.setMaterial(mat, obj.getMaterialMapping());
        }
        for (i = 0; i < this.materialListeners.size(); ++i) {
            this.materialListeners.elementAt(i).itemChanged(which, mat);
        }
    }

    public void changeTexture(int which) {
        int i;
        Texture tex = this.textures.elementAt(which);
        block0: for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo obj = this.objects.elementAt(i);
            if (obj.getObject().getTexture() == tex) {
                obj.setTexture(tex, obj.getObject().getTextureMapping());
                continue;
            }
            if (!(obj.getObject().getTexture() instanceof LayeredTexture)) continue;
            for (Texture layer : ((LayeredMapping)obj.getObject().getTextureMapping()).getLayers()) {
                if (layer != tex) continue;
                obj.setTexture(tex, obj.getObject().getTextureMapping());
                continue block0;
            }
        }
        for (i = 0; i < this.textureListeners.size(); ++i) {
            this.textureListeners.elementAt(i).itemChanged(which, tex);
        }
    }

    public void addMaterialListener(ListChangeListener ls) {
        this.materialListeners.addElement(ls);
    }

    public void removeMaterialListener(ListChangeListener ls) {
        this.materialListeners.removeElement(ls);
    }

    public void addTextureListener(ListChangeListener ls) {
        this.textureListeners.addElement(ls);
    }

    public void removeTextureListener(ListChangeListener ls) {
        this.textureListeners.removeElement(ls);
    }

    public Object getMetadata(String name) {
        return this.metadataMap.get(name);
    }

    public void setMetadata(String name, Object value) {
        this.metadataMap.put(name, value);
    }

    public Set<String> getAllMetadataNames() {
        return this.metadataMap.keySet();
    }

    @Deprecated
    public void showTexturesDialog(EditingWindow parent) {
        ((LayoutWindow)parent).showTexturesDialog(this);
    }

    public void addImage(ImageMap im) {
        this.images.addElement(im);
    }

    public boolean removeImage(int which) {
        int i;
        ImageMap image = this.images.elementAt(which);
        for (i = 0; i < this.textures.size(); ++i) {
            if (!this.textures.elementAt(i).usesImage(image)) continue;
            return false;
        }
        for (i = 0; i < this.materials.size(); ++i) {
            if (!this.materials.elementAt(i).usesImage(image)) continue;
            return false;
        }
        this.images.removeElementAt(which);
        return true;
    }

    public void replaceImage(int which, ImageMap im) {
        this.images.set(which, im);
    }

    public void replaceObject(Object3D original, Object3D replaceWith, UndoRecord undo) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = this.objects.elementAt(i);
            if (info.getObject() != original) continue;
            if (undo != null) {
                undo.addCommand(3, new Object[]{info, original});
            }
            info.setObject(replaceWith);
            info.clearCachedMeshes();
        }
    }

    public void objectModified(Object3D obj) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = this.objects.elementAt(i);
            if (info.getObject() != obj) continue;
            info.clearCachedMeshes();
            info.setPose(null);
        }
    }

    public void setSelection(int which) {
        this.clearSelection();
        this.addToSelection(which);
        this.updateSelectionInfo();
    }

    public void setSelection(int[] which) {
        this.clearSelection();
        for (int index : which) {
            ObjectInfo info = this.objects.elementAt(index);
            if (!info.selected) {
                this.selection.addElement(index);
            }
            info.selected = true;
        }
        this.updateSelectionInfo();
    }

    public void addToSelection(int which) {
        ObjectInfo info = this.objects.elementAt(which);
        if (!info.selected) {
            this.selection.addElement(which);
        }
        info.selected = true;
        this.updateSelectionInfo();
    }

    public void clearSelection() {
        if (this.selection.size() == 0) {
            return;
        }
        this.selection.removeAllElements();
        for (int i = 0; i < this.objects.size(); ++i) {
            this.objects.elementAt((int)i).selected = false;
        }
        this.updateSelectionInfo();
    }

    public void removeFromSelection(int which) {
        ObjectInfo info = this.objects.elementAt(which);
        this.selection.removeElement(which);
        info.selected = false;
        this.updateSelectionInfo();
    }

    private void updateSelectionInfo() {
        int i;
        for (i = this.objects.size() - 1; i >= 0; --i) {
            this.objects.elementAt((int)i).parentSelected = false;
        }
        block1: for (i = this.objects.size() - 1; i >= 0; --i) {
            ObjectInfo info = this.objects.elementAt(i);
            for (ObjectInfo parent = info.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.selected && !parent.parentSelected) continue;
                info.parentSelected = true;
                continue block1;
            }
        }
    }

    public int getNumObjects() {
        return this.objects.size();
    }

    public ObjectInfo getObject(int i) {
        return this.objects.elementAt(i);
    }

    public ObjectInfo getObject(String name) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = this.objects.elementAt(i);
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public ObjectInfo getObjectById(int id) {
        for (int i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = this.objects.elementAt(i);
            if (info.getId() != id) continue;
            return info;
        }
        return null;
    }

    @Deprecated
    public List<ObjectInfo> getAllObjects() {
        return Collections.unmodifiableList(this.objects);
    }

    public List<ObjectInfo> getObjects() {
        return Collections.unmodifiableList(this.objects);
    }

    public int indexOf(ObjectInfo info) {
        Integer index;
        if (this.objectIndexMap == null) {
            this.objectIndexMap = new HashMap();
            for (int i = 0; i < this.objects.size(); ++i) {
                this.objectIndexMap.put(this.objects.get(i), i);
            }
        }
        return (index = this.objectIndexMap.get(info)) == null ? -1 : index;
    }

    public int getNumTextures() {
        return this.textures.size();
    }

    public List<ObjectInfo> getCameras() {
        ArrayList<ObjectInfo> list = new ArrayList<ObjectInfo>();
        for (ObjectInfo sceneObject : this.objects) {
            if (!(sceneObject.getObject() instanceof SceneCamera)) continue;
            list.add(sceneObject);
        }
        return list;
    }

    public int indexOf(Texture tex) {
        return this.textures.indexOf(tex);
    }

    public Texture getTexture(int i) {
        return this.textures.elementAt(i);
    }

    public Texture getTexture(String name) {
        for (int i = 0; i < this.textures.size(); ++i) {
            Texture tex = this.textures.elementAt(i);
            if (!tex.getName().equals(name)) continue;
            return tex;
        }
        return null;
    }

    public int getNumMaterials() {
        return this.materials.size();
    }

    public Material getMaterial(int i) {
        return this.materials.elementAt(i);
    }

    public Material getMaterial(String name) {
        for (int i = 0; i < this.materials.size(); ++i) {
            Material mat = this.materials.elementAt(i);
            if (!mat.getName().equals(name)) continue;
            return mat;
        }
        return null;
    }

    public int indexOf(Material mat) {
        return this.materials.indexOf(mat);
    }

    public int getNumImages() {
        return this.images.size();
    }

    public ImageMap getImage(int i) {
        return this.images.elementAt(i);
    }

    public int indexOf(ImageMap im) {
        return this.images.indexOf(im);
    }

    public Texture getDefaultTexture() {
        return this.textures.elementAt(0);
    }

    public int[] getSelection() {
        int[] sel = new int[this.selection.size()];
        for (int i = 0; i < sel.length; ++i) {
            sel[i] = this.selection.elementAt(i);
        }
        return sel;
    }

    public int[] getSelectionWithChildren() {
        int count = 0;
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            ObjectInfo info = this.objects.elementAt(i);
            if (!info.selected && !info.parentSelected) continue;
            ++count;
        }
        int[] sel = new int[count];
        count = 0;
        for (int i = this.objects.size() - 1; i >= 0; --i) {
            ObjectInfo info = this.objects.elementAt(i);
            if (!info.selected && !info.parentSelected) continue;
            sel[count++] = i;
        }
        return sel;
    }

    public boolean errorsOccurredInLoading() {
        return this.errorsLoading;
    }

    public String getLoadingErrors() {
        return this.loadingErrors == null ? "" : this.loadingErrors.toString();
    }

    public Scene(File f, boolean fullScene) throws IOException, InvalidObjectException {
        DataInputStream in;
        this.setName(f.getName());
        this.setDirectory(f.getParent());
        BufferedInputStream buf = new BufferedInputStream(new FileInputStream(f));
        buf.mark(FILE_PREFIX.length);
        boolean hasPrefix = true;
        for (int i = 0; hasPrefix && i < FILE_PREFIX.length; hasPrefix &= buf.read() == FILE_PREFIX[i], ++i) {
        }
        if (!hasPrefix) {
            buf.reset();
        }
        try {
            in = new DataInputStream(new GZIPInputStream(buf));
        }
        catch (IOException ex) {
            buf.close();
            buf = new BufferedInputStream(new FileInputStream(f));
            in = new DataInputStream(buf);
        }
        this.initFromStream(in, fullScene);
        in.close();
    }

    public Scene(DataInputStream in, boolean fullScene) throws IOException, InvalidObjectException {
        this.initFromStream(in, fullScene);
    }

    private void initFromStream(DataInputStream in, boolean fullScene) throws IOException, InvalidObjectException {
        byte[] bytes;
        int len;
        Constructor con;
        Class cls;
        String classname;
        int i;
        short version = in.readShort();
        if (version < 0 || version > 4) {
            throw new InvalidObjectException("");
        }
        this.loadingErrors = new StringBuffer();
        this.ambientColor = new RGBColor(in);
        this.fogColor = new RGBColor(in);
        this.fog = in.readBoolean();
        this.fogDist = in.readDouble();
        this.showGrid = in.readBoolean();
        this.snapToGrid = in.readBoolean();
        this.gridSpacing = in.readDouble();
        this.gridSubdivisions = in.readInt();
        this.framesPerSecond = in.readInt();
        this.nextID = 1;
        int count = in.readInt();
        this.images = new Vector(count);
        for (i = 0; i < count; ++i) {
            if (version == 0) {
                this.images.addElement(new MIPMappedImage(in, 0));
                continue;
            }
            classname = in.readUTF();
            try {
                cls = ArtOfIllusion.getClass(classname);
                if (cls == null) {
                    throw new IOException("Unknown class: " + classname);
                }
                con = cls.getConstructor(DataInputStream.class);
                this.images.addElement((ImageMap)con.newInstance(in));
                continue;
            }
            catch (Exception ex) {
                throw new IOException("Error loading image: " + ex.getMessage());
            }
        }
        count = in.readInt();
        this.materials = new Vector(count);
        for (i = 0; i < count; ++i) {
            try {
                classname = in.readUTF();
                len = in.readInt();
                bytes = new byte[len];
                in.readFully(bytes);
                cls = ArtOfIllusion.getClass(classname);
                try {
                    if (cls == null) {
                        throw new IOException("Unknown class: " + classname);
                    }
                    con = cls.getConstructor(DataInputStream.class, Scene.class);
                    this.materials.addElement((Material)con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (ex instanceof ClassNotFoundException) {
                        this.loadingErrors.append(Translate.text("errorFindingClass", (Object)classname)).append('\n');
                    } else {
                        this.loadingErrors.append(Translate.text("errorInstantiatingClass", (Object)classname)).append('\n');
                    }
                    UniformMaterial m = new UniformMaterial();
                    m.setName("<unreadable>");
                    this.materials.addElement(m);
                    this.errorsLoading = true;
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
        count = in.readInt();
        this.textures = new Vector(count);
        for (i = 0; i < count; ++i) {
            try {
                classname = in.readUTF();
                len = in.readInt();
                bytes = new byte[len];
                in.readFully(bytes);
                cls = ArtOfIllusion.getClass(classname);
                try {
                    if (cls == null) {
                        throw new IOException("Unknown class: " + classname);
                    }
                    con = cls.getConstructor(DataInputStream.class, Scene.class);
                    this.textures.addElement((Texture)con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (ex instanceof ClassNotFoundException) {
                        this.loadingErrors.append(Translate.text("errorFindingClass", (Object)classname)).append('\n');
                    } else {
                        this.loadingErrors.append(Translate.text("errorInstantiatingClass", (Object)classname)).append('\n');
                    }
                    UniformTexture t = new UniformTexture();
                    t.setName("<unreadable>");
                    this.textures.addElement(t);
                    this.errorsLoading = true;
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
        count = in.readInt();
        this.objects = new Vector(count);
        Hashtable<Integer, Object3D> table = new Hashtable<Integer, Object3D>(count);
        for (i = 0; i < count; ++i) {
            this.objects.addElement(this.readObjectFromFile(in, table, version));
        }
        this.objectIndexMap = null;
        this.selection = new Vector();
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = this.objects.elementAt(i);
            int num = in.readInt();
            for (int j = 0; j < num; ++j) {
                ObjectInfo child = this.objects.elementAt(in.readInt());
                info.addChild(child, j);
            }
        }
        this.environMode = in.readShort();
        if (this.environMode == 0) {
            this.environColor = new RGBColor(in);
            this.environTexture = this.textures.elementAt(0);
            this.environMapping = this.environTexture.getDefaultMapping(new Sphere(1.0, 1.0, 1.0));
            this.environParamValue = new ParameterValue[0];
        } else {
            int texIndex = in.readInt();
            if (texIndex == -1) {
                Sphere sphere = new Sphere(1.0, 1.0, 1.0);
                this.environTexture = new LayeredTexture(sphere);
                String mapClassName = in.readUTF();
                if (!LayeredMapping.class.getName().equals(mapClassName)) {
                    throw new InvalidObjectException("");
                }
                this.environMapping = this.environTexture.getDefaultMapping(sphere);
                ((LayeredMapping)this.environMapping).readFromFile(in, this);
            } else {
                this.environTexture = this.textures.elementAt(texIndex);
                try {
                    Class mapClass = ArtOfIllusion.getClass(in.readUTF());
                    con = mapClass.getConstructor(DataInputStream.class, Object3D.class, Texture.class);
                    this.environMapping = (TextureMapping)con.newInstance(in, new Sphere(1.0, 1.0, 1.0), this.environTexture);
                }
                catch (Exception ex) {
                    throw new IOException();
                }
            }
            this.environColor = new RGBColor(0.0f, 0.0f, 0.0f);
            this.environParamValue = new ParameterValue[this.environMapping.getParameters().length];
            if (version > 2) {
                for (int i2 = 0; i2 < this.environParamValue.length; ++i2) {
                    this.environParamValue[i2] = Object3D.readParameterValue(in);
                }
            }
        }
        this.metadataMap = new HashMap();
        if (version > 3) {
            count = in.readInt();
            SearchlistClassLoader loader = new SearchlistClassLoader(this.getClass().getClassLoader());
            for (ClassLoader cl : PluginRegistry.getPluginClassLoaders()) {
                loader.add(cl);
            }
            for (int i3 = 0; i3 < count; ++i3) {
                try {
                    String name = in.readUTF();
                    byte[] data = new byte[in.readInt()];
                    in.readFully(data);
                    XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(data), null, null, (ClassLoader)loader);
                    this.metadataMap.put(name, decoder.readObject());
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.textureListeners = new Vector();
        this.materialListeners = new Vector();
        this.setTime(0.0);
    }

    private ObjectInfo readObjectFromFile(DataInputStream in, Hashtable<Integer, Object3D> table, int version) throws IOException, InvalidObjectException {
        Constructor con;
        Class cls;
        ObjectInfo info = new ObjectInfo(null, new CoordinateSystem(in), in.readUTF());
        info.setId(in.readInt());
        if (info.getId() >= this.nextID) {
            this.nextID = info.getId() + 1;
        }
        info.setVisible(in.readBoolean());
        Integer key = in.readInt();
        Object3D obj = table.get(key);
        if (obj == null) {
            try {
                String classname = in.readUTF();
                int len = in.readInt();
                byte[] bytes = new byte[len];
                in.readFully(bytes);
                try {
                    cls = ArtOfIllusion.getClass(classname);
                    con = cls.getConstructor(DataInputStream.class, Scene.class);
                    obj = (Object3D)con.newInstance(new DataInputStream(new ByteArrayInputStream(bytes)), this);
                }
                catch (Exception ex) {
                    if (ex instanceof InvocationTargetException) {
                        ((InvocationTargetException)ex).getTargetException().printStackTrace();
                    } else {
                        ex.printStackTrace();
                    }
                    if (ex instanceof ClassNotFoundException) {
                        this.loadingErrors.append(info.getName()).append(": ").append(Translate.text("errorFindingClass", (Object)classname)).append('\n');
                    } else {
                        this.loadingErrors.append(info.getName()).append(": ").append(Translate.text("errorInstantiatingClass", (Object)classname)).append('\n');
                    }
                    obj = new NullObject();
                    info.setName("<unreadable> " + info.getName());
                    this.errorsLoading = true;
                }
                table.put(key, obj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
        info.setObject(obj);
        if (version < 2 && obj.getTexture() != null) {
            int i;
            TextureParameter[] texParam = obj.getTextureMapping().getParameters();
            ParameterValue[] paramValue = obj.getParameterValues();
            double[] val = new double[paramValue.length];
            boolean[] perVertex = new boolean[paramValue.length];
            for (i = 0; i < val.length; ++i) {
                val[i] = in.readDouble();
            }
            for (i = 0; i < perVertex.length; ++i) {
                perVertex[i] = in.readBoolean();
            }
            for (i = 0; i < paramValue.length; ++i) {
                if (paramValue[i] != null) continue;
                paramValue[i] = perVertex[i] ? new VertexParameterValue((Mesh)((Object)obj), texParam[i]) : new ConstantParameterValue(val[i]);
            }
            obj.setParameterValues(paramValue);
        }
        int tracks = in.readInt();
        try {
            for (int i = 0; i < tracks; ++i) {
                cls = ArtOfIllusion.getClass(in.readUTF());
                con = cls.getConstructor(ObjectInfo.class);
                Track tr = (Track)con.newInstance(info);
                tr.initFromStream(in, this);
                info.addTrack(tr, i);
            }
            if (info.getTracks() == null) {
                info.tracks = new Track[0];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        return info;
    }

    public void writeToFile(File f) throws IOException {
        int mode = ArtOfIllusion.getPreferences().getKeepBackupFiles() ? 128 : 0;
        SafeFileOutputStream safeOut = new SafeFileOutputStream(f, mode);
        BufferedOutputStream bout = new BufferedOutputStream(safeOut);
        bout.write(FILE_PREFIX);
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream(bout));
        this.writeToStream(out);
        out.close();
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        byte[] bytes;
        ByteArrayOutputStream bos;
        int i;
        int index = 0;
        Hashtable<Object3D, Integer> table = new Hashtable<Object3D, Integer>(this.objects.size());
        out.writeShort(4);
        this.ambientColor.writeToFile(out);
        this.fogColor.writeToFile(out);
        out.writeBoolean(this.fog);
        out.writeDouble(this.fogDist);
        out.writeBoolean(this.showGrid);
        out.writeBoolean(this.snapToGrid);
        out.writeDouble(this.gridSpacing);
        out.writeInt(this.gridSubdivisions);
        out.writeInt(this.framesPerSecond);
        out.writeInt(this.images.size());
        for (i = 0; i < this.images.size(); ++i) {
            ImageMap img = this.images.elementAt(i);
            out.writeUTF(img.getClass().getName());
            if (img.getClass() == ExternalImage.class) {
                ((ExternalImage)img).writeToStream(out, this);
                continue;
            }
            img.writeToStream(out);
        }
        out.writeInt(this.materials.size());
        for (i = 0; i < this.materials.size(); ++i) {
            Material mat = this.materials.elementAt(i);
            out.writeUTF(mat.getClass().getName());
            bos = new ByteArrayOutputStream();
            mat.writeToFile(new DataOutputStream(bos), this);
            bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
        }
        out.writeInt(this.textures.size());
        for (i = 0; i < this.textures.size(); ++i) {
            Texture tex = this.textures.elementAt(i);
            out.writeUTF(tex.getClass().getName());
            bos = new ByteArrayOutputStream();
            tex.writeToFile(new DataOutputStream(bos), this);
            bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
        }
        out.writeInt(this.objects.size());
        for (i = 0; i < this.objects.size(); ++i) {
            index = this.writeObjectToFile(out, this.objects.elementAt(i), table, index);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            ObjectInfo info = this.objects.elementAt(i);
            out.writeInt(info.getChildren().length);
            for (int j = 0; j < info.getChildren().length; ++j) {
                out.writeInt(this.indexOf(info.getChildren()[j]));
            }
        }
        out.writeShort((short)this.environMode);
        if (this.environMode == 0) {
            this.environColor.writeToFile(out);
        } else {
            out.writeInt(this.textures.lastIndexOf(this.environTexture));
            out.writeUTF(this.environMapping.getClass().getName());
            if (this.environMapping instanceof LayeredMapping) {
                ((LayeredMapping)this.environMapping).writeToFile(out, this);
            } else {
                this.environMapping.writeToFile(out);
            }
            for (i = 0; i < this.environParamValue.length; ++i) {
                out.writeUTF(this.environParamValue[i].getClass().getName());
                this.environParamValue[i].writeToStream(out);
            }
        }
        out.writeInt(this.metadataMap.size());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        SearchlistClassLoader loader = new SearchlistClassLoader(this.getClass().getClassLoader());
        for (ClassLoader cl : PluginRegistry.getPluginClassLoaders()) {
            loader.add(cl);
        }
        Thread.currentThread().setContextClassLoader(loader);
        ExceptionListener exceptionListener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        };
        for (Map.Entry<String, Object> entry : this.metadataMap.entrySet()) {
            ByteArrayOutputStream value = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(value);
            encoder.setExceptionListener(exceptionListener);
            encoder.writeObject(entry.getValue());
            encoder.close();
            out.writeUTF(entry.getKey());
            out.writeInt(value.size());
            out.write(value.toByteArray());
        }
        Thread.currentThread().setContextClassLoader(contextClassLoader);
    }

    private int writeObjectToFile(DataOutputStream out, ObjectInfo info, Hashtable<Object3D, Integer> table, int index) throws IOException {
        info.getCoords().writeToFile(out);
        out.writeUTF(info.getName());
        out.writeInt(info.getId());
        out.writeBoolean(info.isVisible());
        Integer key = table.get(info.getObject());
        if (key == null) {
            out.writeInt(index);
            out.writeUTF(info.getObject().getClass().getName());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            info.getObject().writeToFile(new DataOutputStream(bos), this);
            byte[] bytes = bos.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes, 0, bytes.length);
            key = index++;
            table.put(info.getObject(), key);
        } else {
            out.writeInt(key);
        }
        out.writeInt(info.getTracks().length);
        for (int i = 0; i < info.getTracks().length; ++i) {
            out.writeUTF(info.getTracks()[i].getClass().getName());
            info.getTracks()[i].writeToStream(out, this);
        }
        return index;
    }
}

