/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ArtOfIllusion;
import artofillusion.Camera;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import buoy.event.MouseScrolledEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class ScrollViewTool {
    private EditingWindow window;
    private ViewerCanvas view;
    private Camera camera;
    private double distToPlane;
    private double scrollRadius;
    private double scrollBlend;
    private double scrollBlendX;
    private double scrollBlendY;
    private int navigationMode;
    private int scrollSteps;
    private int startOrientation;
    private Vec3 startZ;
    private Vec3 startUp;
    private Rectangle bounds;
    private Point mousePoint;
    private CoordinateSystem startCoords;
    private ObjectInfo boundCamera;
    private Timer scrollTimer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ScrollViewTool.this.scrollTimer.stop();
            ((ScrollViewTool)ScrollViewTool.this).view.scrolling = false;
            ((ScrollViewTool)ScrollViewTool.this).view.mousePoint = null;
            ScrollViewTool.this.mouseStoppedScrolling();
        }
    });

    public ScrollViewTool(EditingWindow ew) {
        this.window = ew;
        this.scrollTimer.setCoalesce(false);
    }

    protected void mouseScrolled(MouseScrolledEvent e, ViewerCanvas v) {
        this.scrollSteps = v.scrollBuffer;
        v.scrollBuffer = 0;
        v.mouseMoving = false;
        this.view = v;
        this.view.scrolling = true;
        this.distToPlane = this.view.getDistToPlane();
        this.navigationMode = this.view.getNavigationMode();
        this.bounds = this.view.getBounds();
        this.camera = this.view.getCamera();
        this.boundCamera = this.view.getBoundCamera();
        if (!this.scrollTimer.isRunning()) {
            this.startCoords = this.camera.getCameraCoordinates().duplicate();
        }
        CoordinateSystem coords = this.camera.getCameraCoordinates();
        this.startZ = new Vec3(coords.getZDirection());
        this.startUp = new Vec3(coords.getUpDirection());
        this.view.setRotationCenter(coords.getOrigin().plus(this.startZ.times(this.distToPlane)));
        this.mousePoint = this.view.mousePoint = e.getPoint();
        this.scrollTimer.restart();
        switch (this.navigationMode) {
            case 0: 
            case 1: {
                this.scrollMoveModel(e);
                break;
            }
            case 2: 
            case 3: {
                this.scrollMoveTravel(e);
                break;
            }
        }
        if (this.boundCamera != null) {
            this.boundCamera.getCoords().copyCoords(this.view.getCamera().getCameraCoordinates());
        }
        this.view.frustumShape.update();
        if (ArtOfIllusion.getPreferences().getDrawActiveFrustum() || ArtOfIllusion.getPreferences().getDrawCameraFrustum() && this.view.getBoundCamera() != null) {
            this.window.updateImage();
        } else {
            this.view.repaint();
        }
        this.view.viewChanged(false);
    }

    private void scrollMoveModel(MouseScrolledEvent e) {
        int amount = e.getWheelRotation();
        if (!e.isAltDown()) {
            amount *= 10;
        }
        if (ArtOfIllusion.getPreferences().getReverseZooming()) {
            amount *= -1;
        }
        if (this.view.isPerspective()) {
            this.distToPlane *= Math.pow(1.01, amount);
        } else {
            this.view.setScale(this.view.getScale() * Math.pow(0.9900990099009901, amount));
            this.distToPlane = this.camera.getDistToScreen() * 100.0 / this.view.getScale();
            this.camera.setScreenParamsParallel(this.view.getScale(), this.bounds.width, this.bounds.height);
        }
        CoordinateSystem coords = this.camera.getCameraCoordinates();
        Vec3 newPos = this.view.getRotationCenter().plus(coords.getZDirection().times(-this.distToPlane));
        coords.setOrigin(newPos);
        this.camera.setCameraCoordinates(coords);
        this.view.setDistToPlane(this.distToPlane);
    }

    private void scrollMoveTravel(MouseScrolledEvent e) {
        Vec3 newPos;
        int amount = e.getWheelRotation();
        if (!e.isAltDown()) {
            amount *= 10;
        }
        if (ArtOfIllusion.getPreferences().getReverseZooming()) {
            amount *= -1;
        }
        Point scrollPoint = e.getPoint();
        int cx = this.bounds.width / 2;
        int cy = this.bounds.height / 2;
        int d = Math.min(this.bounds.width, this.bounds.height);
        CoordinateSystem coords = this.camera.getCameraCoordinates().duplicate();
        if (this.navigationMode == 2) {
            int rx = scrollPoint.x - cx;
            int ry = scrollPoint.y - cy;
            this.scrollRadius = Math.sqrt(rx * rx + ry * ry);
            if (this.scrollRadius < 0.1 * (double)d) {
                this.scrollRadius = 0.1 * (double)d;
            }
            if (this.scrollRadius > 0.4 * (double)d) {
                this.scrollRadius = 0.4 * (double)d;
            }
            this.scrollBlend = (this.scrollRadius - 0.1 * (double)d) / (0.3 * (double)d);
            Vec3 axis = new Vec3(-ry, rx, 0.0);
            axis.normalize();
            axis = this.camera.getViewToWorld().timesDirection(axis);
            double angle = this.scrollRadius * this.scrollBlend * (double)amount * 2.0E-5;
            double deltaZ = -this.distToPlane * 0.01 * (double)amount * (1.0 - this.scrollBlend);
            double deltaY = 0.0;
            Vec3 location = coords.getOrigin();
            coords.transformCoordinates(Mat4.translation(-location.x, -location.y, -location.z));
            coords.transformCoordinates(Mat4.axisRotation(axis, angle));
            coords.transformCoordinates(Mat4.translation(location.x, location.y, location.z));
            Vec3 oldPos = new Vec3(coords.getOrigin());
            newPos = oldPos.plus(coords.getZDirection().times(deltaZ));
            coords.setOrigin(newPos);
        } else if (this.navigationMode == 3) {
            double scrollX = scrollPoint.x - cx;
            if (Math.abs(scrollX) < 0.1 * (double)d) {
                scrollX = 0.1 * (double)d * Math.signum(scrollX);
            }
            if (Math.abs(scrollX) > 0.4 * (double)d) {
                scrollX = 0.4 * (double)d * Math.signum(scrollX);
            }
            double scrollBlendX = (Math.abs(scrollX) - 0.1 * (double)d) / (0.3 * (double)d);
            double scrollY = scrollPoint.y - cy;
            if (Math.abs(scrollY) < 0.1 * (double)d) {
                scrollY = 0.1 * (double)d * Math.signum(scrollY);
            }
            if (Math.abs(scrollY) > 0.4 * (double)d) {
                scrollY = 0.4 * (double)d * Math.signum(scrollY);
            }
            double scrollBlendY = (Math.abs(scrollY) - 0.1 * (double)d) / (0.3 * (double)d);
            Vec3 axis = new Vec3(0.0, 1.0, 0.0);
            double angle = scrollX * scrollBlendX * (double)amount * 2.0E-5;
            double deltaZ = -this.distToPlane * 0.01 * (double)amount * (1.0 - Math.max(scrollBlendX, scrollBlendY));
            double deltaY = this.distToPlane * 0.002 * (double)amount * scrollBlendY * Math.signum(scrollY);
            Vec3 location = coords.getOrigin();
            coords.transformCoordinates(Mat4.translation(-location.x, -location.y, -location.z));
            coords.transformCoordinates(Mat4.axisRotation(axis, angle));
            coords.transformCoordinates(Mat4.translation(location.x, location.y, location.z));
            Vec3 vDir = new Vec3(0.0, 1.0, 0.0);
            Vec3 hDir = coords.getZDirection().z < 0.0 ? new Vec3(coords.getZDirection().plus(coords.getUpDirection())) : new Vec3(coords.getZDirection().minus(coords.getUpDirection()));
            hDir.y = 0.0;
            hDir.normalize();
            Vec3 oldPos = new Vec3(coords.getOrigin());
            newPos = oldPos.plus(hDir.times(deltaZ));
            newPos = newPos.plus(vDir.times(deltaY));
            coords.setOrigin(newPos);
        } else {
            return;
        }
        if (!(this.boundCamera != null || coords.getZDirection().equals(this.startZ) && coords.getUpDirection().equals(this.startUp))) {
            this.view.setOrientation(Integer.MAX_VALUE);
        }
        this.camera.setCameraCoordinates(coords);
        this.view.setRotationCenter(newPos.plus(coords.getZDirection().times(this.distToPlane)));
    }

    public void mouseStoppedScrolling() {
        if (this.window != null && this.boundCamera != null) {
            UndoRecord undo = new UndoRecord(this.window, false, 1, new Object[]{this.boundCamera.getCoords(), this.startCoords});
            this.moveCameraChildren(this.boundCamera, this.boundCamera.getCoords().fromLocal().times(this.startCoords.toLocal()), undo);
            this.window.setUndoRecord(undo);
        }
        this.window.updateImage();
        this.view.viewChanged(false);
    }

    private void moveCameraChildren(ObjectInfo parent, Mat4 transform, UndoRecord undo) {
        for (int i = 0; i < parent.getChildren().length; ++i) {
            CoordinateSystem coords = parent.getChildren()[i].getCoords();
            CoordinateSystem previousCoords = coords.duplicate();
            coords.transformCoordinates(transform);
            undo.addCommand(1, new Object[]{coords, previousCoords});
            this.moveCameraChildren(parent.getChildren()[i], transform, undo);
        }
    }
}

